/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.opencard.security.GPSCP03SecureChannel;
import de.cardcontact.opencard.security.GPSCPSecureChannelCredential;
import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.globalplatform.SecurityDomainCardService;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.GPSecureChannel;
import de.cardcontact.scdp.gp.GPSecurityDomain;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import opencard.core.service.CardServiceException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.applet.AppletID;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.KDFCounterBytesGenerator;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KDFCounterParameters;
import org.bouncycastle.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPScp03
extends GPSecureChannel {
    private static final long serialVersionUID = 6299742073894014119L;
    private static final String clazzName = "GPScp03";
    private GPSecurityDomain securityDomain = null;
    private byte securityLevel = 0;
    private byte keySetVersion = 0;
    private byte[] hostChallenge;
    private byte[] keyDiversificationData;
    private byte[] keyInformation;
    private byte[] sequenceCounter;
    private byte[] cardChallenge;
    private byte[] cardCryptogram;
    private GPKey encKey = null;
    private GPKey macKey = null;
    private GPKey rmacKey = null;
    private GPKey dekKey = null;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"GPScp03() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        GPScp03 c = new GPScp03();
        ScriptableObject.putProperty((Scriptable)c, (String)"crypto", (Object)args[0]);
        return c;
    }

    public static ByteString jsFunction_initializeUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        byte keyVersion = (byte)ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte keyIndex = (byte)ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        GPCrypto crypto = (GPCrypto)((Object)ScriptableObject.getProperty((Scriptable)thisObj, (String)"crypto"));
        GPScp03 scp = (GPScp03)thisObj;
        ResponseAPDU response = null;
        try {
            byte[] data;
            scp.hostChallenge = crypto.getImpl().generateRandom(8);
            scp.securityDomain.getSecurityDomainCardService();
            response = scp.securityDomain.sdcs.initializeUpdate(keyVersion, keyIndex, scp.hostChallenge);
            if (response.sw() != 36864) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "INITIALIZE UPDATE failed with SW = " + HexString.hexify((int)response.sw()));
            }
            if ((data = response.data()).length != 29 && data.length != 32) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "INITIALIZE UPDATE failed - wrong length of response data (" + data.length + ")");
            }
            scp.keyDiversificationData = new byte[10];
            System.arraycopy(data, 0, scp.keyDiversificationData, 0, scp.keyDiversificationData.length);
            scp.keyInformation = new byte[3];
            System.arraycopy(data, 10, scp.keyInformation, 0, scp.keyInformation.length);
            scp.cardChallenge = new byte[8];
            System.arraycopy(data, 13, scp.cardChallenge, 0, scp.cardChallenge.length);
            scp.cardCryptogram = new byte[8];
            System.arraycopy(data, 21, scp.cardCryptogram, 0, 8);
            if (data.length == 29) {
                scp.sequenceCounter = new byte[0];
            } else {
                scp.sequenceCounter = new byte[3];
                System.arraycopy(data, 29, scp.sequenceCounter, 0, scp.sequenceCounter.length);
            }
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + e);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + e);
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + e);
        }
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"hostChallenge", (Object)((Object)ByteString.newInstance((Scriptable)scp, scp.hostChallenge)));
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"keyVersion", (Object)keyVersion);
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"cardChallenge", (Object)((Object)ByteString.newInstance((Scriptable)scp, scp.cardChallenge)));
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"cardCryptogram", (Object)((Object)ByteString.newInstance((Scriptable)scp, scp.cardCryptogram)));
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"diversificationData", (Object)((Object)ByteString.newInstance((Scriptable)scp, scp.keyDiversificationData)));
        ScriptableObject.putConstProperty((Scriptable)scp, (String)"sequenceCounter", (Object)((Object)ByteString.newInstance((Scriptable)scp, scp.sequenceCounter)));
        return ByteString.newInstance((Scriptable)scp, response.data());
    }

    private byte[] deriveData(byte[] key, byte ddc, byte size, byte[] context) {
        ByteArrayOutputStream dp = new ByteArrayOutputStream();
        try {
            dp.write(new byte[11]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dp.write(ddc);
        dp.write(0);
        dp.write(size << 3 >> 8 & 0xFF);
        dp.write(size << 3 & 0xFF);
        int counter = 8;
        KDFCounterParameters params = new KDFCounterParameters(key, dp.toByteArray(), context, counter);
        byte[] result = new byte[size];
        CMac cmac = new CMac((BlockCipher)new AESEngine());
        KDFCounterBytesGenerator kdf = new KDFCounterBytesGenerator((Mac)cmac);
        kdf.init((DerivationParameters)params);
        kdf.generateBytes(result, 0, result.length);
        return result;
    }

    public static void jsFunction_externalAuthenticate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte level = (byte)ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPScp03 scp03 = (GPScp03)thisObj;
        GPCrypto crypto = (GPCrypto)((Object)ScriptableObject.getProperty((Scriptable)thisObj, (String)"crypto"));
        ResponseAPDU response = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(scp03.hostChallenge);
            bos.write(scp03.cardChallenge);
            byte[] context = bos.toByteArray();
            byte[] mackey = scp03.macKey.getJCEKey("BC").getEncoded();
            byte[] cardCryptogram = scp03.deriveData(mackey, (byte)0, (byte)8, context);
            if (!Arrays.areEqual((byte[])cardCryptogram, (byte[])scp03.cardCryptogram)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Card cryptogram verification failed");
            }
            byte[] hostCryptogram = scp03.deriveData(mackey, (byte)1, (byte)8, context);
            byte[] iv = new byte[16];
            ByteArrayOutputStream extAutAPDUPadded = new ByteArrayOutputStream();
            extAutAPDUPadded.write(iv);
            extAutAPDUPadded.write(-124);
            extAutAPDUPadded.write(-126);
            extAutAPDUPadded.write(level);
            extAutAPDUPadded.write(0);
            extAutAPDUPadded.write(16);
            extAutAPDUPadded.write(hostCryptogram);
            byte[] mac = crypto.getImpl().sign(scp03.macKey, 54, extAutAPDUPadded.toByteArray(), null);
            ByteArrayOutputStream cdata = new ByteArrayOutputStream();
            cdata.write(hostCryptogram);
            cdata.write(mac, 0, 8);
            scp03.securityDomain.getSecurityDomainCardService();
            response = scp03.securityDomain.sdcs.externalAuthenticate(level, cdata.toByteArray());
            if (response.sw() != 36864) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "EXTERNAL AUTHENTICATE failed with SW = " + HexString.hexifyShort((int)response.sw()));
            }
            if (level > 0) {
                GPSCP03SecureChannel sc = new GPSCP03SecureChannel(scp03.encKey.getJCEKey("BC"), scp03.macKey.getJCEKey("BC"), scp03.rmacKey.getJCEKey("BC"), null, mac, level, "BC");
                GPSCPSecureChannelCredential cred = new GPSCPSecureChannelCredential((int)level, (SecureChannel)sc);
                Object o = ScriptableObject.getProperty((Scriptable)scp03.securityDomain, (String)"aid");
                AppletID appletId = null;
                appletId = !(o instanceof ByteString) ? SecurityDomainCardService.ISD_AID : new AppletID(((ByteString)((Object)o)).getBytes());
                IsoCredentialStore store = new IsoCredentialStore();
                store.setSecureChannelCredential((SecurityDomain)appletId, (SecureChannelCredential)cred);
                CredentialBag bag = new CredentialBag();
                bag.addCredentialStore((CredentialStore)store);
                scp03.securityDomain.sdcs.provideCredentials((SecurityDomain)appletId, bag);
                Card card = scp03.securityDomain.getCard();
                card.setCredentialBag((SecurityDomain)appletId, bag);
            }
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE due to memory allocation problems: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        catch (NoSuchProviderException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        catch (GeneralSecurityException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + e);
        }
        scp03.setSecurityLevel(level);
    }

    public static void jsFunction_setEncKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setEncKey()");
        }
        ((GPScp03)thisObj).encKey = (GPKey)((Object)o);
    }

    public static void jsFunction_setMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setMacKey()");
        }
        ((GPScp03)thisObj).macKey = (GPKey)((Object)o);
    }

    public static void jsFunction_setResponseMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setResponseMacKey()");
        }
        ((GPScp03)thisObj).rmacKey = (GPKey)((Object)o);
    }

    public static void jsFunction_setDekKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setMacKey()");
        }
        ((GPScp03)thisObj).dekKey = (GPKey)((Object)o);
    }

    public static GPKey jsFunction_getDekKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScp03)thisObj).dekKey;
    }

    @Override
    public int jsGet_state() {
        return this.getState();
    }

    public int jsGet_securityLevel() {
        return this.securityLevel;
    }

    public void setSecurityDomain(GPSecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setSecurityLevel(byte level) {
        this.securityLevel = level;
    }

    public void setKeySetVersion(byte version) {
        this.keySetVersion = version;
    }

    @Override
    public String getClassName() {
        return clazzName;
    }
}

