/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cms;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.js.JsX509;
import de.cardcontact.scdp.utils.ArgChecker;
import java.security.PrivateKey;
import java.util.ArrayList;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCMSEnvelopedData
extends ScriptableObject {
    private static final long serialVersionUID = 1694539279475829516L;
    static final String clazzName = "CMSEnvelopedData";
    private CMSEnvelopedData ed;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CMSEnvelopedData() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        JsCMSEnvelopedData edo = new JsCMSEnvelopedData();
        ByteString encoded = null;
        if (args[0] instanceof ByteString) {
            encoded = (ByteString)((Object)args[0]);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        try {
            edo.ed = new CMSEnvelopedData(encoded.getBytes());
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "ByteString contains no valid encoded CMS enveloped data object");
        }
        return edo;
    }

    public static Scriptable jsFunction_getContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        GPKey privateKey;
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument 1 must be a key.");
        }
        if ((privateKey = (GPKey)((Object)args[0])).getKeyType() != 2) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument 1 must be a private key.");
        }
        JceKeyTransRecipientId rid = null;
        if (args[1] instanceof JsX509) {
            JsX509 cert = (JsX509)((Object)args[1]);
            rid = new JceKeyTransRecipientId(cert.getCertificate());
        } else if (args[1] instanceof ByteString) {
            ByteString skid = (ByteString)((Object)args[1]);
            rid = new KeyTransRecipientId(skid.getBytes());
        } else {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument 2 must be either a x509 certificate or a bytestring.");
        }
        JsCMSEnvelopedData cms = (JsCMSEnvelopedData)thisObj;
        RecipientInformationStore recipientsStore = cms.ed.getRecipientInfos();
        RecipientInformation recipient = recipientsStore.get((RecipientId)rid);
        if (recipient == null) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "CMS was not encrypted for this recipient");
        }
        JceKeyTransEnvelopedRecipient recipientId = new JceKeyTransEnvelopedRecipient((PrivateKey)privateKey.getJCEKey(null));
        recipientId.setProvider("BC");
        byte[] content = recipient.getContent((Recipient)recipientId);
        return ByteString.newInstance(thisObj, content);
    }

    public static Scriptable[] jsFunction_getRecipientSubjectKeyIds(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSEnvelopedData cms = (JsCMSEnvelopedData)thisObj;
        RecipientInformationStore recipientsStore = cms.ed.getRecipientInfos();
        ArrayList<ByteString> bl = new ArrayList<ByteString>(recipientsStore.size());
        for (RecipientInformation recipient : recipientsStore) {
            RecipientId rid = recipient.getRID();
            if (!(rid instanceof KeyTransRecipientId)) continue;
            KeyTransRecipientId keyTrans = (KeyTransRecipientId)rid;
            byte[] skid = keyTrans.getSubjectKeyIdentifier();
            ByteString bs = ByteString.newInstance(thisObj, skid);
            bl.add(bs);
        }
        ByteString[] ba = new ByteString[bl.size()];
        return (Scriptable[])bl.toArray(ba);
    }
}

