/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.sss;

import de.cardcontact.scdp.sss.SecretShare;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShamirSecretSharing {
    static final Logger logger = LoggerFactory.getLogger(ShamirSecretSharing.class);

    private ShamirSecretSharing() {
    }

    public static List<SecretShare> createShares(BigInteger s, int k, int n, BigInteger p) {
        int i;
        LinkedList<SecretShare> shares = new LinkedList<SecretShare>();
        BigInteger[] polynomial = new BigInteger[k];
        logger.info("Polynomial degree : " + (k - 1));
        polynomial[0] = s;
        SecureRandom random = new SecureRandom();
        int maxExponent = k - 1;
        for (i = 1; i <= maxExponent; ++i) {
            BigInteger r = BigInteger.valueOf(random.nextLong());
            polynomial[i] = r = r.mod(p);
        }
        for (i = 1; i <= n; ++i) {
            BigInteger x = BigInteger.valueOf(i);
            BigInteger y = ShamirSecretSharing.calculatePolynomialValue(x, polynomial, p);
            shares.add(new SecretShare(x, y));
        }
        return shares;
    }

    private static BigInteger calculatePolynomialValue(BigInteger x, BigInteger[] polynomial, BigInteger p) {
        BigInteger result = polynomial[0];
        for (int exp = 1; exp < polynomial.length; ++exp) {
            BigInteger t = x;
            t = t.modPow(BigInteger.valueOf(exp), p);
            t = t.multiply(polynomial[exp]);
            t = t.mod(p);
            result = result.add(t);
            result = result.mod(p);
        }
        return result;
    }

    public static BigInteger reconstructSecret(List<SecretShare> shares, BigInteger p) {
        SecretShare currentShare;
        int i;
        logger.info("Reconstructing secret using " + shares.size() + " shares...");
        BigInteger s = BigInteger.ZERO;
        BigInteger[] bValues = new BigInteger[shares.size()];
        for (i = 0; i < shares.size(); ++i) {
            currentShare = shares.get(i);
            BigInteger numerator = BigInteger.ONE;
            BigInteger denominator = BigInteger.ONE;
            for (int j = 0; j < shares.size(); ++j) {
                if (i == j) continue;
                SecretShare share = shares.get(j);
                numerator = numerator.multiply(share.getX());
                denominator = denominator.multiply(share.getX().subtract(currentShare.getX()));
            }
            denominator = denominator.modInverse(p);
            BigInteger bValue = numerator.multiply(denominator);
            bValues[i] = bValue.mod(p);
            logger.info("b-value for " + currentShare.getX() + ": " + bValues[i]);
        }
        for (i = 0; i < shares.size(); ++i) {
            currentShare = shares.get(i);
            BigInteger temp = currentShare.getY().multiply(bValues[i]);
            s = s.add(temp);
        }
        return s.mod(p);
    }
}

