/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.pkcs11;

import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.opensc.pkcs11.PKCS11LoadStoreParameter;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Slot;

public class JsPKCS11Provider
extends ScriptableObject {
    public static final String clazzName = "PKCS11Provider";
    String providerName = null;
    PKCS11Provider provider = null;
    String moduleName = null;
    static HashMap<String, PKCS11Provider> modules = new HashMap();

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"PKCS11Provider() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 2);
        String moduleName = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        String providerSuffix = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, null);
        JsPKCS11Provider p = new JsPKCS11Provider();
        p.moduleName = moduleName;
        p.provider = modules.get(p.moduleName);
        if (p.provider == null) {
            try {
                p.provider = providerSuffix != null ? new PKCS11Provider(moduleName, providerSuffix) : new PKCS11Provider(moduleName);
                modules.put(moduleName, p.provider);
                p.providerName = p.provider.getName();
                Security.addProvider((Provider)p.provider);
            }
            catch (IOException e) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 0, "Module " + moduleName + " could not be loaded : " + e.getMessage());
            }
        }
        return p;
    }

    public String jsGet_providerName() {
        return this.providerName;
    }

    public static void jsFunction_cleanup(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Provider p = (JsPKCS11Provider)thisObj;
        p.provider.cleanup();
        modules.remove(p.moduleName);
        Security.removeProvider(p.providerName);
    }

    public static Scriptable jsFunction_getSlots(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Provider p = (JsPKCS11Provider)thisObj;
        List slotlist = null;
        try {
            slotlist = PKCS11Slot.enumerateSlots((PKCS11Provider)p.provider);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 0, "Error enumerating slots : " + e.getMessage());
        }
        return cx.newArray(thisObj, slotlist.toArray());
    }

    public static PKCS11Slot jsFunction_initToken(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        int slotId = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        String soPIN = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        String label = ArgChecker.getString(thisObj, clazzName, args, 2, null);
        JsPKCS11Provider p = (JsPKCS11Provider)thisObj;
        List slotlist = null;
        try {
            slotlist = PKCS11Slot.enumerateSlots((PKCS11Provider)p.provider);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 0, "Error enumerating slots : " + e.getMessage());
        }
        PKCS11Slot slot = null;
        for (PKCS11Slot slotiter : slotlist) {
            if ((long)slotId != slotiter.getId()) continue;
            slot = slotiter;
            break;
        }
        if (slot == null) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 0, "Slot id " + slotId + " not found");
        }
        try {
            slot.initToken(soPIN.toCharArray(), label);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        return slot;
    }

    public static Scriptable jsFunction_getKeyStore(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int slot = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        String password = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        JsPKCS11Provider p = (JsPKCS11Provider)thisObj;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("PKCS11", p.providerName);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Error accessing key store : " + e.getMessage());
        }
        PKCS11LoadStoreParameter params = new PKCS11LoadStoreParameter();
        if (password != null) {
            params.setProtectionPIN(password.toCharArray());
        }
        params.setWaitForSlot(true);
        params.setSlotId(new Long(slot));
        try {
            ks.load((KeyStore.LoadStoreParameter)params);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Error accessing key store : " + e.getMessage());
        }
        Object[] cargs = new Object[]{ks};
        return cx.newObject(thisObj, "KeyStore", cargs);
    }
}

