/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class JsCRL
extends ScriptableObject
implements Wrapper {
    static final String clazzName = "CRL";
    X509CRL crl = null;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CRL() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        JsCRL jscrl = new JsCRL();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            if (args[0] instanceof ByteString) {
                ByteString bs = (ByteString)((Object)args[0]);
                jscrl.crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(bs.getBytes()));
            } else if (args[0] instanceof CharSequence) {
                GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)ctorObj);
                String filename = gpr.mapFilename(Context.toString((Object)args[0]), 6);
                if (filename == null) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File not found");
                }
                File crlfile = new File(filename);
                jscrl.crl = (X509CRL)cf.generateCRL(new FileInputStream(crlfile));
            } else {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Argument must be of type ByteString or String");
            }
        }
        catch (CRLException ce) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "CRL invalid " + ce.getMessage());
        }
        return jscrl;
    }

    public Object unwrap() {
        return this.crl;
    }

    public static X509CRL jsFunction_getNative(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCRL)thisObj).crl;
    }
}

