/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.scdp.utils.Base64;
import de.cardcontact.scdp.utils.ByteBuffer;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.ObjectIdentifierRegistry;
import java.io.UnsupportedEncodingException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class GPByteBuffer
extends ScriptableObject
implements Wrapper {
    public static final int HEX = 16;
    public static final int UTF8 = 2;
    public static final int ASCII = 3;
    public static final int BASE64 = 4;
    public static final int CN = 5;
    public static final int OID = 6;
    static final String clazzName = "ByteBuffer";
    ByteBuffer bb = null;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"ByteBuffer() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 2);
        GPByteBuffer t = new GPByteBuffer();
        block5 : switch (args.length) {
            case 0: {
                t.bb = new ByteBuffer();
                break;
            }
            case 1: {
                if (args[0] instanceof ByteString) {
                    ByteString bs = (ByteString)((Object)args[0]);
                    t.bb = new ByteBuffer(bs.getBytes());
                    break;
                }
                if (args[0] instanceof Number) {
                    t.bb = new ByteBuffer(((Number)args[0]).intValue());
                    break;
                }
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Argument must be of type ByteString or Number");
                break;
            }
            case 2: {
                int encoding = (int)Context.toNumber((Object)args[1]);
                String str = Context.toString((Object)args[0]);
                switch (encoding) {
                    case 16: {
                        try {
                            t.bb = new ByteBuffer(HexString.parseHexString((String)str));
                        }
                        catch (NumberFormatException e) {
                            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid hexadecimal data: " + e.getMessage());
                        }
                        break block5;
                    }
                    case 2: {
                        try {
                            t.bb = new ByteBuffer(str.getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid UTF-8 characters");
                        }
                        break block5;
                    }
                    case 3: {
                        try {
                            t.bb = new ByteBuffer(str.getBytes("8859_1"));
                        }
                        catch (UnsupportedEncodingException e) {
                            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid Latin-1 characters");
                        }
                        break block5;
                    }
                    case 4: {
                        try {
                            t.bb = new ByteBuffer(Base64.decode(str));
                        }
                        catch (UnsupportedEncodingException e) {
                            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid Base64 characters");
                        }
                        break block5;
                    }
                    case 5: {
                        Context.reportError((String)"ByteBuffer.CN not yet implemented");
                        break block5;
                    }
                    case 6: {
                        try {
                            t.bb = new ByteBuffer(ObjectIdentifierRegistry.parseObjectIdentifier((String)str));
                        }
                        catch (IllegalArgumentException e) {
                            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid object identifier");
                        }
                        break block5;
                    }
                }
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 10, 0, "Invalid encoding type");
                break;
            }
            default: {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, "ByteBuffer Constructor", 8, args.length, "To many arguments in constructor");
            }
        }
        return t;
    }

    public String getClassName() {
        return clazzName;
    }

    public int jsGet_length() {
        return this.bb.length();
    }

    public Object unwrap() {
        return this.bb.getBytes();
    }

    public static Scriptable jsFunction_append(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteBuffer b = ((GPByteBuffer)thisObj).bb;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] instanceof GPByteBuffer) {
            ByteBuffer p = ((GPByteBuffer)((Object)args[0])).bb;
            b.append(p);
        } else if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            b.append(bs.getBytes());
        } else if (args[0] instanceof Number) {
            Number i = (Number)args[0];
            b.append(i.byteValue());
        } else {
            String str = Context.toString((Object)args[0]);
            try {
                b.append(str.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                GPError.throwAsGPErrorEx(thisObj, "ByteBuffer append()", 9, 0, "String contains invalid Latin-1 characters");
            }
        }
        return thisObj;
    }

    public static double jsFunction_byteAt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteBuffer b = ((GPByteBuffer)thisObj).bb;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte response = 0;
        try {
            response = b.getByteAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Invalid index in byteAt()");
        }
        return response & 0xFF;
    }

    public static Scriptable jsFunction_clear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteBuffer bb = ((GPByteBuffer)thisObj).bb;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int count = ArgChecker.getInt(thisObj, clazzName, args, 1, bb.length() - offset);
        if (offset < 0 || offset > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset out of range");
        }
        if (count < 0 || offset + count > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Count out of range");
        }
        bb.clear(offset, count);
        return thisObj;
    }

    public static Scriptable jsFunction_copy(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteBuffer bb = ((GPByteBuffer)thisObj).bb;
        byte[] source = null;
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int at = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (at < 0 || at > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 11, at, "Offset out of range");
        }
        if (args[1] instanceof GPByteBuffer) {
            GPByteBuffer sbb = (GPByteBuffer)((Object)args[1]);
            source = sbb.bb.getBytes();
        } else if (args[1] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[1]);
            source = bs.getBytes();
        } else if (args[1] instanceof Number) {
            Number i = (Number)args[1];
            source = new byte[]{i.byteValue()};
        } else {
            String str = Context.toString((Object)args[1]);
            try {
                source = str.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                GPError.throwAsGPErrorEx(thisObj, "ByteBuffer append()", 9, 0, "String contains invalid Latin-1 characters");
            }
        }
        if (at + source.length > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 13, bb.length(), "Length of source longer than ByteBuffer");
        }
        bb.copy(at, source);
        return thisObj;
    }

    public static int jsFunction_find(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "First argument for find() must be ByteString");
        }
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        ByteBuffer bb = ((GPByteBuffer)thisObj).bb;
        byte[] v = ((ByteString)((Object)args[0])).bs;
        if (offset < 0) {
            offset = 0;
        }
        if (offset > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset for find() out of range");
        }
        return bb.find(v, offset);
    }

    public static Scriptable jsFunction_insert(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteBuffer bb = ((GPByteBuffer)thisObj).bb;
        byte[] source = null;
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int at = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (at < 0 || at > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 11, at, "Offset out of range");
        }
        if (args[1] instanceof GPByteBuffer) {
            GPByteBuffer sbb = (GPByteBuffer)((Object)args[1]);
            source = sbb.bb.getBytes();
        } else if (args[1] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[1]);
            source = bs.getBytes();
        } else if (args[1] instanceof Number) {
            Number i = (Number)args[1];
            source = new byte[]{i.byteValue()};
        } else {
            String str = Context.toString((Object)args[1]);
            try {
                source = str.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                GPError.throwAsGPErrorEx(thisObj, "ByteBuffer append()", 9, 0, "String contains invalid Latin-1 characters");
            }
        }
        bb.insert(at, source);
        return thisObj;
    }

    public static ByteString jsFunction_toByteString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int count;
        ByteBuffer bb = ((GPByteBuffer)thisObj).bb;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (offset < 0 || offset > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset out of range");
        }
        if ((count = ArgChecker.getInt(thisObj, clazzName, args, 1, bb.length() - offset)) < 0 || offset + count > bb.length()) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Count out of range");
        }
        return ByteString.newInstance(thisObj, bb.getBytes(offset, count));
    }

    public String jsFunction_toString(int encoding) {
        String response = null;
        switch (encoding) {
            case 0: {
                response = this.bb.toString();
                break;
            }
            case 16: {
                response = HexString.hexifyByteArray((byte[])this.bb.getBytes());
                break;
            }
            case 2: {
                try {
                    response = new String(this.bb.getBytes(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "ByteBuffer contains invalid UTF-8 characters");
                }
                break;
            }
            case 3: {
                try {
                    response = new String(this.bb.getBytes(), "8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "ByteBuffer contains invalid UTF-8 characters");
                }
                break;
            }
            case 4: {
                response = Base64.encode(this.bb.getBytes(), false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                response = ObjectIdentifier.getObjectIdentifierAsString((int[])ObjectIdentifier.convertBytesToOID((byte[])this.bb.getBytes()));
                break;
            }
            default: {
                GPError.throwAsGPErrorEx((Scriptable)this, 10, 0, "Invalid encoding type");
            }
        }
        return response;
    }

    public String toString() {
        return this.bb.toString();
    }
}

