/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.HexString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPAtr
extends ScriptableObject {
    private static final long serialVersionUID = 517450543376654083L;
    static final String clazzName = "Atr";
    static final int[] curr = new int[]{25, 50, 100, 200};
    static final String[] prot = new String[]{"T=0", "T=1", "...", "...", "...", "...", "...", "...", "...", "...", "...", "...", "...", "...", "T14", "GLO"};
    static final String[] sprot = new String[]{"SDAP", "3WBP", "2WBP"};
    static final String[] fi = new String[]{" 372/ 4", " 372/ 5", " 558/ 6", " 744/ 8", "1116/12", "1488/16", "1860/20", " RFU   ", " RFU   ", " 512/ 5", "768/7,5", "1024/10", "1536/15", "2048/20", " RFU   ", " RFU   "};
    static final String[] di = new String[]{"RFU", "  1", "  2", "  4", "  8", " 16", " 32", "RFU", " 12", " 20", "RFU", "RFU", "RFU", "RFU", "RFU", "RFU"};
    static final String[] xi = new String[]{"No Stop", "State L", "State H", "No Pref"};
    static final String[] ui = new String[]{"N/A    ", "A only ", "B only ", "A and B", "C only ", "C and A", "B and C", "A, B, C"};
    byte[] atr = null;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            Context.reportError((String)"Atr() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        ByteString bs = ArgChecker.getByteString((Scriptable)ctorObj, clazzName, args, 0, null);
        GPAtr atrobj = new GPAtr();
        byte[] atr = bs.getBytes();
        atrobj.atr = atr;
        if (atr[0] == 59 || atr[0] == 63) {
            atrobj.put("formatByte", (Scriptable)atrobj, new Integer(atr[1] & 0xFF));
            int hbc = atr[1] & 0xF;
            int i = 1;
            boolean more = true;
            while (more) {
                more = (atr[i] & 0x80) == 128;
                i += ((atr[i] & 0x10) >> 4) + ((atr[i] & 0x20) >> 5) + ((atr[i] & 0x40) >> 6) + ((atr[i] & 0x80) >> 7);
            }
            byte[] ib = new byte[++i - 2];
            System.arraycopy(atr, 2, ib, 0, i - 2);
            atrobj.put("interfaceBytes", (Scriptable)atrobj, (Object)ByteString.newInstance((Scriptable)ctorObj, ib));
            byte[] hb = new byte[hbc];
            System.arraycopy(atr, i, hb, 0, hbc);
            atrobj.put("historicalBytes", (Scriptable)atrobj, (Object)ByteString.newInstance((Scriptable)ctorObj, hb));
            if (atr.length > (i += hbc)) {
                if (atr.length - i == 1) {
                    atrobj.put("tckByte", (Scriptable)atrobj, new Integer(atr[i]));
                } else {
                    atrobj.put("tckByte", (Scriptable)atrobj, new Integer((atr[i] & 0xFF) << 8 + (atr[i + 1] & 0xFF)));
                }
            }
        } else if ((atr[0] & 0xCF) == 130) {
            atrobj.put("interfaceBytes", (Scriptable)atrobj, (Object)ByteString.newInstance((Scriptable)ctorObj, atr));
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "Argument is not an ATR");
        }
        return atrobj;
    }

    public static ByteString jsFunction_toByteString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ByteString.newInstance(thisObj, ((GPAtr)thisObj).atr);
    }

    private static String c5(int v) {
        String r = "" + v;
        if (r.length() >= 5) {
            return r;
        }
        return "     ".substring(r.length()) + r;
    }

    private static String mydump(byte[] data, int offset, int length) {
        StringBuffer buffer = new StringBuffer(80);
        int ofs = offset;
        int i = 0;
        while (i < length) {
            buffer.append(HexString.hexifyByte((byte)data[ofs]));
            ++i;
            ++ofs;
        }
        buffer.append(' ');
        ofs = offset;
        i = 0;
        while (i < length) {
            char ch = (char)(data[ofs] & 0xFF);
            if (ch < ' ' || ch >= '\u007f' && ch <= '\u00a0') {
                ch = '.';
            }
            buffer.append(ch);
            ++i;
            ++ofs;
        }
        return buffer.toString();
    }

    public String toString() {
        int j;
        StringBuffer r = new StringBuffer(100);
        int i = 0;
        int hb = 0;
        int td = 0;
        if (this.atr[i] == 59 || this.atr[i] == 63) {
            if (this.atr[i] == 59) {
                r.append("TS  : 3B  Direct logic\n");
            } else {
                r.append("TS  : " + HexString.hexifyByte((byte)this.atr[i]) + "  Inverse logic\n");
            }
            hb = this.atr[++i] & 0xF;
            td = this.atr[i] & 0xF0;
            r.append("TO  : " + HexString.hexifyByte((byte)this.atr[i]) + "  K    = " + GPAtr.c5(hb) + " byte [historical characters]\n");
            ++i;
            if ((td & 0x10) == 16) {
                int f = this.atr[i] >> 4 & 0xF;
                int d = this.atr[i] & 0xF;
                r.append("TA1 : " + HexString.hexifyByte((byte)this.atr[i]) + "  Fi/f =  " + fi[f] + "   [clock rate conversion factor / max. frequency (MHz)]\n");
                r.append("          Di   =   " + di[d] + "      [bit rate conversion factor]\n");
                ++i;
            }
            if ((td & 0x20) == 32) {
                r.append("TB1 : " + HexString.hexifyByte((byte)this.atr[i]) + "  pa   = " + GPAtr.c5((this.atr[i] & 0x80) == 128 ? 2 : 4) + " %    [programming voltage accurancy]\n");
                r.append("          I    = " + GPAtr.c5(curr[(this.atr[i] & 0x60) >> 5]) + " mA   [maximum current]\n");
                r.append("          P    = " + GPAtr.c5(this.atr[i] & 0xF) + " V    [programming voltage]\n");
                ++i;
            }
            if ((td & 0x40) == 64) {
                r.append("TC1 : " + HexString.hexifyByte((byte)this.atr[i]) + "  N    = " + GPAtr.c5(this.atr[i] & 0xFF) + " etu  [extra guardtime]\n");
                ++i;
            }
            j = 2;
            while ((td & 0x80) == 128) {
                r.append("TD" + (j - 1) + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  T    =   " + prot[this.atr[i] & 0xF] + "      [protocol type]\n");
                td = this.atr[i];
                ++i;
                if ((td & 0xF) == 15) {
                    if ((td & 0x10) == 16) {
                        r.append("TA" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  X    = " + xi[(this.atr[i] & 0xC0) >> 6] + "    [clock stop indicator]\n");
                        r.append("          U    = " + ui[this.atr[i] & 7] + "    [class indicator (5, 3, 1.8 V)]\n");
                        ++i;
                    }
                    if ((td & 0x20) == 32) {
                        r.append("TB" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "\n");
                        ++i;
                    }
                    if ((td & 0x40) == 64) {
                        r.append("TC" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "\n");
                        ++i;
                    }
                } else if (j > 2 && (td & 0xF) == 1) {
                    if ((td & 0x10) == 16) {
                        r.append("TA" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  IFSC = " + GPAtr.c5(this.atr[i] == 0 ? 256 : this.atr[i] & 0xFF) + "      [information field size]\n");
                        ++i;
                    }
                    if ((td & 0x20) == 32) {
                        r.append("TB" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  CWT  = " + GPAtr.c5((1 << (this.atr[i] & 0xF)) + 11) + " etu  [character waiting time]\n");
                        int bwt = (this.atr[i] & 0xF0) >> 4;
                        if (bwt < 10) {
                            r.append("          BWT  = " + GPAtr.c5((1 << bwt) * 960 + 11) + " etu  [block waiting time]\n");
                        } else {
                            String bwtch = "ABCDEF".substring(bwt - 10, bwt - 9);
                            r.append("          BWT  =     " + bwtch + "      [block waiting time code]\n");
                        }
                        ++i;
                    }
                    if ((td & 0x40) == 64) {
                        r.append("TC" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  EDC  = " + ((this.atr[i] & 1) == 1 ? "CRC" : "LRC") + "        [error detection code]\n");
                        ++i;
                    }
                } else {
                    if ((td & 0x10) == 16) {
                        if (j == 2) {
                            r.append("TA" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  S/N  =   " + ((this.atr[i] & 0x80) == 128 ? "yes" : "no ") + "      [specific mode]\n");
                            r.append("          DP   =   " + ((this.atr[i] & 0x80) == 128 ? "implicit" : "IF-bytes") + " [protocol parameter]\n");
                            r.append("          T    =   " + prot[this.atr[i] & 0xF] + "      [protocol type]\n");
                        } else {
                            r.append("TA" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  BS   = " + GPAtr.c5(this.atr[i] == 0 ? 256 : this.atr[i] & 0xFF) + "      [block size]\n");
                        }
                        ++i;
                    }
                    if ((td & 0x20) == 32) {
                        if (j == 2) {
                            r.append("TB" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  P2   =  " + (double)(this.atr[i] & 0xFF) / 10.0 + " Volt [programming voltage]\n");
                        } else {
                            r.append("TB" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "\n");
                        }
                        ++i;
                    }
                    if ((td & 0x40) == 64) {
                        if (j == 2) {
                            r.append("TC" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "  W    = " + GPAtr.c5(this.atr[i] & 0xFF) + "      [waiting time adjustment factor]\n");
                        } else {
                            r.append("TC" + j + " : " + HexString.hexifyByte((byte)this.atr[i]) + "\n");
                        }
                        ++i;
                    }
                }
                ++j;
            }
        } else if ((this.atr[i] & 0xCF) == 130) {
            j = (this.atr[i] & 0xF0) >> 4;
            r.append("H1  : " + HexString.hexifyByte((byte)this.atr[i]) + "  S = " + j + ", " + sprot[j - 8] + "\n");
            j = 64 << ((this.atr[++i] & 0x78) >> 3);
            if (j == 64) {
                j = 0;
            }
            r.append("H2  : " + HexString.hexifyByte((byte)this.atr[i]) + "  Units = " + j + "\n");
            r.append("          Unit Size = " + (1 << (this.atr[i] & 7)) + " bits\n");
            r.append("H3  : " + HexString.hexifyByte((byte)this.atr[++i]) + "  Category = " + (this.atr[i] == 16 ? "Synchronous card" : "Unknown") + "\n");
            if ((this.atr[++i] & 0x80) == 128) {
                r.append("H4  : " + HexString.hexifyByte((byte)this.atr[i]) + "  Dir Reference = " + (this.atr[i] & 0xFF) + "\n");
            } else {
                r.append("H4  : " + HexString.hexifyByte((byte)this.atr[i]) + "\n");
            }
        }
        if (hb > 0) {
            td = this.atr[i] & 0xFF;
            if (td == 0 || td == 128) {
                hb -= td == 0 ? 4 : 1;
                ++i;
                while (hb > 0) {
                    int tag = this.atr[i] & 0xF0;
                    int len = this.atr[i] & 0xF;
                    if (len > hb - 1) {
                        r.append("Error: Compact TLV length field exceeds historical bytes - truncated\n");
                        len = hb - 1;
                    }
                    ++i;
                    hb -= len + 1;
                    switch (tag) {
                        case 16: {
                            r.append("Country indicator      : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 32: {
                            r.append("Issuer indicator       : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 48: {
                            r.append("Card service indicator :\n");
                            if ((this.atr[i] & 0x80) == 128) {
                                r.append("    Application selection by full DF name\n");
                            }
                            if ((this.atr[i] & 0x40) == 64) {
                                r.append("    Application selection by partial DF name\n");
                            }
                            if ((this.atr[i] & 0x20) == 32) {
                                r.append("    BER-TLV objects in EF.DIR\n");
                            }
                            if ((this.atr[i] & 0x10) == 16) {
                                r.append("    BER-TLV objects in EF.ATR\n");
                            }
                            switch (this.atr[i] & 0xE) {
                                case 0: {
                                    r.append("    EF.DIR / EF.ATR access with READ RECORD\n");
                                    break;
                                }
                                case 4: {
                                    r.append("    EF.DIR / EF.ATR access with GET DATA\n");
                                    break;
                                }
                                case 8: {
                                    r.append("    EF.DIR / EF.ATR access with READ BINARY\n");
                                }
                            }
                            if ((this.atr[i] & 1) == 1) {
                                r.append("    Card without MF\n");
                                break;
                            }
                            r.append("    Card with MF\n");
                            break;
                        }
                        case 64: {
                            r.append("Initial access data    : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 80: {
                            r.append("Card issuer data       : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 96: {
                            r.append("Pre-issuing data       : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 112: {
                            r.append("Card capabilities      :\n");
                            if (len > 0) {
                                if ((this.atr[i] & 0x80) == 128) {
                                    r.append("    DF selection by full DF name\n");
                                }
                                if ((this.atr[i] & 0x40) == 64) {
                                    r.append("    DF selection by partial DF name\n");
                                }
                                if ((this.atr[i] & 0x20) == 32) {
                                    r.append("    DF selection by path DF name\n");
                                }
                                if ((this.atr[i] & 0x10) == 16) {
                                    r.append("    DF selection by file identifier\n");
                                }
                                if ((this.atr[i] & 8) == 8) {
                                    r.append("    Implicit DF selection\n");
                                }
                                if ((this.atr[i] & 4) == 4) {
                                    r.append("    Short EF identifier supported\n");
                                }
                                if ((this.atr[i] & 2) == 2) {
                                    r.append("    Record number supported\n");
                                }
                                if ((this.atr[i] & 1) == 1) {
                                    r.append("    Record identifier supported\n");
                                }
                            }
                            ++i;
                            if (--len > 0) {
                                if ((this.atr[i] & 0x80) == 128) {
                                    r.append("    EFs of TLV structure supported\n");
                                }
                                switch (this.atr[i] & 0x60) {
                                    case 0: {
                                        r.append("    One-time write\n");
                                        break;
                                    }
                                    case 32: {
                                        r.append("    Proprietary write\n");
                                        break;
                                    }
                                    case 64: {
                                        r.append("    Write OR\n");
                                        break;
                                    }
                                    case 96: {
                                        r.append("    Write AND\n");
                                    }
                                }
                                int dusize = 4 << (this.atr[i] & 0xF);
                                r.append("    Data unit size is " + dusize + " bits\n");
                                if ((this.atr[i] & 0x10) == 16) {
                                    r.append("    'FF' means long private tags with constructed encoding TLV object\n");
                                } else {
                                    r.append("    'FF' means padding in BER.TLV coded data fields\n");
                                }
                            }
                            ++i;
                            if (--len <= 0) break;
                            if ((this.atr[i] & 0x80) == 128) {
                                r.append("    Command chaining supported\n");
                            }
                            if ((this.atr[i] & 0x40) == 64) {
                                r.append("    Extended Le and Lc fields supported\n");
                            }
                            if ((this.atr[i] & 0x10) == 16) {
                                r.append("    Logical channel number assigned by the card\n");
                            }
                            if ((this.atr[i] & 8) == 8) {
                                r.append("    Logical channel number assigned by the interface device\n");
                            }
                            if ((this.atr[i] & 0x18) == 0) break;
                            int maxlc = ((this.atr[i] & 0x20) >> 2) + (this.atr[i] & 3) + 1;
                            r.append("    Maximum number of logical channels is " + maxlc + "\n");
                            break;
                        }
                        case 128: {
                            r.append("Status byte(s)         : " + GPAtr.mydump(this.atr, i, len) + "\n");
                            break;
                        }
                        case 240: {
                            r.append("Application identifier : " + GPAtr.mydump(this.atr, i, len) + "\n");
                        }
                    }
                    i += len;
                }
                if (td == 0) {
                    r.append("Status bytes : " + HexString.hexifyByte((byte)this.atr[i]) + HexString.hexifyByte((byte)this.atr[i + 1]) + HexString.hexifyByte((byte)this.atr[i + 2]));
                }
            } else {
                r.append(GPAtr.mydump(this.atr, i, hb) + "\n");
            }
        }
        return r.toString();
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPAtr)thisObj).toString();
    }
}

