/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cardsim.jcop;

import de.cardcontact.scdp.cardsim.CardSimulationException;
import de.cardcontact.scdp.cardsim.ICardSimulationAdapter;
import de.cardcontact.scdp.cardsim.ICardSimulator;
import de.cardcontact.scdp.cardsim.jcop.JCOPSimulationProtocol;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class JCOPSimulationAdapter
implements ICardSimulationAdapter,
Runnable {
    static final int SOCKET_TIMEOUT = 200;
    private int port;
    private ICardSimulationAdapter.LifeCycleState lcs;
    private boolean isRunning = false;
    private Thread thread = null;
    private ICardSimulator cardSimulator;
    private ServerSocket serverSocket = null;
    private Socket socket = null;

    public JCOPSimulationAdapter(String parameter) {
        this.port = Integer.parseInt(parameter);
        this.lcs = ICardSimulationAdapter.LifeCycleState.INIT;
    }

    public String toString() {
        return "JCOP Simulation Adapter listening on port " + this.port;
    }

    @Override
    public void setCardSimulator(ICardSimulator cardSimulator) {
        this.cardSimulator = cardSimulator;
    }

    @Override
    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            this.stop();
        }
        this.lcs = ICardSimulationAdapter.LifeCycleState.INIT;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void stop() {
        this.isRunning = false;
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.thread.interrupt();
        try {
            this.thread.join(500L);
            if (this.thread.isAlive()) {
                if (this.socket != null && this.socket.isConnected()) {
                    this.socket.close();
                }
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ICardSimulationAdapter.LifeCycleState getLifeCycleStatus() {
        return this.lcs;
    }

    private void processMessage(JCOPSimulationProtocol protocol) throws IOException, CardSimulationException {
        switch (protocol.getNode()) {
            case 0: {
                protocol.send((byte)1, (byte)0, this.cardSimulator.processAPDU(protocol.getMessage()));
                break;
            }
            case 33: {
                protocol.send((byte)0, (byte)33, this.cardSimulator.reset(ICardSimulator.ResetType.cold));
                break;
            }
            case -1: {
                protocol.send((byte)4, (byte)-1, "JRCP Protocol 1".getBytes());
                break;
            }
            default: {
                protocol.send((byte)3, (byte)33, "Unknown node".getBytes());
            }
        }
    }

    @Override
    public void run() {
        JCOPSimulationProtocol protocol = null;
        this.isRunning = true;
        while (this.isRunning && !Thread.interrupted()) {
            switch (this.lcs) {
                case INIT: {
                    try {
                        this.serverSocket = new ServerSocket(this.port, 0);
                        this.serverSocket.setSoTimeout(200);
                        this.lcs = ICardSimulationAdapter.LifeCycleState.WAITING;
                    }
                    catch (IOException ioe) {
                        this.isRunning = false;
                        this.lcs = ICardSimulationAdapter.LifeCycleState.ABORTED;
                    }
                    break;
                }
                case WAITING: {
                    try {
                        this.socket = this.serverSocket.accept();
                        this.socket.setSoTimeout(200);
                        protocol = new JCOPSimulationProtocol(this.socket.getInputStream(), this.socket.getOutputStream());
                        this.lcs = ICardSimulationAdapter.LifeCycleState.CONNECTED;
                    }
                    catch (SocketTimeoutException ioe) {
                    }
                    catch (IOException ioe) {
                        this.lcs = ICardSimulationAdapter.LifeCycleState.ERROR;
                    }
                    break;
                }
                case CONNECTED: {
                    try {
                        if (protocol.readJcop() < 0) {
                            this.socket.close();
                            this.lcs = ICardSimulationAdapter.LifeCycleState.WAITING;
                            break;
                        }
                        this.processMessage(protocol);
                    }
                    catch (CardSimulationException cse) {
                        this.isRunning = false;
                        this.lcs = ICardSimulationAdapter.LifeCycleState.ABORTED;
                    }
                    catch (SocketTimeoutException cse) {
                    }
                    catch (Exception ioe) {
                        this.lcs = ICardSimulationAdapter.LifeCycleState.ERROR;
                    }
                    break;
                }
                case ERROR: {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.lcs = ICardSimulationAdapter.LifeCycleState.WAITING;
                }
            }
        }
        try {
            if (this.socket != null && this.socket.isConnected()) {
                this.socket.close();
            }
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.socket = null;
        this.lcs = ICardSimulationAdapter.LifeCycleState.STOPPED;
    }
}

