/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import de.cardcontact.scdp.engine.FileResourceLocator;
import org.slf4j.LoggerFactory;

public class LogbackInitializer {
    public static void init(String fname) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(fname);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    public static void init(FileResourceLocator frl) {
        String fname = frl.mapFilename("etc/logback.xml", 6);
        if (fname != null) {
            LogbackInitializer.init(fname);
        } else {
            Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
            rootLogger.setLevel(Level.OFF);
        }
    }
}

