/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsKeyStore;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsTLSSocket
extends ScriptableObject {
    private static final long serialVersionUID = 1519842423928117994L;
    public static final String clazzName = "TLSSocket";
    private SSLContext context;
    private String host;
    private int port;
    private Socket socket = null;
    private KeyStore truststore = null;
    private KeyStore keystore = null;
    private String keypassword = null;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        JsTLSSocket t = new JsTLSSocket();
        t.host = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        t.port = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, 0);
        try {
            t.context = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 1, "No TLS implementation found: " + e.getMessage());
        }
        return t;
    }

    public static void jsFunction_setTLSKeyStores(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 3);
        if (!(args[0] instanceof JsKeyStore)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type KeyStore");
        }
        JsKeyStore jstruststore = (JsKeyStore)((Object)args[0]);
        JsKeyStore jskeystore = null;
        String keypassword = null;
        if (args.length > 1) {
            if (!(args[1] instanceof JsKeyStore)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "Argument must be of type KeyStore");
            }
            jskeystore = (JsKeyStore)((Object)args[1]);
            keypassword = ArgChecker.getString(thisObj, clazzName, args, 2, null);
        }
        JsTLSSocket t = (JsTLSSocket)thisObj;
        t.truststore = jstruststore.jsGet_native();
        if (jskeystore != null) {
            t.keystore = jskeystore.jsGet_native();
            t.keypassword = keypassword;
        }
    }

    private Socket getSocket() {
        if (this.socket != null) {
            return this.socket;
        }
        try {
            this.context = SSLContext.getInstance("TLS");
            KeyManager[] km = null;
            TrustManager[] tm = null;
            if (this.truststore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(this.truststore);
                tm = tmf.getTrustManagers();
            }
            if (this.keystore != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(this.keystore, this.keypassword.toCharArray());
                km = kmf.getKeyManagers();
            }
            this.context.init(km, tm, null);
        }
        catch (NoSuchAlgorithmException nsae) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Invalid algorithm for TLS : " + nsae.getMessage());
        }
        catch (KeyManagementException kme) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error in key management for TLS : " + kme.getMessage());
        }
        catch (KeyStoreException kse) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error in key store for TLS : " + kse.getMessage());
        }
        catch (UnrecoverableKeyException uke) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error recovering private key for TLS : " + uke.getMessage());
        }
        try {
            this.socket = this.context.getSocketFactory().createSocket(this.host, this.port);
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error creating socket : " + e.getMessage());
        }
        return this.socket;
    }

    private void send(byte[] data) {
        try {
            OutputStream os = this.getSocket().getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 0, "Socket send failed: " + e.getMessage());
        }
    }

    public static void jsFunction_send(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type ByteString");
        }
        JsTLSSocket t = (JsTLSSocket)thisObj;
        t.send(((ByteString)((Object)args[0])).getBytes());
    }

    private byte[] receive(int size) {
        ByteArrayOutputStream baos = null;
        if (size == 0) {
            size = Integer.MAX_VALUE;
        }
        try {
            int len;
            InputStream is = this.getSocket().getInputStream();
            byte[] readBuffer = new byte[8192];
            baos = new ByteArrayOutputStream();
            do {
                int rlen = size < readBuffer.length ? size : readBuffer.length;
                len = is.read(readBuffer, 0, rlen);
                baos.write(readBuffer, 0, len);
            } while (len == readBuffer.length && (size -= len) > 0);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 0, "Socket recv failed: " + e.getMessage());
            return null;
        }
    }

    public static ByteString jsFunction_receive(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        int size = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsTLSSocket t = (JsTLSSocket)thisObj;
        return ByteString.newInstance(thisObj, t.receive(size));
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsTLSSocket t = (JsTLSSocket)thisObj;
        try {
            t.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

