/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.ObjectIdentifierRegistry;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.TreeNode;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsASN1
extends ScriptableObject
implements TreeNode {
    static final String clazzName = "ASN1";
    private TLV tlv;

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UNIVERSAL", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"APPLICATION", (Object)new Integer(64), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CONTEXT", (Object)new Integer(128), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"PRIVATE", (Object)new Integer(192), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"END_OF_CONTENTS", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"BOOLEAN", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"INTEGER", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"BIT_STRING", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"OCTET_STRING", (Object)new Integer(4), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"NULL", (Object)new Integer(5), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"OBJECT_IDENTIFIER", (Object)new Integer(6), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"OBJECT_DESCRIPTOR", (Object)new Integer(7), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"EXTERNAL_TYPE", (Object)new Integer(8), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"REAL", (Object)new Integer(9), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ENUMERATED", (Object)new Integer(10), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"EMBEDDED_PDV", (Object)new Integer(11), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UTF8String", (Object)new Integer(12), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"RELATIVE_OID", (Object)new Integer(13), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SEQUENCE", (Object)new Integer(48), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SET", (Object)new Integer(49), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"NumericString", (Object)new Integer(18), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"PrintableString", (Object)new Integer(19), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"T61String", (Object)new Integer(20), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"IA5String", (Object)new Integer(22), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UTCTime", (Object)new Integer(23), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"GeneralizedTime", (Object)new Integer(24), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"GeneralString", (Object)new Integer(27), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UniversalString", (Object)new Integer(28), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"BMPString", (Object)new Integer(30), (int)0);
    }

    public int jsGet_tag() {
        byte[] v = this.tlv.getTag().getBytes();
        int r = 0;
        for (int i = 0; i < v.length; ++i) {
            r <<= 8;
            r |= v[i] & 0xFF;
        }
        return r;
    }

    public int jsGet_tagclass() {
        return this.tlv.getTag().getClazz() & 0xFF;
    }

    public int jsGet_tagnumber() {
        return this.tlv.getTag().getNumber();
    }

    public boolean jsGet_isconstructed() {
        return this.tlv.getTag().isConstructed();
    }

    public int jsGet_length() {
        return this.tlv.getLength();
    }

    public int jsGet_size() {
        return this.tlv.getSize();
    }

    public String jsGet_name() {
        return this.tlv.getName();
    }

    public ByteString jsGet_value() {
        return ByteString.newInstance((Scriptable)this, this.tlv.getValue());
    }

    public int jsGet_elements() {
        int elements = 0;
        if (this.tlv instanceof ConstructedTLV) {
            elements = ((ConstructedTLV)this.tlv).getElements();
        }
        return elements;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            Context.reportError((String)"ASN1() can not be called as function");
        }
        if (args.length < 1) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 2, args.length, "Too few arguments");
        }
        JsASN1 t = new JsASN1();
        int i = 0;
        String name = null;
        if (args[i] instanceof CharSequence) {
            name = ((CharSequence)args[0]).toString();
            ++i;
        }
        if (args[i] instanceof TLV) {
            t.tlv = (TLV)args[i];
        } else if (args[i] instanceof ByteString) {
            ByteString encoded = (ByteString)((Object)args[i]);
            try {
                t.tlv = TLV.factory((byte[])encoded.getBytes());
            }
            catch (TLVEncodingException tee) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, 9, i, tee.getMessage());
            }
        } else {
            int tag = 0;
            if (args[i] instanceof Number) {
                tag = ((Number)args[i]).intValue();
            } else {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, i, "Argument must be of type ByteString");
            }
            if (args.length == ++i || args[i] instanceof JsASN1) {
                ConstructedTLV ctlv = null;
                try {
                    ctlv = new ConstructedTLV(tag);
                }
                catch (TLVEncodingException e) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, i, "Invalid tag: " + e.getMessage());
                }
                t.tlv = ctlv;
                while (i < args.length) {
                    if (args[i] instanceof JsASN1) {
                        JsASN1 other = (JsASN1)((Object)args[i]);
                        ctlv.add(other.tlv);
                    } else {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, i, "Argument must be of type TLV");
                    }
                    ++i;
                }
            } else {
                byte[] value = null;
                if (args[i] instanceof ByteString) {
                    value = ((ByteString)((Object)args[i])).getBytes();
                } else {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, i, "Argument must be of type ByteString");
                }
                if (tag == 6) {
                    t.tlv = new ObjectIdentifier(value);
                } else {
                    try {
                        t.tlv = new PrimitiveTLV(tag, value);
                    }
                    catch (TLVEncodingException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, i, "Invalid tag: " + e.getMessage());
                    }
                }
            }
        }
        if (name != null) {
            t.tlv.setName(name);
        }
        return t;
    }

    public static JsASN1 jsFunction_add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 2, args.length, "Too few arguments");
        }
        JsASN1 obj = (JsASN1)thisObj;
        ConstructedTLV ctlv = null;
        if (obj.tlv instanceof ConstructedTLV) {
            ctlv = (ConstructedTLV)obj.tlv;
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "Object must be a constructed ASN1 (Empty value in constructor)");
        }
        int i = 0;
        int index = ctlv.getElements();
        if (args[i] instanceof Number) {
            Number n = (Number)args[i];
            index = n.intValue();
            if (index < 0 || index >= ctlv.getElements()) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 11, index, "Index is out of range");
            }
            ++i;
        }
        while (i < args.length) {
            if (args[i] instanceof JsASN1) {
                JsASN1 other = (JsASN1)((Object)args[i]);
                ctlv.add(index, other.tlv);
                ++index;
            } else {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, i, "Argument must be of type ASN1");
            }
            ++i;
        }
        return obj;
    }

    public static void jsFunction_remove(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsASN1 obj = (JsASN1)thisObj;
        if (!(obj.tlv instanceof ConstructedTLV)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "Object must be a constructed ASN1");
        }
        ConstructedTLV tlv = (ConstructedTLV)obj.tlv;
        if (index < 0 || index >= tlv.getElements()) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 11, index, "Index is out of range");
        }
        tlv.remove(index);
    }

    public static JsASN1 jsFunction_find(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        TLV result;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int tagval = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsASN1 obj = (JsASN1)thisObj;
        if (!(obj.tlv instanceof ConstructedTLV)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "Object must be a constructed ASN1");
        }
        ConstructedTLV tlv = (ConstructedTLV)obj.tlv;
        Tag tag = null;
        try {
            tag = new Tag(tagval);
        }
        catch (TLVEncodingException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Invalid tag: " + e.getMessage());
        }
        TLV start = null;
        if (args.length > 1 && args[1] != null) {
            if (args[1] instanceof JsASN1) {
                JsASN1 o = (JsASN1)((Object)args[1]);
                start = o.tlv;
            } else {
                int index = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
                if (index < 0 || index >= tlv.getElements()) {
                    GPError.throwAsGPErrorEx(thisObj, clazzName, 11, index, "Index is out of range");
                }
                if (index > 0) {
                    start = tlv.get(index - 1);
                }
            }
        }
        if ((result = tlv.findTag(tag, start)) == null) {
            return null;
        }
        Object[] param = new Object[]{result};
        return (JsASN1)cx.newObject(thisObj, clazzName, param);
    }

    public static JsASN1 jsFunction_get(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsASN1 obj = (JsASN1)thisObj;
        if (!(obj.tlv instanceof ConstructedTLV)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "Object must be a constructed ASN1");
        }
        ConstructedTLV tlv = (ConstructedTLV)obj.tlv;
        if (index < 0 || index >= tlv.getElements()) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 11, index, "Index is out of range");
        }
        TLV element = tlv.get(index);
        Object[] param = new Object[]{element};
        return (JsASN1)cx.newObject(thisObj, clazzName, param);
    }

    public static ByteString jsFunction_getBytes(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ByteString.newInstance(thisObj, ((JsASN1)thisObj).tlv.getBytes());
    }

    public static Scriptable jsFunction_getDate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsASN1 obj = (JsASN1)thisObj;
        if (!(obj.tlv instanceof PrimitiveTLV)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "Object must be a primitive ASN1");
        }
        PrimitiveTLV tlv = (PrimitiveTLV)obj.tlv;
        Date date = null;
        try {
            date = tlv.getDate();
        }
        catch (UnsupportedEncodingException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Invalid date format : " + e.getMessage());
        }
        Object[] param = new Object[]{new Long(date.getTime())};
        return cx.newObject(thisObj, "Date", param);
    }

    public static void jsFunction_setName(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String name = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsASN1 asn = (JsASN1)thisObj;
        asn.tlv.setName(name);
    }

    public static void jsStaticFunction_defineObjectIdentifier(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        String name = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String definition = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        ObjectIdentifierRegistry reg = ObjectIdentifierRegistry.getInstance();
        try {
            reg.addIdentifier(name, definition);
        }
        catch (IllegalArgumentException iae) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Invalid definition for object identifier " + name + " : " + iae.getMessage());
        }
    }

    public static Object jsStaticFunction_nameForObjectIdentifier(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument for nameForObjectIdentifier must be ByteString");
        }
        byte[] b = ((ByteString)((Object)args[0])).getBytes();
        ObjectIdentifierRegistry reg = ObjectIdentifierRegistry.getInstance();
        String name = reg.getNameFor(b);
        if (name == null) {
            return Context.getUndefinedValue();
        }
        return name;
    }

    public String toString() {
        return this.tlv.toString();
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsASN1 asn = (JsASN1)thisObj;
        return asn.tlv.dump();
    }

    public int getChildCount() {
        int childs = 0;
        if (this.tlv instanceof ConstructedTLV) {
            ConstructedTLV ctlv = (ConstructedTLV)this.tlv;
            return ctlv.getElements();
        }
        return childs;
    }

    public boolean isLeaf() {
        return this.tlv instanceof PrimitiveTLV;
    }

    public TreeNode getParent() {
        return null;
    }

    public TreeNode getChildAt(int index) {
        ConstructedTLV ctlv = (ConstructedTLV)this.tlv;
        return ctlv.getChildAt(index);
    }

    public int getIndex(TreeNode child) {
        ConstructedTLV ctlv = (ConstructedTLV)this.tlv;
        return ctlv.getIndex(child);
    }
}

