/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.IsoSecureChannelCredential;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.opencard.service.isocard.TransparentCardService;
import de.cardcontact.opencard.service.remoteclient.RemoteClientCardService;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteUpdateService;
import de.cardcontact.opencard.terminal.TerminalSelector;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.CardEventListenerAdapter;
import de.cardcontact.scdp.gp.GPAtr;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPXML;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.scdp.js.JsIsoSecureChannel;
import de.cardcontact.scdp.js.SecureChannelCredentialWrapper;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.scdp.utils.ByteBuffer;
import de.cardcontact.scdp.utils.GPAPDUTracer;
import java.util.Enumeration;
import java.util.Properties;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.APDUTracer;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Card
extends ScriptableObject
implements CardIDFilter,
RemoteNotificationListener {
    static final int T0 = 0;
    static final int T1 = 1;
    static final int T14 = 14;
    static final int OTHER = 16;
    static final int PICCA = 20;
    static final int PICCB = 21;
    static final int RESET_COLD = 22;
    static final int RESET_WARM = 23;
    static final String clazzName = "Card";
    private static CardEventListenerAdapter cardEventListenerAdapter = null;
    private static CardIDFilter defaultCardIDFilter = null;
    SmartCard sc = null;
    TransparentCardService ptcs = null;
    RemoteUpdateService rus = null;
    boolean allowCardSpecificRemoteUpdateService = false;
    TerminalSelector terminalSelector;
    GPAPDUTracer aPDUTracer = null;

    public String getClassName() {
        return clazzName;
    }

    public SmartCard getSmartCard() {
        return this.sc;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        CardTerminalEvent ctevent = null;
        String reader = null;
        if (!inNewExpr) {
            Context.reportError((String)"Card() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 2);
        if (args.length > 0 && args[0] instanceof CardTerminal) {
            ctevent = new CardTerminalEvent((CardTerminal)args[0], 1, 0);
        } else {
            reader = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        }
        String cardProfileName = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, null);
        Card card = new Card();
        if (cardProfileName != null) {
            Scriptable profile = GPXML.parse((Scriptable)ctorObj, cardProfileName);
            card.put("profile", (Scriptable)card, profile);
        }
        try {
            int i;
            Properties features;
            if (ctevent != null) {
                card.sc = SmartCard.getSmartCard((CardTerminalEvent)ctevent, null, null);
            } else {
                CardRequest cr = new CardRequest(1, null, null);
                cr.setTimeout(1);
                if (reader != null) {
                    card.terminalSelector = new TerminalSelector(reader);
                }
                if ((reader == null || card.terminalSelector.isEmpty()) && defaultCardIDFilter != null) {
                    cr.setFilter(defaultCardIDFilter);
                } else {
                    cr.setFilter((CardIDFilter)card);
                }
                card.sc = SmartCard.waitForCard((CardRequest)cr);
                if (card.sc == null) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 31, 0, "No card in reader or mute card.");
                }
            }
            card.ptcs = (TransparentCardService)card.sc.getCardService(TransparentCardService.class, true);
            GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)ctorObj);
            GPTracer tracer = gpr.getTracer();
            if (tracer != null) {
                card.aPDUTracer = new GPAPDUTracer("de.cardcontact.scdp.gp.Card", tracer);
                card.sc.setAPDUTracer((APDUTracer)card.aPDUTracer);
            }
            if ((features = card.sc.getCardID().getCardTerminal().features()).containsKey("maxCAPDUSize")) {
                i = Integer.parseInt(features.getProperty("maxCAPDUSize"));
                card.defineProperty("maxReaderCAPDU", i, 0);
            }
            if (features.containsKey("maxRAPDUSize")) {
                i = Integer.parseInt(features.getProperty("maxRAPDUSize"));
                card.defineProperty("maxReaderRAPDU", i, 0);
            }
        }
        catch (CardTerminalException cte) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, cte.getMessage());
        }
        return card;
    }

    public static void setDefaultCardIDFilter(CardIDFilter defaultCardIDFilter) {
        Card.defaultCardIDFilter = defaultCardIDFilter;
    }

    public CardTerminal jsGet_nativeCardTerminal() {
        return this.sc.getCardID().getCardTerminal();
    }

    public String jsGet_readerName() {
        return this.sc.getCardID().getCardTerminal().getName();
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"T0", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"T1", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"OTHER", (Object)new Integer(16), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"PICCA", (Object)new Integer(20), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"PICCB", (Object)new Integer(21), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"RESET_COLD", (Object)new Integer(22), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"RESET_WARM", (Object)new Integer(23), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CPRO", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CENC", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"RPRO", (Object)new Integer(4), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"RENC", (Object)new Integer(8), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ALL", (Object)new Integer(65535), (int)0);
    }

    public static void jsFunction_setTraceFormat(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String format = ArgChecker.getString(thisObj, clazzName, args, 0, "");
        Card card = (Card)thisObj;
        if (card.aPDUTracer != null) {
            card.aPDUTracer.setFormat(format);
        }
    }

    public static void jsStaticFunction_setCardEventListener(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        if (cardEventListenerAdapter != null) {
            EventGenerator.getGenerator().removeCTListener((CTListener)cardEventListenerAdapter);
            cardEventListenerAdapter = null;
        }
        if (args.length == 1) {
            Scriptable handler = (Scriptable)args[0];
            cardEventListenerAdapter = new CardEventListenerAdapter(handler.getParentScope(), handler);
            EventGenerator.getGenerator().addCTListener((CTListener)cardEventListenerAdapter);
        }
    }

    public static Scriptable jsStaticFunction_getReaderList(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        Enumeration ctlist = ctr.getCardTerminals();
        int cnt = 0;
        while (ctlist.hasMoreElements()) {
            ctlist.nextElement();
            ++cnt;
        }
        Object[] readerNames = new Object[cnt];
        ctlist = ctr.getCardTerminals();
        cnt = 0;
        while (ctlist.hasMoreElements()) {
            CardTerminal ct = (CardTerminal)ctlist.nextElement();
            readerNames[cnt] = ct.getName();
            ++cnt;
        }
        return cx.newArray(thisObj, readerNames);
    }

    public static GPAtr jsFunction_reset(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int mode = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        Card card = (Card)thisObj;
        SmartCard sc = card.sc;
        GPAtr atr = null;
        try {
            CardID cid = sc.reset(mode == 23);
            ByteString bs = ByteString.newInstance(thisObj, cid.getATR());
            Object[] params = new Object[]{bs};
            atr = (GPAtr)cx.newObject(thisObj, "Atr", params);
            card.ptcs = (TransparentCardService)card.sc.getCardService(TransparentCardService.class, true);
        }
        catch (Exception cte) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "Problem reseting card: " + cte.getMessage());
        }
        return atr;
    }

    public static GPAtr jsFunction_getATR(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        Card card = (Card)thisObj;
        SmartCard sc = card.sc;
        CardID cid = sc.getCardID();
        ByteString bs = ByteString.newInstance(thisObj, cid.getATR());
        Object[] params = new Object[]{bs};
        GPAtr atr = (GPAtr)cx.newObject(thisObj, "Atr", params);
        return atr;
    }

    public static Scriptable jsFunction_sendApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 7);
        byte cla = ArgChecker.getByte(thisObj, clazzName, args, 0, (byte)0);
        byte ins = ArgChecker.getByte(thisObj, clazzName, args, 1, (byte)0);
        byte p1 = ArgChecker.getByte(thisObj, clazzName, args, 2, (byte)0);
        byte p2 = ArgChecker.getByte(thisObj, clazzName, args, 3, (byte)0);
        int index = 4;
        ByteString data = null;
        if (args.length > index && args[index] instanceof ByteString) {
            data = (ByteString)((Object)args[index]);
            ++index;
        }
        int le = -1;
        if (args.length > index && args[index] instanceof Number) {
            le = (int)Context.toNumber((Object)args[index]);
            ++index;
        }
        NativeArray validSW = null;
        if (args.length > index && args[index] instanceof NativeArray) {
            validSW = (NativeArray)args[index];
            ++index;
        }
        if (index != args.length) {
            GPError.throwAsGPErrorEx(thisObj, 16, index, "Type of argument does not match");
        }
        Card card = (Card)thisObj;
        return card.sendApdu(cla, ins, p1, p2, data, le, validSW, 0);
    }

    public static Scriptable jsFunction_sendSecMsgApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 5, 8);
        int usageQualifier = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte cla = ArgChecker.getByte(thisObj, clazzName, args, 1, (byte)0);
        byte ins = ArgChecker.getByte(thisObj, clazzName, args, 2, (byte)0);
        byte p1 = ArgChecker.getByte(thisObj, clazzName, args, 3, (byte)0);
        byte p2 = ArgChecker.getByte(thisObj, clazzName, args, 4, (byte)0);
        int index = 5;
        ByteString data = null;
        if (args.length > index && args[index] instanceof ByteString) {
            data = (ByteString)((Object)args[index]);
            ++index;
        }
        int le = -1;
        if (args.length > index && args[index] instanceof Number) {
            le = (int)Context.toNumber((Object)args[index]);
            ++index;
        }
        NativeArray validSW = null;
        if (args.length > index && args[index] instanceof NativeArray) {
            validSW = (NativeArray)args[index];
            ++index;
        }
        if (index != args.length) {
            GPError.throwAsGPErrorEx(thisObj, 16, index, "Type of argument does not match");
        }
        Card card = (Card)thisObj;
        return card.sendApdu(cla, ins, p1, p2, data, le, validSW, usageQualifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jsFunction_remoteUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        String url = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String sessionId = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        Card card = (Card)thisObj;
        try {
            card.rus = card.allowCardSpecificRemoteUpdateService ? (RemoteUpdateService)card.sc.getCardService(RemoteUpdateService.class, true) : (RemoteUpdateService)card.sc.getCardService(RemoteClientCardService.class, true);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 35, 0, "Card update service not available");
        }
        try {
            card.rus.update(url, sessionId, (RemoteNotificationListener)card);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Card update failed: " + e.toString());
        }
        finally {
            card.rus = null;
        }
    }

    public static void jsFunction_allowCardSpecificRemoteUpdateService(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Card card = (Card)thisObj;
        card.allowCardSpecificRemoteUpdateService = ArgChecker.getBoolean(thisObj, clazzName, args, 0, true);
    }

    public static void jsFunction_cancelRemoteUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        Card card = (Card)thisObj;
        if (card.rus != null) {
            card.rus.cancel();
            card.rus = null;
        }
    }

    public void remoteNotify(int id, String msg, int ttc) {
        this.put("remoteMessageId", (Scriptable)this, new Integer(id));
        this.put("remoteMessage", (Scriptable)this, msg);
        this.put("remoteMessageTTC", (Scriptable)this, new Integer(ttc));
        if (cardEventListenerAdapter != null) {
            cardEventListenerAdapter.cardNotification(this.jsGet_readerName());
        }
    }

    public static byte[] encodeApdu(Scriptable thisObj, byte cla, byte ins, byte p1, byte p2, ByteString data, int le) {
        ByteBuffer bb = new ByteBuffer(261);
        bb.append(cla);
        bb.append(ins);
        bb.append(p1);
        bb.append(p2);
        boolean extended = false;
        if (data != null) {
            byte[] db = data.getBytes();
            if (db.length > 65535) {
                GPError.throwAsGPErrorEx(thisObj, 6, db.length, "ByteString length exceeds limit ( > 65535)");
            }
            if (db.length > 255 || le >= 256) {
                extended = true;
                bb.append((byte)0);
                bb.append((byte)(db.length >> 8));
                bb.append((byte)(db.length & 0xFF));
            } else {
                bb.append((byte)db.length);
            }
            bb.append(db);
        }
        if (le >= 0) {
            if (le > 65536) {
                GPError.throwAsGPErrorEx(thisObj, 13, le, "Le exceeds limit ( > 65536)");
            }
            if (le >= 256 || extended) {
                if (data == null) {
                    bb.append((byte)0);
                }
                if (le == 65536) {
                    le = 0;
                }
                bb.append((byte)(le >> 8));
                bb.append((byte)(le & 0xFF));
            } else {
                bb.append((byte)le);
            }
        }
        return bb.getBytes();
    }

    public ByteString sendApdu(byte cla, byte ins, byte p1, byte p2, ByteString data, int le, NativeArray validSW, int usageQualifier) {
        byte[] com = Card.encodeApdu((Scriptable)this, cla, ins, p1, p2, data, le);
        return this.plainApdu(com, validSW, usageQualifier);
    }

    public static Scriptable jsFunction_plainApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 3);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument must be of type ByteString");
        }
        ByteString apdu = (ByteString)((Object)args[0]);
        NativeArray validSW = null;
        if (args.length > 1 && args[1] instanceof NativeArray) {
            validSW = (NativeArray)args[1];
        }
        int usageQualifier = ArgChecker.getInt(thisObj, clazzName, args, 2, 0);
        Card card = (Card)thisObj;
        return card.plainApdu(apdu.getBytes(), validSW, usageQualifier);
    }

    public ByteString plainApdu(byte[] apdu, NativeArray validSW, int usageQualifier) {
        Object result = null;
        CommandAPDU capdu = new CommandAPDU(apdu);
        ResponseAPDU rapdu = null;
        try {
            rapdu = usageQualifier == 0 ? this.ptcs.sendCommandAPDU(capdu) : this.ptcs.sendCommandAPDU(capdu, usageQualifier);
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        catch (CardNotPresentException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, 0, "Card communication error: " + e.getMessage());
        }
        return this.analyseResponse(rapdu, validSW);
    }

    public ByteString analyseResponse(ResponseAPDU response, NativeArray validSW) {
        byte[] resp = response.data();
        int sw = response.sw();
        if (resp == null) {
            resp = new byte[]{};
        }
        ByteString result = ByteString.newInstance((Scriptable)this, resp);
        this.put("response", (Scriptable)this, (Object)result);
        this.put("SW", (Scriptable)this, new Integer(sw));
        this.put("SW1", (Scriptable)this, new Integer(sw >> 8));
        this.put("SW2", (Scriptable)this, new Integer(sw & 0xFF));
        this.put("SWMSG", (Scriptable)this, StatusWordTable.StringForSW((int)sw));
        if (validSW != null) {
            boolean found = false;
            int i = 0;
            while ((long)i < validSW.getLength()) {
                Object entry = validSW.get(i, (Scriptable)validSW);
                if (!(entry instanceof Number)) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 16, i, "Entry in SW array is not of type Number");
                }
                if ((int)Context.toNumber((Object)entry) == sw) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                GPError.throwAsGPErrorEx((Scriptable)this, 4, sw, "Unexpected " + StatusWordTable.MessageForSW((int)sw) + " received");
            }
        }
        return result;
    }

    public static Object jsFunction_getCardService(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String classname = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        CardService cs = null;
        try {
            Class<?> clazz = Class.forName(classname);
            cs = ((Card)thisObj).sc.getCardService(clazz, false);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
        return Context.javaToJS((Object)cs, (Scriptable)thisObj);
    }

    public boolean isCandidate(CardID cardID) {
        if (this.terminalSelector == null || this.terminalSelector.isEmpty()) {
            return true;
        }
        return this.terminalSelector.isCandidate(cardID);
    }

    public void setCredential(ScriptableObject credential) {
        SecureChannelCredentialWrapper sc;
        IsoCredentialStore credentialStore = new IsoCredentialStore();
        if (credential instanceof JsIsoSecureChannel) {
            JsIsoSecureChannel jisc = (JsIsoSecureChannel)credential;
            sc = new IsoSecureChannelCredential(65535, (SecureChannel)jisc.getIsoSecureChannel());
        } else {
            sc = new SecureChannelCredentialWrapper(65535, credential);
        }
        CardFilePath domain = new CardFilePath(":3F00");
        credentialStore.setSecureChannelCredential((SecurityDomain)domain, (SecureChannelCredential)sc);
        CredentialBag credentialBag = new CredentialBag();
        credentialBag.addCredentialStore((CredentialStore)credentialStore);
        this.setCredentialBag((SecurityDomain)domain, credentialBag);
    }

    public void setCredentialBag(SecurityDomain domain, CredentialBag bag) {
        try {
            this.ptcs.provideCredentials(domain, bag);
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 3, 0, e.getMessage());
        }
    }

    public static void jsFunction_setCredential(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument must be a JavaScript object");
        }
        ((Card)thisObj).setCredential((ScriptableObject)args[0]);
    }

    public static void jsFunction_clearCredential(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        ((Card)thisObj).setCredentialBag(null, null);
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        Card card = (Card)thisObj;
        try {
            card.sc.close();
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
    }
}

