/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.opencard.security.IsoSecureChannel;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.utils.ArgChecker;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsIsoSecureChannel
extends ScriptableObject {
    static final String clazzName = "IsoSecureChannel";
    protected IsoSecureChannel isc = null;
    protected String provider = null;

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SSC_DEFAULT_POLICY", (Object)new Integer(IsoSecureChannel.SSCPolicyEnum.DEFAULT.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SSC_SYNC_POLICY", (Object)new Integer(IsoSecureChannel.SSCPolicyEnum.SYNC.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SSC_SYNC_ENC_POLICY", (Object)new Integer(IsoSecureChannel.SSCPolicyEnum.SYNC_AND_ENCRYPT.ordinal()), (int)0);
    }

    public IsoSecureChannel getIsoSecureChannel() {
        return this.isc;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"IsoSecureChannel() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 2);
        if (!(args[0] instanceof GPCrypto)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Argument must be of type Crypto");
        }
        int policy = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, IsoSecureChannel.SSCPolicyEnum.DEFAULT.ordinal());
        GPCrypto crypto = (GPCrypto)((Object)args[0]);
        JsIsoSecureChannel jisc = new JsIsoSecureChannel();
        jisc.provider = crypto.getProviderName();
        jisc.isc = new IsoSecureChannel(jisc.provider);
        jisc.isc.setSendSequenceCounterPolicy(IsoSecureChannel.SSCPolicyEnum.values()[policy]);
        return jisc;
    }

    public ByteString jsGet_sendSequenceCounter() {
        return ByteString.newInstance((Scriptable)this, this.isc.getSendSequenceCounter());
    }

    public ByteString jsGet_MACSendSequenceCounter() {
        return ByteString.newInstance((Scriptable)this, this.isc.getMACSendSequenceCounter());
    }

    public ByteString jsGet_encryptionSendSequenceCounter() {
        return ByteString.newInstance((Scriptable)this, this.isc.getEncryptionSendSequenceCounter());
    }

    public static byte[] jsFunction_wrap(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        ByteString bs = (ByteString)((Object)args[0]);
        int usageQualifier = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        CommandAPDU commandAPDU = new CommandAPDU(bs.getBytes());
        try {
            commandAPDU = jisc.isc.wrap(commandAPDU, usageQualifier);
        }
        catch (CardServiceInvalidParameterException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, e.getMessage());
        }
        return commandAPDU.getBytes();
    }

    public static byte[] jsFunction_unwrap(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        ByteString bs = (ByteString)((Object)args[0]);
        int usageQualifier = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        ResponseAPDU responseAPDU = new ResponseAPDU(bs.getBytes());
        try {
            responseAPDU = jisc.isc.unwrap(responseAPDU, usageQualifier);
        }
        catch (CardServiceInvalidParameterException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, e.getMessage());
        }
        catch (CardServiceInvalidCredentialException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        return responseAPDU.getBytes();
    }

    public static void jsFunction_setEncKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type Key");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        GPKey key = (GPKey)((Object)args[0]);
        try {
            jisc.isc.setEncKey(key.getJCEKey(jisc.provider));
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
    }

    public static void jsFunction_setMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type Key");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        GPKey key = (GPKey)((Object)args[0]);
        try {
            jisc.isc.setMacKey(key.getJCEKey(jisc.provider));
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
    }

    public static void jsFunction_setSendSequenceCounter(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsIsoSecureChannel.jsFunction_setMACSendSequenceCounter(cx, thisObj, args, funObj);
    }

    public static void jsFunction_setMACSendSequenceCounter(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] != null && !(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        if (args[0] != null) {
            ByteString bs = (ByteString)((Object)args[0]);
            jisc.isc.setMACSendSequenceCounter(bs.getBytes());
        } else {
            jisc.isc.setMACSendSequenceCounter(null);
        }
    }

    public static void jsFunction_setEncryptionSendSequenceCounter(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] != null && !(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString or null");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        if (args[0] != null) {
            ByteString bs = (ByteString)((Object)args[0]);
            jisc.isc.setEncryptionSendSequenceCounter(bs.getBytes());
        } else {
            jisc.isc.setEncryptionSendSequenceCounter(null);
        }
    }

    public static void jsFunction_setIV(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] != null && !(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        if (args[0] != null) {
            ByteString bs = (ByteString)((Object)args[0]);
            jisc.isc.setIV(bs.getBytes());
        } else {
            jisc.isc.setIV(null);
        }
    }

    public static void jsFunction_setCRT(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] != null && !(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        if (args[0] != null) {
            ByteString bs = (ByteString)((Object)args[0]);
            jisc.isc.setCRT(bs.getBytes());
        } else {
            jisc.isc.setCRT(null);
        }
    }

    public static void jsFunction_setMacLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int maclen = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        JsIsoSecureChannel jisc = (JsIsoSecureChannel)thisObj;
        jisc.isc.setMacLength(maclen);
    }
}

