/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.FileResourceContext;
import de.cardcontact.scdp.engine.FileResourceContextFS;
import de.cardcontact.scdp.engine.FileResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileResourceLocatorFS
extends FileResourceLocator {
    protected File currentWorkingDir;
    protected File userDir;
    protected File systemDir;

    public FileResourceLocatorFS(File systemDir, File userDir) {
        this.systemDir = systemDir;
        this.userDir = userDir;
        this.currentWorkingDir = userDir;
    }

    public FileResourceLocatorFS() {
        this.userDir = new File(System.getProperty("user.dir"));
        String exeDir = System.getProperty("scsh3.exepath");
        this.systemDir = exeDir != null ? new File(exeDir) : this.userDir;
        this.currentWorkingDir = this.userDir;
    }

    public boolean exists(String fn) {
        return new File(fn).exists();
    }

    @Override
    public String mapFilename(String filename, int location) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return filename;
        }
        String fn = null;
        switch (location) {
            case 1: {
                file = new File(this.currentWorkingDir, filename);
                fn = file.getAbsolutePath();
                break;
            }
            case 2: {
                file = new File(this.userDir, filename);
                fn = file.getAbsolutePath();
                break;
            }
            case 3: {
                file = new File(this.systemDir, filename);
                fn = file.getAbsolutePath();
                break;
            }
            case 6: {
                fn = this.mapFilename(filename, 1);
                if (this.exists(fn) || this.exists(fn = this.mapFilename(filename, 2)) || this.exists(fn = this.mapFilename(filename, 3))) break;
                fn = null;
                break;
            }
            default: {
                fn = null;
            }
        }
        return fn;
    }

    @Override
    public FileResourceContext getResourceContext() {
        return new FileResourceContextFS(this.currentWorkingDir);
    }

    @Override
    public void setResourceContext(FileResourceContext frc) {
        FileResourceContextFS f = (FileResourceContextFS)frc;
        this.currentWorkingDir = f.getDirectory();
    }

    @Override
    public InputStream openFileResource(String fileName, boolean changeContext) throws FileNotFoundException {
        File f = new File(fileName);
        FileInputStream fis = new FileInputStream(f);
        if (changeContext) {
            this.currentWorkingDir = f.getParentFile();
        }
        return fis;
    }
}

