/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.GPErrorException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class GPError
extends ScriptableObject {
    public static final int ACCESS_DENIED = 1;
    public static final int ARGUMENTS_MISSING = 2;
    public static final int CARD_COMM_ERROR = 3;
    public static final int CARD_INVALID_SW = 4;
    public static final int CRYPTO_FAILED = 5;
    public static final int DATA_TOO_LARGE = 6;
    public static final int DEVICE_ERROR = 7;
    public static final int INVALID_ARGUMENTS = 8;
    public static final int INVALID_DATA = 9;
    public static final int INVALID_ENCODING = 10;
    public static final int INVALID_INDEX = 11;
    public static final int INVALID_KEY = 12;
    public static final int INVALID_LENGTH = 13;
    public static final int INVALID_MECH = 14;
    public static final int INVALID_TAG = 15;
    public static final int INVALID_TYPE = 16;
    public static final int INVALID_USAGE = 17;
    public static final int KEY_NOT_FOUND = 18;
    public static final int OBJECTCREATIONFAILED = 19;
    public static final int SECURE_CHANNEL_WRONG_STATE = 20;
    public static final int TAG_ALREADY_EXISTS = 21;
    public static final int TAG_NOT_FOUND = 22;
    public static final int OBJECT_NOT_FOUND = 23;
    public static final int NOT_YET_VALID = 24;
    public static final int EXPIRED = 25;
    public static final int SIGNATURE_FAILED = 26;
    public static final int AUTHENTICATION_FAILED = 27;
    public static final int NOT_AUTHENTICATED = 28;
    public static final int AUTHENTICATION_METHOD_BLOCKED = 29;
    public static final int OUT_OF_MEMORY = 30;
    public static final int CARD_CONNECT_FAILED = 31;
    public static final int CARD_REMOVED = 32;
    public static final int USER_ABORT = 33;
    public static final int UNDEFINED = 34;
    public static final int UNSUPPORTED = 35;
    public static final int USER_DEFINED = 36;
    public static final int LAST_ERROR = 36;
    public static final String[] ErrorName = new String[]{"ACCESS_DENIED", "ARGUMENTS_MISSING", "CARD_COMM_ERROR", "CARD_INVALID_SW", "CRYPTO_FAILED", "DATA_TOO_LARGE", "DEVICE_ERROR", "INVALID_ARGUMENTS", "INVALID_DATA", "INVALID_ENCODING", "INVALID_INDEX", "INVALID_KEY", "INVALID_LENGTH", "INVALID_MECH", "INVALID_TAG", "INVALID_TYPE", "INVALID_USAGE", "KEY_NOT_FOUND", "OBJECTCREATIONFAILED", "SECURE_CHANNEL_WRONG_STATE", "TAG_ALREADY_EXISTS", "TAG_NOT_FOUND", "OBJECT_NOT_FOUND", "NOT_YET_VALID", "EXPIRED", "SIGNATURE_FAILED", "AUTHENTICATION_FAILED", "NOT_AUTHENTICATED", "AUTHENTICATION_METHOD_BLOCKED", "OUT_OF_MEMORY", "CARD_CONNECT_FAILED", "CARD_REMOVED", "USER_ABORT", "UNDEFINED", "UNSUPPORTED", "USER_DEFINED"};

    public String getClassName() {
        return "GPError";
    }

    public static RuntimeException throwAsGPErrorEx(Scriptable obj, String className, int error, int reason, String message) {
        String sourceName;
        Object[] _args = new Object[]{className, new Integer(error), new Integer(reason), message};
        Context cx = Context.getCurrentContext();
        Scriptable gperr = cx.newObject(ScriptableObject.getTopLevelScope((Scriptable)obj), "GPError", _args);
        JavaScriptException jse = new JavaScriptException((Object)gperr, null, -1);
        WrappedException we = new WrappedException((Throwable)jse);
        int lineNumber = we.lineNumber();
        if (lineNumber > 0) {
            jse.initLineNumber(lineNumber);
        }
        if ((sourceName = we.sourceName()) != null) {
            jse.initSourceName(we.sourceName());
        }
        throw jse;
    }

    public static RuntimeException throwAsGPErrorEx(Scriptable obj, int error, int reason, String message) {
        return GPError.throwAsGPErrorEx(obj, obj.getClassName(), error, reason, message);
    }

    public static RuntimeException throwAsGPErrorEx(Scriptable obj, GPErrorException gee) {
        return GPError.throwAsGPErrorEx(obj, obj.getClassName(), gee.getError(), gee.getReason(), gee.getMessage());
    }

    public void jsConstructor(String className, int error, int reason, String message) {
        this.put("className", (Scriptable)this, className);
        this.put("error", (Scriptable)this, new Integer(error));
        this.put("reason", (Scriptable)this, new Integer(reason));
        this.put("message", (Scriptable)this, message);
        this.put("name", (Scriptable)this, "GPError");
        WrappedException we = new WrappedException((Throwable)new Exception());
        this.put("fileName", (Scriptable)this, we.sourceName());
        this.put("lineNumber", (Scriptable)this, we.lineNumber());
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < st.length; ++i) {
            int linenumber;
            String filename = st[i].getFileName();
            if (filename == null || !filename.endsWith(".js") && !filename.endsWith(".xml") || (linenumber = st[i].getLineNumber()) < 1) continue;
            str.append("    at " + filename + "#" + linenumber + "\n");
        }
        this.put("stack", (Scriptable)this, str.toString());
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        for (int i = 1; i <= 36; ++i) {
            ScriptableObject.defineProperty((Scriptable)ctor, (String)ErrorName[i - 1], (Object)new Integer(i), (int)0);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public String toString() {
        String className = Context.toString((Object)this.get("className", (Scriptable)this));
        int error = (int)Context.toNumber((Object)this.get("error", (Scriptable)this));
        int reason = (int)Context.toNumber((Object)this.get("reason", (Scriptable)this));
        String message = Context.toString((Object)this.get("message", (Scriptable)this));
        String fileName = Context.toString((Object)this.get("fileName", (Scriptable)this));
        int lineNumber = (int)Context.toNumber((Object)this.get("lineNumber", (Scriptable)this));
        String stack = Context.toString((Object)this.get("stack", (Scriptable)this));
        String errtxt = error >= 1 && error <= 36 ? ErrorName[error - 1] : "" + error;
        return className + " (" + errtxt + "/" + reason + ") - \"" + message + "\" in " + fileName + "#" + lineNumber + "\n" + stack;
    }

    public void jsFunction_SelfTest(int error, int reason, String Message) {
        GPError.throwAsGPErrorEx((Scriptable)this, error, reason, Message);
    }
}

