/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsX509;
import de.cardcontact.scdp.ocsp.OCSPQuery;
import de.cardcontact.scdp.ocsp.OCSPQueryException;
import de.cardcontact.scdp.utils.ArgChecker;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsOCSPQuery
extends ScriptableObject {
    public static final String clazzName = "OCSPQuery";
    private OCSPQuery ocspQuery = null;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        X509Certificate rootCert;
        if (!inNewExpr) {
            Context.reportError((String)"OCSPQuery() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 2);
        int i = 0;
        if (args.length == 2) {
            if (!(args[0] instanceof JsX509)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Arguments must be of type X509");
            }
            rootCert = ((JsX509)((Object)args[0])).getCertificate();
            ++i;
        } else {
            rootCert = null;
        }
        if (!(args[i] instanceof JsX509)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, i, "Arguments must be of type X509");
        }
        X509Certificate issuerCert = ((JsX509)((Object)args[i])).getCertificate();
        JsOCSPQuery jso = new JsOCSPQuery();
        jso.ocspQuery = new OCSPQuery(rootCert, issuerCert);
        return jso;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"GOOD", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UNKNOWN", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"REVOKED", (Object)new Integer(100), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"KEYCOMPROMISE", (Object)new Integer(101), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CACOMPROMISE", (Object)new Integer(102), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"AFFILIATIONCHANGED", (Object)new Integer(103), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SUPERSEDED", (Object)new Integer(104), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CESSATIONOFOPERATION", (Object)new Integer(105), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CERTIFICATEHOLD", (Object)new Integer(106), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"REMOVEFROMCRL", (Object)new Integer(108), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"PRIVILEGEWITHDRAWN", (Object)new Integer(109), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"AACOMPROMISE", (Object)new Integer(110), (int)0);
    }

    public static Scriptable jsFunction_add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type X509");
        }
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        JsX509 cert = (JsX509)((Object)args[0]);
        try {
            query.ocspQuery.addCertificate(cert.getCertificate());
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 9, 1, "Certificate could not be added to query: " + oqe.getMessage());
        }
        return query;
    }

    public static Scriptable jsFunction_execute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        String urlstring = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        try {
            if (urlstring != null) {
                query.ocspQuery.execute(urlstring);
            } else {
                query.ocspQuery.execute();
            }
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP query failed: " + oqe.getMessage());
        }
        return query;
    }

    public static Scriptable jsFunction_post(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        String urlstring = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        if (urlstring == null) {
            GPError.throwAsGPErrorEx(thisObj, 9, 1, "URL must be defined");
        }
        if (!(args[1] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 2, "Argument must be of type ByteString");
        }
        ByteString bs = (ByteString)((Object)args[1]);
        String[] header = null;
        if (args.length == 3) {
            if (!(args[2] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 3, "Argument must be of type Array");
            }
            NativeArray na = (NativeArray)args[2];
            int alen = (int)na.getLength();
            header = new String[alen];
            for (int i = 0; i < alen; ++i) {
                Object entry = na.get(i, (Scriptable)na);
                if (!(entry instanceof CharSequence)) {
                    GPError.throwAsGPErrorEx(thisObj, 16, i, "Entry in SW array is not of type String");
                }
                header[i] = ((CharSequence)entry).toString();
            }
        }
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        byte[] response = null;
        try {
            response = query.ocspQuery.post(urlstring, bs.getBytes(), header);
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP post failed: " + oqe.getMessage());
        }
        return ByteString.newInstance(thisObj, response);
    }

    public static int jsFunction_getStatus(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type X509");
        }
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        JsX509 cert = (JsX509)((Object)args[0]);
        int result = -1;
        try {
            result = query.ocspQuery.certStatus(cert.getCertificate());
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP query failed: " + oqe.getMessage());
        }
        return result;
    }

    public static String jsFunction_getStatusString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type X509");
        }
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        JsX509 cert = (JsX509)((Object)args[0]);
        String result = null;
        try {
            result = OCSPQuery.reasonText(query.ocspQuery.certStatus(cert.getCertificate()));
            Date rd = query.ocspQuery.getRevocationTime(cert.getCertificate());
            if (rd != null) {
                result = result + " on " + rd.toString();
            }
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP query failed: " + oqe.getMessage());
        }
        return result;
    }

    public static Scriptable jsFunction_getRevocationTime(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type X509");
        }
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        JsX509 cert = (JsX509)((Object)args[0]);
        Date result = null;
        try {
            result = query.ocspQuery.getRevocationTime(cert.getCertificate());
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP query failed: " + oqe.getMessage());
        }
        Object[] param = new Object[]{new Long(result.getTime())};
        return cx.newObject(thisObj, "Date", param);
    }

    public static ByteString jsFunction_getRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        ByteString result = null;
        try {
            result = ByteString.newInstance(thisObj, query.ocspQuery.getRequest());
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP error: " + oqe.getMessage());
        }
        return result;
    }

    public static ByteString jsFunction_getResponse(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsOCSPQuery query = (JsOCSPQuery)thisObj;
        ByteString result = null;
        try {
            result = ByteString.newInstance(thisObj, query.ocspQuery.getResponse());
        }
        catch (OCSPQueryException oqe) {
            GPError.throwAsGPErrorEx(thisObj, 7, 0, "OCSP error: " + oqe.getMessage());
        }
        return result;
    }
}

