/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.js.GPTracer;
import java.io.PrintStream;

public class PrintStreamTracer
implements GPTracer {
    private PrintStream ps;
    private StringBuffer traceCopy = null;
    private GPTracer.LogLevel currentLogLevel = GPTracer.LogLevel.INFO;

    public PrintStreamTracer(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public boolean isTraceEnabled(String source, GPTracer.LogLevel logLevel) {
        return this.currentLogLevel.ordinal() <= logLevel.ordinal();
    }

    @Override
    public void setTraceLevel(String clazzName, GPTracer.LogLevel logLevel) {
        this.currentLogLevel = logLevel;
    }

    @Override
    public boolean trace(String clazzName, GPTracer.LogLevel logLevel, Object obj) {
        if (!this.isTraceEnabled(clazzName, logLevel)) {
            return false;
        }
        String str = "";
        if (logLevel == GPTracer.LogLevel.DEBUG && !clazzName.equals("de.cardcontact.scdp.gp.Card")) {
            str = clazzName + " : ";
        }
        str = str + obj.toString();
        this.ps.println(str);
        if (this.traceCopy != null) {
            this.traceCopy.append(str);
            this.traceCopy.append('\n');
        }
        return true;
    }

    @Override
    public String copy() {
        if (this.traceCopy == null) {
            return null;
        }
        return this.traceCopy.toString();
    }

    @Override
    public void mark() {
        this.traceCopy = new StringBuffer(1024);
    }
}

