/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.crypto.CryptoBC;
import de.cardcontact.scdp.gp.crypto.CryptoSmartCardHSM;
import de.cardcontact.scdp.gp.crypto.ICrypto;
import de.cardcontact.scdp.utils.ArgChecker;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPCrypto
extends ScriptableObject {
    private static final long serialVersionUID = -1932127310465264390L;
    static final String clazzName = "Crypto";
    public static final String[] algoName = new String[]{"DES", "DES_CBC", "DES_CBC_LP", "DES_CBC_P", "DES_ECB", "DES_ECB_LP", "DES_ECB_P", "DES_MAC", "DES_MAC_EMV", "DES_DES2", "ISO9797_METHOD_1", "ISO9797_METHOD_2", "MD5", "RSA", "RSA_ISO9796_2", "SHA_1", "EC", "ECDSA", "ECDH", "ECDHC", "ECDHP", "EC_MULTIPLY_ADD", "DSA", "SHA_224", "SHA_256", "SHA_384", "SHA_512", "ECDSA_SHA1", "ECDSA_SHA224", "ECDSA_SHA256", "ECDSA_SHA384", "ECDSA_SHA512", "RSA_SHA1", "RSA_SHA224", "RSA_SHA256", "RSA_SHA384", "RSA_SHA512", "RSA_OAEP", "RSA_OAEP_SHA224", "RSA_OAEP_SHA256", "RSA_OAEP_SHA384", "RSA_OAEP_SHA512", "RSA_PKCS1", "RSA_PSS", "RSA_PSS_SHA1", "RSA_PSS_SHA224", "RSA_PSS_SHA256", "RSA_PSS_SHA384", "RSA_PSS_SHA512", "AES_ECB", "AES_CBC", "AES_CTR", "AES_MAC", "AES_CMAC", "HMAC_SHA1", "HMAC_SHA256", "HMAC_MD5", "ISO9797_METHOD_1_16", "ISO9797_METHOD_2_16", "ECELGAMAL", "HMAC_SHA384"};
    protected String providerName;
    private ICrypto impl;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"Crypto() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 2);
        GPCrypto gpCrypto = new GPCrypto();
        gpCrypto.providerName = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, "BC");
        String password = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, null);
        if (gpCrypto.providerName.startsWith("SmartCardHSM")) {
            CryptoSmartCardHSM hsm = new CryptoSmartCardHSM(gpCrypto.providerName);
            if (password != null) {
                hsm.setPassword(password);
            }
            gpCrypto.impl = hsm;
        } else {
            gpCrypto.impl = new CryptoBC();
        }
        return gpCrypto;
    }

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        for (int i = 0; i < algoName.length; ++i) {
            ScriptableObject.defineProperty((Scriptable)ctor, (String)algoName[i], (Object)new Integer(i + 1), (int)0);
        }
    }

    public String getProviderName() {
        return this.providerName;
    }

    public static Scriptable jsFunction_encrypt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 4);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey gpKey = (GPKey)((Object)args[0]);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        ByteString jsdata = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString jsiv = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        byte[] plainText = jsdata.getBytes();
        byte[] iv = null;
        if (jsiv != null) {
            iv = jsiv.getBytes();
        }
        byte[] cipherText = null;
        try {
            cipherText = ((GPCrypto)thisObj).impl.encrypt(gpKey, mech, plainText, iv);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return ByteString.newInstance(thisObj, cipherText);
    }

    public static Scriptable jsFunction_decrypt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 4);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey gpKey = (GPKey)((Object)args[0]);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        ByteString jsdata = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString jsiv = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        byte[] cipherText = jsdata.getBytes();
        byte[] iv = null;
        if (jsiv != null) {
            iv = jsiv.getBytes();
        }
        byte[] plainText = null;
        try {
            plainText = ((GPCrypto)thisObj).impl.decrypt(gpKey, mech, cipherText, iv);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return ByteString.newInstance(thisObj, plainText);
    }

    public static Scriptable jsFunction_sign(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 4);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey gpKey = (GPKey)((Object)args[0]);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        ByteString jsdata = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString jsiv = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        byte[] data = jsdata.getBytes();
        byte[] iv = jsiv == null ? null : jsiv.getBytes();
        byte[] signature = null;
        try {
            signature = ((GPCrypto)thisObj).impl.sign(gpKey, mech, data, iv);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return ByteString.newInstance(thisObj, signature);
    }

    public static boolean jsFunction_verify(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 5);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey gpKey = (GPKey)((Object)args[0]);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        ByteString jsdata = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString jssignature = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        ByteString jsiv = ArgChecker.getByteString(thisObj, clazzName, args, 4, null);
        byte[] data = jsdata.getBytes();
        byte[] iv = jsiv == null ? null : jsiv.getBytes();
        byte[] signature = jssignature.getBytes();
        boolean result = false;
        try {
            result = ((GPCrypto)thisObj).impl.verify(gpKey, mech, data, signature, iv);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return result;
    }

    public static void jsFunction_deriveKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 4);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey masterKey = (GPKey)((Object)args[0]);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        byte[] data = null;
        if (args[2] != null) {
            data = ((ByteString)((Object)args[2])).bs;
        }
        if (!(args[3] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 4, "Argument must be of type Key");
        }
        GPKey derivedKey = (GPKey)((Object)args[3]);
        try {
            ((GPCrypto)thisObj).impl.deriveKey(masterKey, mech, data, derivedKey);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
    }

    public static Scriptable jsFunction_generateRandom(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int randomLength = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        if (randomLength < 0) {
            GPError.throwAsGPErrorEx(thisObj, 8, 8, "Number of requested random bytes is negative!");
        }
        byte[] random = null;
        try {
            random = ((GPCrypto)thisObj).impl.generateRandom(randomLength);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return ByteString.newInstance(thisObj, random);
    }

    public static void jsFunction_generateKeyPair(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        if (!(args[1] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        if (!(args[2] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 2, "Argument must be of type Key");
        }
        GPKey publicKey = (GPKey)((Object)args[1]);
        GPKey privateKey = (GPKey)((Object)args[2]);
        if (publicKey.getKeyType() != 3) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Key must be a public key");
        }
        if (privateKey.getKeyType() != 2) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Key must be a private key");
        }
        try {
            ((GPCrypto)thisObj).impl.generateKeyPair(mech, publicKey, privateKey);
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
    }

    public static Scriptable jsFunction_digest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        byte[] data = ((ByteString)((Object)args[1])).bs;
        int cnt = ArgChecker.getInt(thisObj, clazzName, args, 2, 1);
        byte[] digest = null;
        try {
            for (int i = 0; i < cnt; ++i) {
                digest = ((GPCrypto)thisObj).impl.digest(mech, data);
                data = digest;
            }
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        return ByteString.newInstance(thisObj, digest);
    }

    public ICrypto getImpl() {
        return this.impl;
    }
}

