/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPXML;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class GPKey
extends ScriptableObject
implements Wrapper {
    static final String clazzName = "Key";
    public static final int KEYTYPE_UNKNOWN = 0;
    public static final int KEYTYPE_SECRET = 1;
    public static final int KEYTYPE_PRIVATE = 2;
    public static final int KEYTYPE_PUBLIC = 3;
    public static final String[] keyTypeNames = new String[]{"UNKNOWN", "SECRET", "PRIVATE", "PUBLIC"};
    private int keyType = 0;
    public static final int KEYFORMAT_UNKNOWN = 0;
    public static final int KEYFORMAT_MOD_EXP = 1;
    public static final int KEYFORMAT_CRT = 2;
    public static final int KEYFORMAT_DES = 3;
    public static final int KEYFORMAT_AES = 4;
    public static final int KEYFORMAT_NONE = 5;
    public static final String[] keyFormatNames = new String[]{"UNKNOWN", "MOD_EXP", "CRT", "DES", "AES", "NONE"};
    public static final int DES = 1;
    public static final int AES = 2;
    public static final int MODULUS = 3;
    public static final int EXPONENT = 4;
    public static final int CRT_P = 5;
    public static final int CRT_Q = 6;
    public static final int CRT_DP1 = 7;
    public static final int CRT_DQ1 = 8;
    public static final int CRT_PQ = 9;
    public static final int ECC_A = 10;
    public static final int ECC_B = 11;
    public static final int ECC_GX = 12;
    public static final int ECC_GY = 13;
    public static final int ECC_N = 14;
    public static final int ECC_H = 15;
    public static final int ECC_D = 16;
    public static final int ECC_QX = 17;
    public static final int ECC_QY = 18;
    public static final int ECC_CURVE_OID = 19;
    public static final int ECC_P = 20;
    public static final int ECC_M = 21;
    public static final int ECC_K1 = 22;
    public static final int ECC_K2 = 23;
    public static final int ECC_K3 = 24;
    public static final int GENERIC = 25;
    public static final String[] keyComponentNames = new String[]{"DES", "AES", "MODULUS", "EXPONENT", "CRT_P", "CRT_Q", "CRT_DP1", "CRT_DQ1", "CRT_PQ", "ECC_A", "ECC_B", "ECC_GX", "ECC_GY", "ECC_N", "ECC_H", "ECC_D", "ECC_QX", "ECC_QY", "ECC_CURVE_OID", "ECC_P", "ECC_M", "ECC_K1", "ECC_K2", "ECC_K3", "GENERIC"};
    protected Scriptable keyInfo = null;
    protected int keySize = -1;
    protected String keyId = null;
    protected Key jceKey = null;
    static HashMap<BigInteger, byte[]> curveMap = new HashMap();

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"Key() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 1);
        GPKey key = new GPKey();
        if (args.length > 0) {
            if (args[0] instanceof GPKey) {
                key.copyFrom((GPKey)((Object)args[0]));
            } else {
                ByteString curveoid;
                Scriptable profile = null;
                if (args[0] instanceof CharSequence) {
                    profile = GPXML.parse((Scriptable)ctorObj, ((CharSequence)args[0]).toString());
                } else if (args[0] instanceof Scriptable) {
                    profile = (Scriptable)args[0];
                } else {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Argument must be of type string");
                }
                key.put("profile", (Scriptable)key, profile);
                if (profile.has("KeyInfo", profile)) {
                    key.keyInfo = (Scriptable)profile.get("KeyInfo", profile);
                    if (key.keyInfo.has("Type", key.keyInfo)) {
                        key.keyType = GPXML.getObjectAsToken(key.keyInfo, "Type", keyTypeNames);
                    }
                    if (key.keyInfo.has("Size", key.keyInfo)) {
                        key.keySize = GPXML.getIntegerProperty(key.keyInfo, "Size", -1);
                    }
                    if (key.keyInfo.has("ID", key.keyInfo)) {
                        key.keyId = GPXML.getStringProperty(key.keyInfo, "ID", null);
                    }
                }
                if ((key.keyType == 2 || key.keyType == 3) && (curveoid = key.getComponentFromProfile(19)) != null) {
                    key.setParentScope(ctorObj.getParentScope());
                    key.setECParameterFromEncodedOID(curveoid.getBytes());
                }
            }
        }
        return key;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        for (int i = 0; i < keyComponentNames.length; ++i) {
            ScriptableObject.defineProperty((Scriptable)ctor, (String)keyComponentNames[i], (Object)new Integer(i + 1), (int)0);
        }
        ScriptableObject.defineProperty((Scriptable)ctor, (String)keyTypeNames[1], (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)keyTypeNames[2], (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)keyTypeNames[3], (Object)new Integer(3), (int)0);
    }

    public Object unwrap() {
        return this.jceKey;
    }

    public static void jsFunction_setComponent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int type = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        GPKey gpk = (GPKey)thisObj;
        int keySize = -1;
        switch (type) {
            case 1: 
            case 2: 
            case 25: {
                if (gpk.keyType == 0) {
                    gpk.setKeyType(1);
                } else if (gpk.keyType != 1) {
                    GPError.throwAsGPErrorEx(thisObj, 9, 9, "Specified component is not valid for the key type!");
                }
                gpk.keySize = bs.getBytes().length << 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: {
                if (gpk.keyType == 0) {
                    gpk.setKeyType(2);
                } else if (gpk.keyType != 2) {
                    GPError.throwAsGPErrorEx(thisObj, 9, 9, "Specified component is not valid for the key type!");
                }
                if (type == 16) break;
                keySize = bs.getBytes().length << 4;
                break;
            }
            case 17: 
            case 18: {
                if (gpk.keyType == 0) {
                    gpk.setKeyType(3);
                    break;
                }
                if (gpk.keyType == 3) break;
                GPError.throwAsGPErrorEx(thisObj, 9, 9, "Specified component is not valid for the key type!");
                break;
            }
            case 3: {
                keySize = bs.getBytes().length << 3;
            }
            case 4: {
                if (gpk.keyType != 0) break;
                GPError.throwAsGPErrorEx(thisObj, 9, 9, "Key type is unknown");
                break;
            }
            case 19: {
                gpk.setECParameterFromEncodedOID(bs.getBytes());
                break;
            }
            case 20: {
                keySize = bs.getBytes().length << 3;
                BigInteger p = new BigInteger(1, bs.getBytes());
                byte[] oid = curveMap.get(p);
                if (oid == null) break;
                thisObj.put(19, thisObj, (Object)ByteString.newInstance(thisObj, oid));
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                GPError.throwAsGPErrorEx(thisObj, 9, 9, "Specified component is unknown!");
            }
        }
        if (keySize != -1) {
            if (gpk.keySize != -1) {
                if (keySize != gpk.keySize) {
                    GPError.throwAsGPErrorEx(thisObj, 9, gpk.keySize, "Invalid key component size");
                }
            } else {
                gpk.keySize = keySize;
            }
        }
        gpk.jceKey = null;
        thisObj.put(type, thisObj, (Object)bs);
    }

    public static Object jsFunction_getComponent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int type = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        GPKey gpkey = (GPKey)thisObj;
        Object obj = gpkey.getComponent(type);
        if (obj == null || ((Object)obj).equals(Scriptable.NOT_FOUND)) {
            obj = Context.getUndefinedValue();
        }
        return obj;
    }

    public static void jsFunction_setType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int type = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        if (type != 1 && type != 2 && type != 3) {
            GPError.throwAsGPErrorEx(thisObj, 9, 9, "Specified type is unknown!");
        }
        GPKey gpk = (GPKey)thisObj;
        gpk.setKeyType(type);
    }

    public static int jsFunction_getType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        GPKey gpk = (GPKey)thisObj;
        return gpk.keyType;
    }

    public static void jsFunction_setSize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int size = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        GPKey gpk = (GPKey)thisObj;
        if (gpk.keySize != -1) {
            GPError.throwAsGPErrorEx(thisObj, 1, 0, "Key size already specified");
        }
        gpk.keySize = size;
    }

    public static int jsFunction_getSize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        GPKey gpk = (GPKey)thisObj;
        return gpk.getKeySize();
    }

    public static void jsFunction_setID(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String id = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        if (id == null || id.length() == 0) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "No or empty id specified");
        }
        GPKey gpk = (GPKey)thisObj;
        gpk.keyId = id;
    }

    public static ECPoint jsFunction_getECPoint(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        GPKey gpk = (GPKey)thisObj;
        ByteString qx = gpk.getComponent(17);
        ByteString qy = gpk.getComponent(18);
        if (qx == null || qy == null) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "ECC_QX and ECC_QY must be specified");
        }
        ECParameterSpec ecParameterSpec = gpk.getECParameter();
        ECCurve curve = ecParameterSpec.getCurve();
        BigInteger qxi = new BigInteger(1, qx.getBytes());
        BigInteger qyi = new BigInteger(1, qy.getBytes());
        return curve.createPoint(qxi, qyi);
    }

    public static byte[] unsignedBigIntegerToByteArray(BigInteger bi, int size) {
        byte[] s = bi.toByteArray();
        size = (size >> 3) + ((size & 7) == 0 ? 0 : 1);
        byte[] d = new byte[size];
        int od = size - s.length;
        int os = 0;
        if (od < 0) {
            if (od < -1 || s[0] != 0 && s[0] != 1) {
                throw new IllegalArgumentException("Size mismatch converting big integer to byte array");
            }
            if (s[0] == 1) {
                d = new byte[++size];
                os = 0;
            } else {
                os = -od;
            }
            od = 0;
        }
        System.arraycopy(s, os, d, od, size -= od);
        return d;
    }

    public static byte[] integerToByteArray(int i) {
        int size = i > 0xFFFFFF ? 4 : (i > 65535 ? 3 : (i > 255 ? 2 : 1));
        byte[] r = new byte[size];
        for (int j = size - 1; j >= 0; --j) {
            r[j] = (byte)(i & 0xFF);
            i >>= 8;
        }
        return r;
    }

    public static int byteArrayToInteger(byte[] b) {
        if (b.length > 4) {
            throw new IllegalArgumentException("Byte array exceeds 4 byte limit");
        }
        int akku = 0;
        for (int j = b.length - 1; j >= 0; --j) {
            akku = akku << 8 | b[j] & 0xFF;
        }
        return akku;
    }

    public void setJCEKey(Key key) throws GeneralSecurityException {
        SecretKeySpec k;
        this.jceKey = key;
        if (key instanceof ECPublicKey) {
            ECPublicKey k2 = (ECPublicKey)key;
            this.setECParameter(k2.getParameters());
            ECPoint pq = k2.getQ();
            pq.normalize();
            byte[] b = GPKey.unsignedBigIntegerToByteArray(pq.getAffineXCoord().toBigInteger(), this.keySize);
            this.put(17, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = GPKey.unsignedBigIntegerToByteArray(pq.getAffineYCoord().toBigInteger(), this.keySize);
            this.put(18, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        } else if (key instanceof ECPrivateKey) {
            ECPrivateKey k3 = (ECPrivateKey)key;
            this.setECParameter(k3.getParameters());
            byte[] b = GPKey.unsignedBigIntegerToByteArray(k3.getD(), this.keySize);
            this.put(16, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        } else if (key instanceof RSAPublicKey) {
            RSAPublicKey k4 = (RSAPublicKey)key;
            this.keySize = k4.getModulus().bitLength();
            byte[] b = GPKey.unsignedBigIntegerToByteArray(k4.getModulus(), this.keySize);
            this.put(3, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = k4.getPublicExponent().toByteArray();
            this.put(4, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        } else if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k5 = (RSAPrivateCrtKey)key;
            this.keySize = k5.getPrimeP().bitLength() << 1;
            byte[] b = GPKey.unsignedBigIntegerToByteArray(k5.getPrimeP(), this.keySize >> 1);
            this.put(5, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = GPKey.unsignedBigIntegerToByteArray(k5.getPrimeQ(), this.keySize >> 1);
            this.put(6, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = GPKey.unsignedBigIntegerToByteArray(k5.getPrimeExponentP(), this.keySize >> 1);
            this.put(7, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = GPKey.unsignedBigIntegerToByteArray(k5.getPrimeExponentQ(), this.keySize >> 1);
            this.put(8, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
            b = GPKey.unsignedBigIntegerToByteArray(k5.getCrtCoefficient(), this.keySize >> 1);
            this.put(9, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        } else if (key instanceof SecretKeySpec && (k = (SecretKeySpec)key).getAlgorithm().equals("AES")) {
            this.put(2, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, k.getEncoded()));
        }
    }

    private void setECParameterFromEncodedOID(byte[] bs) {
        ASN1ObjectIdentifier d = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(6);
            bos.write(bs.length);
            bos.write(bs);
            d = ASN1ObjectIdentifier.getInstance((Object)bos.toByteArray());
        }
        catch (IOException bos) {
            // empty catch block
        }
        X9ECParameters p = X962NamedCurves.getByOID(d);
        if (p == null) {
            p = SECNamedCurves.getByOID(d);
        }
        if (p == null) {
            p = NISTNamedCurves.getByOID(d);
        }
        if (p == null) {
            p = X962NamedCurves.getByOID(d);
        }
        if (p == null) {
            p = TeleTrusTNamedCurves.getByOID(d);
        }
        if (p == null) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "No curve found matching that object identifier");
        }
        ECParameterSpec param = new ECParameterSpec(p.getCurve(), p.getG(), p.getN(), p.getH());
        this.setECParameter(param);
    }

    protected void setECCurve(ECCurve curve) {
        byte[] b;
        if (curve instanceof ECCurve.AbstractFp) {
            BigInteger p = curve.getField().getCharacteristic();
            this.keySize = p.bitLength();
            if ((this.keySize & 7) > 0) {
                this.keySize = (this.keySize & 0xFFFFFFF8) + 8;
            }
            b = GPKey.unsignedBigIntegerToByteArray(p, this.keySize);
            this.put(20, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        } else {
            ECCurve.F2m f2mcurve = (ECCurve.F2m)curve;
            this.keySize = f2mcurve.getM();
            this.put(21, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, GPKey.integerToByteArray(f2mcurve.getM())));
            this.put(22, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, GPKey.integerToByteArray(f2mcurve.getK1())));
            this.put(23, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, GPKey.integerToByteArray(f2mcurve.getK2())));
            this.put(24, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, GPKey.integerToByteArray(f2mcurve.getK3())));
        }
        b = GPKey.unsignedBigIntegerToByteArray(curve.getA().toBigInteger(), this.keySize);
        this.put(10, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        b = GPKey.unsignedBigIntegerToByteArray(curve.getB().toBigInteger(), this.keySize);
        this.put(11, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
    }

    void setECParameter(ECParameterSpec p) {
        this.setECCurve(p.getCurve());
        ECPoint g = p.getG();
        g.normalize();
        byte[] b = GPKey.unsignedBigIntegerToByteArray(g.getAffineXCoord().toBigInteger(), this.keySize);
        this.put(12, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        b = GPKey.unsignedBigIntegerToByteArray(g.getAffineYCoord().toBigInteger(), this.keySize);
        this.put(13, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        b = GPKey.unsignedBigIntegerToByteArray(p.getN(), this.keySize);
        this.put(14, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
        b = GPKey.unsignedBigIntegerToByteArray(p.getH(), this.keySize);
        this.put(15, (Scriptable)this, (Object)ByteString.newInstance((Scriptable)this, b));
    }

    protected ECCurve getECCurve() {
        ECCurve.Fp curve;
        ByteString c;
        ByteString a = this.getComponent(10);
        ByteString b = this.getComponent(11);
        ByteString p = this.getComponent(20);
        ByteString m = this.getComponent(21);
        ByteString k1 = this.getComponent(22);
        ByteString k2 = this.getComponent(23);
        ByteString k3 = this.getComponent(24);
        if (p == null && a == null && b == null && m == null && k1 == null && k2 == null && k3 == null && (c = this.getComponent(19)) != null) {
            this.setECParameterFromEncodedOID(c.getBytes());
            a = this.getComponent(10);
            b = this.getComponent(11);
            p = this.getComponent(20);
            m = this.getComponent(21);
            k1 = this.getComponent(22);
            k2 = this.getComponent(23);
            k3 = this.getComponent(24);
        }
        if (a == null || b == null) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "One of the curve parameter a or b missing");
        }
        BigInteger ai = new BigInteger(1, a.getBytes());
        BigInteger bi = new BigInteger(1, b.getBytes());
        if (p != null) {
            if (m != null || k1 != null || k2 != null || k3 != null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Fp curve can not have parameter M, K1, K2 or K3");
            }
            BigInteger pi = new BigInteger(1, p.getBytes());
            curve = new ECCurve.Fp(pi, ai, bi);
            this.keySize = pi.bitLength();
            if ((this.keySize & 7) > 0) {
                this.keySize = (this.keySize & 0xFFFFFFF8) + 8;
            }
        } else {
            if (m == null || k1 == null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "F2m curve requires parameter M and K1 at least");
            }
            int mi = GPKey.byteArrayToInteger(m.getBytes());
            int k1i = GPKey.byteArrayToInteger(k1.getBytes());
            int k2i = 0;
            if (k2 != null) {
                k2i = GPKey.byteArrayToInteger(k2.getBytes());
            }
            int k3i = 0;
            if (k3 != null) {
                k3i = GPKey.byteArrayToInteger(k3.getBytes());
            }
            curve = new ECCurve.F2m(mi, k1i, k2i, k3i, ai, bi);
            this.keySize = mi;
        }
        return curve;
    }

    public ECParameterSpec getECParameter() {
        ECCurve curve = this.getECCurve();
        ByteString gx = this.getComponent(12);
        ByteString gy = this.getComponent(13);
        ByteString n = this.getComponent(14);
        ByteString h = this.getComponent(15);
        if (gx == null || gy == null || h == null || n == null) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "One of the curve parameter Gx, Gy, h or n missing");
        }
        BigInteger gxi = new BigInteger(1, gx.getBytes());
        BigInteger gyi = new BigInteger(1, gy.getBytes());
        BigInteger ni = new BigInteger(1, n.getBytes());
        BigInteger hi = new BigInteger(1, h.getBytes());
        ECPoint g = curve.createPoint(gxi, gyi);
        ECParameterSpec p = new ECParameterSpec(curve, g, ni, hi);
        return p;
    }

    private void generateJCERSAPrivateKey(String providername) throws GeneralSecurityException {
        ByteString modulus = this.getComponent(3);
        ByteString exponent = this.getComponent(4);
        ByteString p = this.getComponent(5);
        ByteString q = this.getComponent(6);
        ByteString dp = this.getComponent(7);
        ByteString dq = this.getComponent(8);
        ByteString pq = this.getComponent(9);
        if (p != null || q != null || dp != null || dq != null || pq != null) {
            if (!(p instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component CRT_P not found");
            }
            if (!(q instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component CRT_Q not found");
            }
            if (!(dp instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component CRT_DP not found");
            }
            if (!(dq instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component CRT_DQ not found");
            }
            if (!(pq instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component CRT_PQ not found");
            }
            BigInteger bigE = null;
            if (exponent instanceof ByteString) {
                bigE = new BigInteger(1, exponent.getBytes());
            }
            BigInteger bigP = new BigInteger(1, p.getBytes());
            BigInteger bigQ = new BigInteger(1, q.getBytes());
            BigInteger bigN = bigP.multiply(bigQ);
            RSAPrivateCrtKeySpec rsaPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigN, bigE, null, bigP, bigQ, new BigInteger(1, dp.getBytes()), new BigInteger(1, dq.getBytes()), new BigInteger(1, pq.getBytes()));
            this.jceKey = KeyFactory.getInstance("RSA", providername).generatePrivate(rsaPrivateCrtKeySpec);
        } else {
            if (!(modulus instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component MODULUS not found");
            }
            if (!(exponent instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component EXPONENT not found");
            }
            RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(1, modulus.getBytes()), new BigInteger(1, exponent.getBytes()));
            this.jceKey = KeyFactory.getInstance("RSA", providername).generatePrivate(rsaPrivateKeySpec);
        }
    }

    private void generateJCERSAPublicKey(String providername) throws GeneralSecurityException {
        ByteString modulus = this.getComponent(3);
        ByteString exponent = this.getComponent(4);
        if (!(modulus instanceof ByteString)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component MODULUS not found");
        }
        if (!(exponent instanceof ByteString)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component EXPONENT not found");
        }
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, modulus.getBytes()), new BigInteger(1, exponent.getBytes()));
        this.jceKey = KeyFactory.getInstance("RSA", providername).generatePublic(rsaPublicKeySpec);
    }

    private void generateJCEECPrivateKey(String providername) throws GeneralSecurityException {
        ByteString dobj = this.getComponent(16);
        if (dobj == null) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component ECC_D not found");
        }
        byte[] b = dobj.bs;
        BigInteger d = new BigInteger(1, b);
        ECParameterSpec ecParameterSpec = this.getECParameter();
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        this.jceKey = KeyFactory.getInstance("EC", providername).generatePrivate((KeySpec)ecPrivateKeySpec);
    }

    private void generateJCEECPublicKey(String providername) throws GeneralSecurityException {
        ECPoint q;
        ByteString qx = this.getComponent(17);
        ByteString qy = this.getComponent(18);
        ECParameterSpec ecParameterSpec = this.getECParameter();
        ECCurve curve = ecParameterSpec.getCurve();
        if (qx != null && qy != null) {
            BigInteger qxi = new BigInteger(1, qx.getBytes());
            BigInteger qyi = new BigInteger(1, qy.getBytes());
            q = curve.createPoint(qxi, qyi);
        } else {
            if (qx != null || qy != null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key component Qx or Qy missing");
            }
            q = ecParameterSpec.getG();
        }
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(q, ecParameterSpec);
        this.jceKey = KeyFactory.getInstance("EC", providername).generatePublic((KeySpec)ecPublicKeySpec);
    }

    public Key getJCEKey(String providername) throws GeneralSecurityException {
        if (providername == null) {
            providername = "BC";
        }
        if (this.jceKey == null) {
            switch (this.keyType) {
                case 1: {
                    int algo = 1;
                    ByteString obj = this.getComponent(1);
                    if (obj == null) {
                        algo = 2;
                        obj = this.getComponent(2);
                    }
                    if (obj == null) {
                        GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key has no component");
                    }
                    byte[] value = obj.bs;
                    SecretKeyFactory skf = null;
                    KeySpec secretKeySpec = null;
                    if (algo == 1) {
                        if (value.length == 8) {
                            secretKeySpec = new DESKeySpec(value);
                            skf = SecretKeyFactory.getInstance("DES", providername);
                        } else if (value.length == 16 || value.length == 24) {
                            if (value.length == 16) {
                                byte[] temp = (byte[])value.clone();
                                value = new byte[24];
                                System.arraycopy(temp, 0, value, 0, temp.length);
                                System.arraycopy(temp, 0, value, 16, 8);
                            }
                            secretKeySpec = new DESedeKeySpec(value);
                            skf = SecretKeyFactory.getInstance("DESede", providername);
                        } else {
                            GPError.throwAsGPErrorEx((Scriptable)this, 9, value.length, "Key component has invalid length");
                        }
                        this.jceKey = skf.generateSecret(secretKeySpec);
                        break;
                    }
                    this.jceKey = new SecretKeySpec(value, "AES");
                    break;
                }
                case 2: {
                    ByteString obj = this.getComponent(16);
                    if (obj != null && obj instanceof ByteString) {
                        this.generateJCEECPrivateKey(providername);
                        break;
                    }
                    this.generateJCERSAPrivateKey(providername);
                    break;
                }
                case 3: {
                    ByteString obj = this.getComponent(3);
                    if (obj != null && obj instanceof ByteString) {
                        this.generateJCERSAPublicKey(providername);
                        break;
                    }
                    this.generateJCEECPublicKey(providername);
                    break;
                }
                default: {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Key is not valid!");
                }
            }
        }
        return this.jceKey;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyType(int keyType) {
        this.keyType = keyType;
        if (this.keyInfo != null) {
            this.keyInfo.put("Type", this.keyInfo, (Object)keyTypeNames[keyType]);
        }
    }

    public ByteString getComponent(int component) {
        ByteString bs;
        Object o = this.get(component, (Scriptable)this);
        if (o == NOT_FOUND) {
            bs = this.getComponentFromProfile(component);
            if (bs != null) {
                this.put(component, (Scriptable)this, (Object)bs);
            }
        } else {
            bs = (ByteString)((Object)o);
        }
        return bs;
    }

    public ByteString getComponentFromProfile(int component) {
        Object o = GPXML.getObject((Scriptable)this, "profile.Value.Component");
        if (o == null) {
            return null;
        }
        int format = GPXML.getObjectAsToken((Scriptable)this, "profile.Value.Format", keyFormatNames);
        if (format == -1) {
            format = 5;
        }
        Object[] cl = Context.getCurrentContext().getElements((Scriptable)o);
        String componentName = keyComponentNames[component - 1];
        ByteString bs = null;
        for (int i = 0; i < cl.length; ++i) {
            Scriptable node;
            Object s;
            if (!(cl[i] instanceof Scriptable) || (!((s = GPXML.getObject(node = (Scriptable)cl[i], "Name")) instanceof CharSequence) || !((CharSequence)s).toString().equals(componentName)) && format != 3) continue;
            bs = GPXML.getByteString(node);
            break;
        }
        return bs;
    }

    private void copyFrom(GPKey source) {
        this.keyType = source.keyType;
        this.keySize = source.keySize;
        this.keyId = source.keyId;
        this.keyInfo = source.keyInfo;
        this.jceKey = null;
        Object[] ids = source.getIds();
        for (int i = 0; i < ids.length; ++i) {
            Object v;
            if (ids[i] instanceof Number) {
                int k = ((Number)ids[i]).intValue();
                v = source.get(k, (Scriptable)source);
                this.put(k, (Scriptable)this, v);
                continue;
            }
            String k = (String)ids[i];
            v = source.get(k, (Scriptable)source);
            this.put(k, (Scriptable)this, v);
        }
    }

    static {
        curveMap.put(((ECCurve.Fp)X962NamedCurves.getByName((String)"prime192v1").getCurve()).getQ(), new byte[]{42, -122, 72, -50, 61, 3, 1, 1});
        curveMap.put(((ECCurve.Fp)X962NamedCurves.getByName((String)"prime256v1").getCurve()).getQ(), new byte[]{42, -122, 72, -50, 61, 3, 1, 7});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP160r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 1});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP192r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 3});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP224r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 5});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP256r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 7});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP320r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 9});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP384r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 11});
        curveMap.put(((ECCurve.Fp)TeleTrusTNamedCurves.getByName((String)"brainpoolP512r1").getCurve()).getQ(), new byte[]{43, 36, 3, 3, 2, 8, 1, 1, 13});
        curveMap.put(((ECCurve.Fp)SECNamedCurves.getByName((String)"secp192k1").getCurve()).getQ(), new byte[]{43, -127, 4, 0, 31});
        curveMap.put(((ECCurve.Fp)SECNamedCurves.getByName((String)"secp256k1").getCurve()).getQ(), new byte[]{43, -127, 4, 0, 10});
        curveMap.put(((ECCurve.Fp)SECNamedCurves.getByName((String)"secp384r1").getCurve()).getQ(), new byte[]{43, -127, 4, 0, 34});
        curveMap.put(((ECCurve.Fp)SECNamedCurves.getByName((String)"secp521r1").getCurve()).getQ(), new byte[]{43, -127, 4, 0, 35});
    }
}

