/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsLDAP
extends ScriptableObject {
    public static final String clazzName = "LDAP";
    DirContext dirctx;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"LDAP() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof CharSequence)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Arguments must be of type String");
        }
        String url = ((CharSequence)args[0]).toString();
        JsLDAP ldap = new JsLDAP();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        try {
            ldap.dirctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 7, 0, "Error connecting to LDAP server: " + e.getMessage());
        }
        return ldap;
    }

    public static Scriptable objectFromAttributes(Context cx, Scriptable scope, Attributes attributes) throws NamingException {
        Scriptable obj = cx.newObject(scope);
        NamingEnumeration<? extends Attribute> ae = attributes.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            String name = attr.getID();
            Object value = null;
            Object[] multi = new Object[attr.size()];
            boolean isBinary = name.endsWith(";binary");
            if (isBinary) {
                name = name.substring(0, name.lastIndexOf(59));
            }
            int i = 0;
            NamingEnumeration<?> ma = attr.getAll();
            while (ma.hasMore()) {
                Object attrval = ma.next();
                multi[i] = isBinary ? ByteString.newInstance(obj, (byte[])attrval) : attrval.toString();
                ++i;
            }
            value = attr.size() > 1 ? cx.newArray(scope, multi) : (attr.size() == 1 ? multi[0] : Context.getUndefinedValue());
            obj.put(name, obj, value);
        }
        return obj;
    }

    public static Scriptable jsFunction_get(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String dn = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsLDAP ldap = (JsLDAP)thisObj;
        Scriptable obj = null;
        try {
            Attributes attributes = ldap.dirctx.getAttributes(dn);
            obj = JsLDAP.objectFromAttributes(cx, thisObj, attributes);
        }
        catch (NamingException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Error getting LDAP entry: " + e.getMessage());
        }
        return obj;
    }

    public static Scriptable jsFunction_search(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        String start = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String filter = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        JsLDAP ldap = (JsLDAP)thisObj;
        Scriptable obj = null;
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setTimeLimit(180000);
            NamingEnumeration<SearchResult> answer = ldap.dirctx.search(start, filter, ctls);
            ArrayList<Scriptable> container = new ArrayList<Scriptable>(10);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attr = sr.getAttributes();
                Scriptable node = JsLDAP.objectFromAttributes(cx, thisObj, attr);
                node.put("_name", node, (Object)sr.getName());
                container.add(node);
            }
            obj = cx.newArray(thisObj, container.toArray());
        }
        catch (NamingException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Error getting LDAP entry: " + e.getMessage());
        }
        return obj;
    }
}

