/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.js.JsX509;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsKeyStore
extends ScriptableObject {
    private static final long serialVersionUID = 5769869179526539276L;
    public static final String clazzName = "KeyStore";
    private KeyStore keyStore = null;
    private String filename = null;
    private String password = null;

    public String getClassName() {
        return clazzName;
    }

    public KeyStore jsGet_native() {
        return this.keyStore;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"KeyStore() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 4);
        JsKeyStore jsks = new JsKeyStore();
        if (args.length == 1) {
            if (!(args[0] instanceof KeyStore)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Single argument invocation must specify a native Java KeyStore object");
            }
            jsks.keyStore = (KeyStore)args[0];
        } else {
            String provider = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
            String type = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, "jks");
            jsks.filename = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 2, null);
            jsks.password = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 3, null);
            if (provider.startsWith("SmartCardHSM") && Security.getProvider(provider) == null) {
                SmartCardHSMProvider hsm;
                int delim = provider.indexOf(47);
                if (delim != -1) {
                    String reader = provider.substring(delim + 1);
                    hsm = new SmartCardHSMProvider(reader);
                } else {
                    hsm = new SmartCardHSMProvider();
                }
                Security.addProvider((Provider)hsm);
            }
            try {
                jsks.keyStore = KeyStore.getInstance(type, provider);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 5, 0, "KeyStore instantiation failed: " + e.getMessage());
            }
            FileInputStream is = null;
            if (jsks.filename != null) {
                GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)ctorObj);
                String filename = gpr.mapFilename(jsks.filename, 6);
                if (filename == null) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File " + jsks.filename + " not found");
                }
                File keystorefile = new File(filename);
                is = new FileInputStream(keystorefile);
            }
            char[] p = null;
            if (jsks.password != null) {
                p = jsks.password.toCharArray();
            }
            try {
                jsks.keyStore.load(is, p);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 5, 0, "Loading KeyStore failed: " + e.getMessage());
            }
        }
        return jsks;
    }

    public static Scriptable jsFunction_getAliases(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        Enumeration<String> aliases = jsks.keyStore.aliases();
        Scriptable array = cx.newArray(thisObj, 0);
        int i = 0;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            array.put(i, array, (Object)alias);
            ++i;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jsFunction_store(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        String filename = ArgChecker.getString(thisObj, clazzName, args, 0, jsks.filename);
        String password = ArgChecker.getString(thisObj, clazzName, args, 1, jsks.password);
        OutputStream os = null;
        if (filename != null) {
            GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
            String absfilename = gpr.mapFilename(filename, 6);
            if (absfilename == null) {
                absfilename = gpr.mapFilename(filename, 2);
            }
            File keystorefile = new File(filename);
            try {
                os = new FileOutputStream(keystorefile);
            }
            catch (FileNotFoundException e) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Storing KeyStore failed: " + e.getMessage());
            }
        }
        char[] p = null;
        if (password != null) {
            p = password.toCharArray();
        }
        try {
            jsks.keyStore.store(os, p);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Storing KeyStore failed: " + e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void jsFunction_setKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        Key jcekey;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 3);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey key = (GPKey)((Object)args[0]);
        String password = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        if (jsks.keyStore == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "No key store loaded");
        }
        char[] p = null;
        if (password != null) {
            p = password.toCharArray();
        }
        if ((jcekey = key.getJCEKey(jsks.keyStore.getProvider().getName())) instanceof PrivateKey) {
            if (args.length < 3) {
                GPError.throwAsGPErrorEx(thisObj, 9, 3, "List of certificates required for private key object");
            }
            if (!(args[2] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 3, "Argument must of of type X509[]");
            }
            NativeArray na = (NativeArray)args[2];
            Certificate[] certs = new Certificate[(int)na.getLength()];
            int i = 0;
            while ((long)i < na.getLength()) {
                Object ae = na.get(i, (Scriptable)na);
                if (!(ae instanceof JsX509)) {
                    GPError.throwAsGPErrorEx(thisObj, 16, i, "Argument must of of type X509");
                }
                JsX509 jsx = (JsX509)((Object)ae);
                certs[i] = jsx.getCertificate();
                ++i;
            }
            jsks.keyStore.setKeyEntry(key.getKeyId(), jcekey, p, certs);
        } else {
            jsks.keyStore.setKeyEntry(key.getKeyId(), jcekey, p, null);
        }
    }

    public static void jsFunction_getKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Key");
        }
        GPKey key = (GPKey)((Object)args[0]);
        String password = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        if (jsks.keyStore == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "No key store loaded");
        }
        char[] p = null;
        if (password != null) {
            p = password.toCharArray();
        }
        Key jceKey = null;
        if (key.getKeyType() == 3) {
            Certificate cert = jsks.keyStore.getCertificate(key.getKeyId());
            if (cert != null && cert instanceof CardVerifiableCertificate) {
                CardVerifiableCertificate cvcert = (CardVerifiableCertificate)cert;
                jceKey = cvcert.getPublicKey();
            }
        } else {
            jceKey = jsks.keyStore.getKey(key.getKeyId(), p);
        }
        if (jceKey == null) {
            GPError.throwAsGPErrorEx(thisObj, 18, 0, "Key not found");
        }
        key.setJCEKey(jceKey);
    }

    public static void jsFunction_getKeyFromKeyStore(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        JsKeyStore.jsFunction_getKey(cx, thisObj, args, funObj);
    }

    public static ScriptableObject jsFunction_getCertificate(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        Certificate cert;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String alias = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        if (jsks.keyStore == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "No key store loaded");
        }
        if ((cert = jsks.keyStore.getCertificate(alias)) == null) {
            GPError.throwAsGPErrorEx(thisObj, 23, 0, "Certificate not found");
        }
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            return JsX509.newInstance(thisObj, xcert.getEncoded());
        }
        return ByteString.newInstance(thisObj, cert.getEncoded());
    }

    public static void jsFunction_setCertificate(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        String alias = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        if (!(args[1] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 2, "Argument must be of type X509");
        }
        JsX509 cert = (JsX509)((Object)args[1]);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        if (jsks.keyStore == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "No key store loaded");
        }
        jsks.keyStore.setCertificateEntry(alias, cert.getCertificate());
    }

    public static void jsFunction_deleteEntry(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String alias = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsKeyStore jsks = (JsKeyStore)thisObj;
        if (jsks.keyStore == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "No key store loaded");
        }
        jsks.keyStore.deleteEntry(alias);
    }
}

