/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp.crypto;

import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.crypto.ICrypto;
import java.security.PrivateKey;
import java.security.Signature;

public abstract class AbstractCrypto
implements ICrypto {
    public abstract String getProviderName();

    private String getAlgorithmName(int mech) {
        String algName = null;
        switch (mech) {
            case 18: {
                algName = "NONEwithECDSA";
                break;
            }
            case 28: {
                algName = "SHA1withECDSA";
                break;
            }
            case 29: {
                algName = "SHA224withECDSA";
                break;
            }
            case 30: {
                algName = "SHA256withECDSA";
                break;
            }
            case 31: {
                algName = "SHA384withECDSA";
                break;
            }
            case 32: {
                algName = "SHA512withECDSA";
                break;
            }
            case 14: 
            case 33: {
                algName = "SHA1withRSA";
                break;
            }
            case 34: {
                algName = "SHA224withRSA";
                break;
            }
            case 35: {
                algName = "SHA256withRSA";
                break;
            }
            case 36: {
                algName = "SHA384withRSA";
                break;
            }
            case 37: {
                algName = "SHA512withRSA";
                break;
            }
            case 45: {
                algName = "SHA1withRSAandMGF1";
                break;
            }
            case 46: {
                algName = "SHA224withRSAandMGF1";
                break;
            }
            case 47: {
                algName = "SHA256withRSAandMGF1";
                break;
            }
            case 48: {
                algName = "SHA384withRSAandMGF1";
                break;
            }
            case 49: {
                algName = "SHA512withRSAandMGF1";
            }
        }
        return algName;
    }

    @Override
    public byte[] encrypt(GPKey gpKey, int mech, byte[] plainText, byte[] iv) throws GPErrorException {
        throw new GPErrorException(35, 0, "encrypt() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public byte[] decrypt(GPKey gpKey, int mech, byte[] cipherText, byte[] iv) throws GPErrorException {
        throw new GPErrorException(35, 0, "decrypt() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public byte[] sign(GPKey gpKey, int mech, byte[] data, byte[] iv) throws GPErrorException {
        byte[] signature = null;
        Signature sigAlg = null;
        if (iv != null) {
            throw new GPErrorException(14, mech, "IV not supported for selected mechanism");
        }
        String algName = this.getAlgorithmName(mech);
        if (algName == null) {
            throw new GPErrorException(14, mech, "Specified mechanism not supported");
        }
        try {
            PrivateKey pkey = (PrivateKey)gpKey.getJCEKey(this.getProviderName());
            sigAlg = Signature.getInstance(algName, this.getProviderName());
            sigAlg.initSign(pkey);
            sigAlg.update(data);
            signature = sigAlg.sign();
        }
        catch (Exception e) {
            Throwable ce = e.getCause();
            e.printStackTrace();
            if (ce != null) {
                throw new GPErrorException(5, mech, ce.getMessage());
            }
            throw new GPErrorException(5, mech, e.getMessage());
        }
        return signature;
    }

    @Override
    public boolean verify(GPKey gpKey, int mech, byte[] data, byte[] signature, byte[] iv) throws GPErrorException {
        throw new GPErrorException(35, 0, "verify() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public void deriveKey(GPKey masterKey, int mech, byte[] data, GPKey derivedKey) throws GPErrorException {
        throw new GPErrorException(35, 0, "deriveKey() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public void generateKeyPair(int mech, GPKey publicKey, GPKey privateKey) throws GPErrorException {
        throw new GPErrorException(35, 0, "generateKeyPair() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public byte[] generateRandom(int randomLength) throws GPErrorException {
        throw new GPErrorException(35, 0, "generateRandom() is unsupported by provider " + this.getProviderName());
    }

    @Override
    public byte[] digest(int mech, byte[] data) throws GPErrorException {
        throw new GPErrorException(35, 0, "digest() is unsupported by provider " + this.getProviderName());
    }
}

