/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPTLV_DGI;
import de.cardcontact.scdp.gp.GPTLV_EMV;
import de.cardcontact.scdp.gp.GPTLV_Generic;
import de.cardcontact.scdp.gp.GPTLV_L16;
import de.cardcontact.scdp.gp.TLVDataSizeException;
import de.cardcontact.scdp.gp.TagSizeException;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.ParseBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPTLV
extends ScriptableObject {
    static final String clazzName = "TLV";
    public static final int EMV = 1;
    public static final int DGI = 2;
    public static final int L16 = 3;
    private GPTLV_Generic internal_tlv;
    private int encoding;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"TLV() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 3, 3);
        int tag = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 0, -1);
        ByteString data = ArgChecker.getByteString((Scriptable)ctorObj, clazzName, args, 1, null);
        int encoding = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 2, -1);
        GPTLV gptlv = new GPTLV();
        try {
            switch (encoding) {
                case 1: {
                    gptlv.internal_tlv = new GPTLV_EMV(tag, data.bs);
                    break;
                }
                case 2: {
                    gptlv.internal_tlv = new GPTLV_DGI(tag, data.bs);
                    break;
                }
                case 3: {
                    gptlv.internal_tlv = new GPTLV_L16(tag, data.bs);
                    break;
                }
                default: {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 10, encoding, "Invalid encoding type");
                    break;
                }
            }
        }
        catch (TagSizeException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 15, 0, e.getMessage());
        }
        catch (TLVDataSizeException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 6, 0, e.getMessage());
        }
        gptlv.encoding = encoding;
        return gptlv;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"EMV", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"DGI", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"L16", (Object)new Integer(3), (int)0);
    }

    public String getClassName() {
        return clazzName;
    }

    public long jsGet_encodingMode() {
        return this.encoding;
    }

    public long jsGet_size() {
        return this.internal_tlv.getTLV().length;
    }

    public Scriptable jsFunction_getL() {
        return ByteString.newInstance((Scriptable)this, this.internal_tlv.getL());
    }

    public Scriptable jsFunction_getLV() {
        return ByteString.newInstance((Scriptable)this, this.internal_tlv.getLV());
    }

    public double jsFunction_getTag() {
        return this.internal_tlv.getTag();
    }

    public ByteString jsFunction_getTLV() {
        return ByteString.newInstance((Scriptable)this, this.internal_tlv.getTLV());
    }

    public Scriptable jsFunction_getTV() {
        return ByteString.newInstance((Scriptable)this, this.internal_tlv.getTV());
    }

    public Scriptable jsFunction_getValue() {
        return ByteString.newInstance((Scriptable)this, this.internal_tlv.getValue());
    }

    public static GPTLV newInstance(Scriptable ctorObj, ParseBuffer pb, int encoding) {
        int length = 0;
        int tag = 0;
        byte[] value = null;
        try {
            switch (encoding) {
                case 1: {
                    tag = pb.getTag();
                    length = pb.getDERLength();
                    break;
                }
                case 2: {
                    tag = pb.getUnsignedWord();
                    length = pb.getDGILength();
                    break;
                }
                case 3: {
                    tag = pb.getUnsignedWord();
                    length = pb.getUnsignedWord();
                }
            }
            value = new byte[length];
            pb.get(value, 0, length);
        }
        catch (Exception e) {
            throw GPError.throwAsGPErrorEx(ctorObj, clazzName, 9, 0, "ByteString contains invalid TLV elements");
        }
        Object[] params = new Object[]{new Integer(tag), ByteString.newInstance(ctorObj, value), new Integer(encoding)};
        Context cx = Context.getCurrentContext();
        return (GPTLV)cx.newObject(ctorObj, clazzName, params);
    }

    public static GPTLV newInstance(Scriptable ctorObj, byte[] source, int encoding) {
        ParseBuffer pb = new ParseBuffer(source);
        return GPTLV.newInstance(ctorObj, pb, encoding);
    }

    public GPTLV_Generic getInternal_tlv() {
        return this.internal_tlv;
    }
}

