/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cms;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsX509;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCMSSignedData
extends ScriptableObject {
    private static final long serialVersionUID = 1318771287584030504L;
    static final int SID_ISSUERANDSERIALNUMBER = 1;
    static final int SID_SUBJECTKEYIDENTIFIER = 2;
    static final String ATTR_MESSAGEDIGEST = "1.2.840.113549.1.9.4";
    static final String ATTR_SIGNINGTIME = "1.2.840.113549.1.9.5";
    static final String clazzName = "CMSSignedData";
    private CMSSignedData sd;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CMSSignedData() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        JsCMSSignedData sdo = new JsCMSSignedData();
        ByteString encoded = null;
        if (args[0] instanceof ByteString) {
            encoded = (ByteString)((Object)args[0]);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Argument must be of type ByteString");
        }
        try {
            sdo.sd = new CMSSignedData(encoded.getBytes());
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "ByteString contains no valid encoded CMS signed data object");
        }
        return sdo;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SID_ISSUERANDSERIALNUMBER", (Object)1, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SID_SUBJECTKEYIDENTIFIER", (Object)2, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ATTR_MESSAGEDIGEST", (Object)ATTR_MESSAGEDIGEST, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ATTR_SIGNINGTIME", (Object)ATTR_SIGNINGTIME, (int)0);
    }

    public static Scriptable jsFunction_getSignedContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        return ByteString.newInstance(thisObj, (byte[])cms.sd.getSignedContent().getContent());
    }

    public static int jsFunction_getSignedDataVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        return cms.sd.getVersion();
    }

    public static Scriptable[] jsFunction_getSignedDataDigestAlgorithms(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        ByteString[] digAlgOIDs = null;
        ConstructedTLV tlv = new ConstructedTLV(cms.sd.getEncoded());
        ConstructedTLV appSeq = (ConstructedTLV)tlv.get(1);
        ConstructedTLV seq = (ConstructedTLV)appSeq.get(0);
        ConstructedTLV digestAlgorithmSet = (ConstructedTLV)seq.get(1);
        int size = digestAlgorithmSet.getElements();
        digAlgOIDs = new ByteString[size];
        for (int i = 0; i < size; ++i) {
            ConstructedTLV alg = (ConstructedTLV)digestAlgorithmSet.get(i);
            PrimitiveTLV oidEntry = (PrimitiveTLV)alg.get(0);
            if (oidEntry.getTag().getNumber() != 6) {
                GPError.throwAsGPErrorEx(thisObj, 36, -1, "No OID at specified position");
            }
            digAlgOIDs[i++] = ByteString.newInstance(thisObj, oidEntry.getValue());
        }
        return digAlgOIDs;
    }

    public static Scriptable[] jsFunction_getSignedDataCertificates(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        Store cs = cms.sd.getCertificates();
        Collection c = cs.getMatches(null);
        JsX509[] certs = new JsX509[c.size()];
        int i = 0;
        for (X509CertificateHolder entry : c) {
            certs[i++] = JsX509.newInstance(thisObj, entry.getEncoded());
        }
        return certs;
    }

    public static ByteString jsFunction_getEContentType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        String id = cms.sd.getSignedContentTypeOID();
        ObjectIdentifier oid = new ObjectIdentifier(id);
        return ByteString.newInstance(thisObj, oid.getValue());
    }

    public static int jsFunction_getNumberOfSigners(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        return signers.size();
    }

    public static int jsFunction_getSignerInfoVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoVersion() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInfo si = ((SignerInformation)allSigners[index]).toASN1Structure();
        return si.getVersion().getPositiveValue().intValue();
    }

    public static int jsFunction_getSignerInfoSIDType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        Object[] allSigners;
        SignerInfo si;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoSIDType() out of range");
        }
        return (si = ((SignerInformation)(allSigners = signers.getSigners().toArray())[index]).toASN1Structure()).getSID().isTagged() ? 2 : 1;
    }

    public static boolean jsFunction_isCertificateAvailable(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for isCertificateAvailable() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        Store certs = cms.sd.getCertificates();
        Collection certCollection = certs.getMatches((Selector)si.getSID());
        return !certCollection.isEmpty();
    }

    public static Scriptable jsFunction_getCertificate(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getCertificate() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        Store certs = cms.sd.getCertificates();
        Collection certCollection = certs.getMatches((Selector)si.getSID());
        Iterator certIt = certCollection.iterator();
        X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
        byte[] encoded = cert.getEncoded();
        JsX509 jsX509 = JsX509.newInstance(thisObj, encoded);
        return jsX509;
    }

    public static Scriptable jsFunction_getSignerInfoDigestAlgorithm(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoDigestAlgorithm() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        String oid = si.getDigestAlgOID();
        ByteString temp = ByteString.newInstance(thisObj, oid, 6);
        return temp;
    }

    public static Scriptable jsFunction_getSignerInfoSignedAttribute(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ASN1ObjectIdentifier oid;
        Object[] allSigners;
        SignerInformation si;
        AttributeTable signedAttributes;
        Attribute attr;
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        String type = ArgChecker.getString(thisObj, clazzName, args, 1, "");
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoSignedAttribute() out of range");
        }
        if ((attr = (signedAttributes = (si = (SignerInformation)(allSigners = signers.getSigners().toArray())[index]).getSignedAttributes()).get(oid = new ASN1ObjectIdentifier(type))) == null) {
            return null;
        }
        ASN1Set set = attr.getAttrValues();
        ASN1Encodable obj = set.getObjectAt(0);
        PrimitiveTLV tlv = new PrimitiveTLV(obj.toASN1Primitive().getEncoded());
        byte[] content = tlv.getValue();
        ByteString temp = ByteString.newInstance(thisObj, content);
        return temp;
    }

    public static Scriptable jsFunction_getSignerInfoSignatureAlgorithm(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoSignatureAlgorithm() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        String oid = si.getEncryptionAlgOID();
        ByteString temp = ByteString.newInstance(thisObj, oid, 6);
        return temp;
    }

    public static Scriptable jsFunction_getSignerInfoSignature(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for getSignerInfoSignatureAlgorithm() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        ByteString temp = ByteString.newInstance(thisObj, si.getSignature());
        return temp;
    }

    public static boolean jsFunction_isSignerInfoSignatureValid(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        X509CertificateHolder cert = null;
        if (args.length > 1) {
            if (args[1] instanceof ByteString) {
                ByteString signerCertificate = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
                try {
                    cert = new X509CertificateHolder(signerCertificate.getBytes());
                }
                catch (Exception ce) {
                    GPError.throwAsGPErrorEx(thisObj, 10, 0, ce.getLocalizedMessage());
                }
            } else if (args[1] instanceof JsX509) {
                cert = new X509CertificateHolder(((JsX509)((Object)args[1])).getCertificate().getEncoded());
            } else {
                GPError.throwAsGPErrorEx(thisObj, 8, 1, "Argument must be of type ByteString or X509");
            }
        }
        JsCMSSignedData cms = (JsCMSSignedData)thisObj;
        SignerInformationStore signers = cms.sd.getSignerInfos();
        if (index < 0 || index >= signers.size()) {
            GPError.throwAsGPErrorEx(thisObj, 11, index, "Index for isSignerInfoSignatureValid() out of range");
        }
        Object[] allSigners = signers.getSigners().toArray();
        SignerInformation si = (SignerInformation)allSigners[index];
        if (cert == null) {
            Store certs = cms.sd.getCertificates();
            Collection certCollection = certs.getMatches((Selector)si.getSID());
            if (certCollection.isEmpty()) {
                GPError.throwAsGPErrorEx(thisObj, 23, 0, "There are no signer certificates within the encoded CMS structure");
            }
            Iterator certIt = certCollection.iterator();
            cert = (X509CertificateHolder)certIt.next();
        }
        boolean result = false;
        try {
            JcaDigestCalculatorProviderBuilder dcpb = new JcaDigestCalculatorProviderBuilder();
            dcpb.setProvider("BC");
            JcaSignerInfoVerifierBuilder sivb = new JcaSignerInfoVerifierBuilder(dcpb.build());
            result = si.verify(sivb.build(cert));
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 5, 0, "Could not verify signer: " + e.getMessage());
        }
        return result;
    }
}

