/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.ExecuteRequest;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsTask
extends ScriptableObject
implements ScriptCompletionListener {
    public static final String clazzName = "Task";
    private String message;
    public String status = "created";
    public Shell scope;
    public ScriptExecutor taskex;
    private LinkedBlockingQueue<Object> queue;

    public JsTask() {
    }

    public JsTask(Scriptable scope, Scriptable userObject) {
        this.taskex = new ScriptExecutor();
        this.taskex.start();
        this.queue = new LinkedBlockingQueue();
        Engine engine = Engine.getEngine(scope);
        this.scope = (Shell)engine.newDynamicScope("Shell");
        this.defineProperty("userObject", userObject, 0);
        this.message = Context.toString((Object)userObject);
    }

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            Context.reportError((String)"Task() can not be called as function");
        }
        if (args.length < 1) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 2, args.length, "Too few arguments");
        }
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, args.length, "Argument must be object");
        }
        return new JsTask((Scriptable)ctorObj, (Scriptable)args[0]);
    }

    public String jsGet_status() {
        return this.status;
    }

    public static void jsFunction_dispose(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsTask task = (JsTask)thisObj;
        task.dispose();
    }

    public void dispose() {
        this.stop();
        this.taskex.shutdown();
    }

    public static void jsFunction_start(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsTask task = (JsTask)thisObj;
        task.start();
    }

    public ExecuteRequest newExecuteRequest() {
        Object obj = ScriptableObject.getProperty((Scriptable)this, (String)"userObject");
        Object funObj = JsTask.getProperty((Scriptable)((Scriptable)obj), (String)"run");
        if (!(funObj instanceof Function)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 16, 0, "User object must contain a method run in order to use start()");
        }
        return new ExecuteRequest(this.scope, (Function)funObj, (Scriptable)obj, Context.emptyArgs, this);
    }

    public void start() {
        ExecuteRequest ex = this.newExecuteRequest();
        this.status = "running";
        this.taskex.addRequest(ex);
    }

    @Override
    public void scriptCompleted(Object result) {
        if (result instanceof RhinoException) {
            Engine.printRhinoExceptionMessage((RhinoException)((Object)result), System.err);
            this.status = "failed";
        } else {
            this.status = "passed";
        }
    }

    public static void jsFunction_stop(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsTask task = (JsTask)thisObj;
        task.stop();
    }

    public void stop() {
        this.taskex.abort();
        this.queue.clear();
    }

    public static void jsFunction_setMessage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String message;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsTask task = (JsTask)thisObj;
        task.message = message = ArgChecker.getString(thisObj, clazzName, args, 0, null);
    }

    public String getMessage() {
        return this.message;
    }

    public static void jsFunction_post(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsTask task = (JsTask)thisObj;
        task.queue.add(args[0]);
    }

    public static Object jsFunction_poll(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int timeout = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        JsTask task = (JsTask)thisObj;
        Object o = null;
        try {
            o = task.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            GPError.throwAsGPErrorEx(thisObj, 33, 0, "Queue waiting interrupted");
        }
        return o;
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsTask)thisObj).toString();
    }

    public String toString() {
        return this.message;
    }
}

