/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.opencard.service.globalplatform.SecurityDomainCardService;
import de.cardcontact.opencard.utils.CapFile;
import de.cardcontact.scdp.gp.Application;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPApplication;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPScp02;
import de.cardcontact.scdp.gp.GPXML;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.IOException;
import java.io.InputStream;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.applet.AppletID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPSecurityDomain
extends GPApplication {
    private static final long serialVersionUID = -1781842688226682897L;
    static final String clazzName = "GPSecurityDomain";
    SecurityDomainCardService sdcs = null;

    @Override
    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"GPSecurityDomain() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 6);
        GPSecurityDomain appl = new GPSecurityDomain();
        appl.initialize(ctx, args, ctorObj);
        return appl;
    }

    public SecurityDomainCardService getSecurityDomainCardService() {
        if (this.sdcs == null) {
            Card card = this.getCard();
            try {
                SmartCard sc = card.getSmartCard();
                this.sdcs = (SecurityDomainCardService)sc.getCardService(SecurityDomainCardService.class, true);
            }
            catch (ClassNotFoundException e) {
                GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "Can not find security domain service for card: " + e);
            }
            catch (CardServiceException e) {
                GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "Error creating security domain service for card: " + (Object)((Object)e));
            }
        }
        return this.sdcs;
    }

    public static Scriptable jsFunction_select(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 3);
        boolean next = ArgChecker.getBoolean(thisObj, clazzName, args, 0, false);
        boolean noData = false;
        int i = 1;
        if (args.length > i && args[i] instanceof Boolean) {
            noData = ArgChecker.getBoolean(thisObj, clazzName, args, i, false);
            ++i;
        }
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > i) {
            if (!(args[i] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, i, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[i];
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        AppletID appletId = null;
        if (!noData) {
            Object o = ScriptableObject.getProperty((Scriptable)sd, (String)"aid");
            if (!(o instanceof ByteString)) {
                GPError.throwAsGPErrorEx(thisObj, 23, 0, "Can't find associated aid object");
            }
            appletId = new AppletID(((ByteString)((Object)o)).getBytes());
        }
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.select(appletId, next);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "Select failed with: " + (Object)((Object)e));
        }
        return sd.card.analyseResponse(response, validSW);
    }

    public static void jsFunction_run(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Application.jsFunction_run(cx, thisObj, args, funObj);
    }

    public static Scriptable jsFunction_sendApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return Application.jsFunction_sendApdu(cx, thisObj, args, funObj);
    }

    public static ByteString jsFunction_installForLoad(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 5, 6);
        ByteString loadFileAID = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        ByteString secDomAID = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        ByteString loadDBHash = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString loadParam = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        ByteString loadToken = ArgChecker.getByteString(thisObj, clazzName, args, 4, null);
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > 5) {
            if (!(args[5] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 6, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[5];
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.installForLoad(loadFileAID.getBytes(), secDomAID != null ? secDomAID.getBytes() : null, loadDBHash != null ? loadDBHash.getBytes() : null, loadParam != null ? loadParam.getBytes() : null, loadToken != null ? loadToken.getBytes() : null);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "InstallForLoad failed with: " + (Object)((Object)e));
        }
        return sd.card.analyseResponse(response, validSW);
    }

    public static ByteString jsFunction_installForInstall(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 6, 7);
        ByteString execLFAID = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        ByteString execModAID = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        ByteString appInsAID = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString privileges = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        ByteString installParam = ArgChecker.getByteString(thisObj, clazzName, args, 4, null);
        ByteString installToken = ArgChecker.getByteString(thisObj, clazzName, args, 5, null);
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > 6) {
            if (!(args[6] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 7, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[6];
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.installForInstall(execLFAID.getBytes(), execModAID.getBytes(), appInsAID.getBytes(), privileges.getBytes(), installParam.getBytes(), installToken != null ? installToken.getBytes() : null, false);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "InstallForLoad failed with: " + (Object)((Object)e));
        }
        return sd.card.analyseResponse(response, validSW);
    }

    public static ByteString jsFunction_installForInstallAndSelectable(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 6, 7);
        ByteString execLFAID = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        ByteString execModAID = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        ByteString appInsAID = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        ByteString privileges = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        ByteString installParam = ArgChecker.getByteString(thisObj, clazzName, args, 4, null);
        ByteString installToken = ArgChecker.getByteString(thisObj, clazzName, args, 5, null);
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > 6) {
            if (!(args[6] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 7, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[6];
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.installForInstall(execLFAID.getBytes(), execModAID.getBytes(), appInsAID.getBytes(), privileges.getBytes(), installParam.getBytes(), installToken != null ? installToken.getBytes() : null, true);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "InstallForLoad failed with: " + (Object)((Object)e));
        }
        return sd.card.analyseResponse(response, validSW);
    }

    public static ByteString jsFunction_loadByName(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String capFileName;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            capFileName = bs.jsFunction_toString(3);
        } else {
            capFileName = Context.toString((Object)args[0]);
        }
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        String fqCapFileName = gpr.mapFilename(capFileName, 6);
        if (fqCapFileName == null) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 1, "File not found");
        }
        CapFile cf = new CapFile();
        try {
            InputStream is = gpr.openFileResource(fqCapFileName);
            cf.read(is);
            is.close();
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 1, "Error reading cap file: " + e.getMessage());
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.load(cf);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "Load failed with: " + (Object)((Object)e));
        }
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        return sd.card.analyseResponse(response, validSW);
    }

    public void runSecureChannelScript(String scriptName, Object[] args) {
        Object o = GPXML.getObject((Scriptable)this, "profile.SecureChannel." + scriptName);
        if (o == null) {
            return;
        }
        if (!(o instanceof Scriptable) || o == NOT_FOUND) {
            GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "Script fragment \"" + scriptName + "\" not found in SecureChannel section of application profile");
        }
        Scriptable fragment = (Scriptable)o;
        this.setupKeys(fragment);
        this.setupDataElements(fragment);
        o = fragment.get("Script", (Scriptable)this);
        if (!(o instanceof Function)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Invalid script fragment");
        }
        Function f = (Function)o;
        f.call(Context.getCurrentContext(), (Scriptable)this, (Scriptable)this, args);
    }

    public static Integer jsFunction_openSecureChannel(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int level = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int keySetVersion = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        GPSecurityDomain gpsd = (GPSecurityDomain)thisObj;
        Object crypto = ScriptableObject.getProperty((Scriptable)gpsd, (String)"crypto");
        Object[] param = new Object[]{crypto};
        GPScp02 scp = (GPScp02)cx.newObject(thisObj, "GPScp02", param);
        scp.setSecurityLevel((byte)level);
        scp.setKeySetVersion((byte)keySetVersion);
        scp.setSecurityDomain(gpsd);
        thisObj.put("secureChannel", thisObj, (Object)scp);
        gpsd.runSecureChannelScript("OpenSecureChannel", args);
        return new Integer(level);
    }

    public static ByteString jsFunction_deleteAID(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        ByteString aid = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > 1) {
            if (!(args[1] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 2, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[1];
        }
        GPSecurityDomain sd = (GPSecurityDomain)thisObj;
        sd.getSecurityDomainCardService();
        ResponseAPDU response = null;
        try {
            response = sd.sdcs.deleteAID(aid.getBytes());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "Delete failed with: " + (Object)((Object)e));
        }
        return sd.card.analyseResponse(response, validSW);
    }
}

