/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.HexString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPSystem
extends ScriptableObject {
    static final String clazzName = "GPSystem";
    static final String GP_VERSION = "1.1.0";
    static final GPTracer.LogLevel[] logLevelMap = GPTracer.LogLevel.values();

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CWD", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"USR", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SYS", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"AUTO", (Object)new Integer(6), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"DEBUG", (Object)new Integer(GPTracer.LogLevel.DEBUG.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"INFO", (Object)new Integer(GPTracer.LogLevel.INFO.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"WARN", (Object)new Integer(GPTracer.LogLevel.WARN.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ERROR", (Object)new Integer(GPTracer.LogLevel.ERROR.ordinal()), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"FATAL", (Object)new Integer(GPTracer.LogLevel.FATAL.ordinal()), (int)0);
    }

    public String getClassName() {
        return clazzName;
    }

    public static String jsStaticFunction_mapFilename(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        String filename = ArgChecker.getString(thisObj, clazzName, args, 0, "");
        int location = ArgChecker.getInt(thisObj, clazzName, args, 1, 6);
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        filename = gpr.mapFilename(filename, location);
        return filename;
    }

    public static String jsStaticFunction_getVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return GP_VERSION;
    }

    public static void jsStaticFunction_wait(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int ms = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        Thread.sleep(ms);
    }

    public static boolean jsStaticFunction_trace(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        String str;
        GPRuntime gpr;
        GPTracer tracer;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object obj = args[0];
        if (obj == null) {
            GPError.throwAsGPErrorEx(thisObj, 16, 16, GPError.ErrorName[15]);
        }
        if ((tracer = (gpr = GPRuntimeHelper.getGPRuntime(thisObj)).getTracer()) == null || !tracer.isTraceEnabled("de.cardcontact.scdp.gp.GPSystem", GPTracer.LogLevel.INFO)) {
            return false;
        }
        if (obj instanceof ByteString) {
            ByteString bs = (ByteString)((Object)obj);
            str = HexString.dump((byte[])bs.getBytes());
        } else {
            str = Context.toString((Object)obj);
        }
        return tracer.trace("de.cardcontact.scdp.gp.GPSystem", GPTracer.LogLevel.INFO, str);
    }

    public static boolean jsStaticFunction_isTraceOn(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        String className = ArgChecker.getString(thisObj, clazzName, args, 0, "de.cardcontact.scdp.gp.GPSystem");
        className = className.replace("/", ".");
        int levelint = ArgChecker.getInt(thisObj, clazzName, args, 1, 1);
        GPTracer.LogLevel level = null;
        try {
            level = logLevelMap[levelint];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, "Argument must be one of GPSystem.[DEBUG, INFO, WARN, ERROR, FATAL]");
        }
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        GPTracer tracer = gpr.getTracer();
        if (tracer == null) {
            return false;
        }
        return tracer.isTraceEnabled(className, level);
    }

    public static void jsStaticFunction_setTraceLevel(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        String className = ArgChecker.getString(thisObj, clazzName, args, 0, "");
        className = className.replace("/", ".");
        int levelint = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        GPTracer.LogLevel level = null;
        try {
            level = logLevelMap[levelint];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, "Argument must be one of GPSystem.[DEBUG, INFO, WARN, ERROR, FATAL]");
        }
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        GPTracer tracer = gpr.getTracer();
        if (tracer == null) {
            return;
        }
        tracer.setTraceLevel(className, level);
    }

    public static boolean jsStaticFunction_log(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        Object str;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        int levelint = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPTracer.LogLevel level = null;
        try {
            level = logLevelMap[levelint];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, "Argument must be one of GPSystem.[DEBUG, INFO, WARN, ERROR, FATAL]");
        }
        String className = ArgChecker.getString(thisObj, clazzName, args, 1, "");
        className = className.replace("/", ".");
        Object obj = args[2];
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        GPTracer tracer = gpr.getTracer();
        if (tracer == null) {
            return false;
        }
        if (obj != null && obj instanceof ByteString) {
            ByteString bs = (ByteString)((Object)obj);
            str = HexString.dump((byte[])bs.getBytes());
        } else if (obj instanceof NativeJavaObject) {
            NativeJavaObject njo = (NativeJavaObject)obj;
            Object jo = njo.unwrap();
            if (jo instanceof RhinoException) {
                str = Context.toString((Object)obj);
                str = str + ((RhinoException)((Object)jo)).getScriptStackTrace();
            } else {
                str = jo instanceof Throwable ? jo : jo.toString();
            }
        } else {
            str = Context.toString((Object)obj);
        }
        return tracer.trace(className, level, str);
    }

    public static void jsStaticFunction_markTrace(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        GPTracer tracer = gpr.getTracer();
        if (tracer != null) {
            tracer.mark();
        }
    }

    public static String jsStaticFunction_copyTrace(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        GPTracer tracer = gpr.getTracer();
        if (tracer == null) {
            return null;
        }
        return tracer.copy();
    }

    public static Object jsStaticFunction_getVendorObject(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String objName = ArgChecker.getString(thisObj, clazzName, args, 0, "");
        GPError.throwAsGPErrorEx(thisObj, clazzName, 19, 0, "Object could not be created");
        return null;
    }

    public static ByteString jsStaticFunction_getSystemID(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(thisObj);
        return ByteString.newInstance(thisObj, gpr.getSystemID());
    }

    public static ByteString jsStaticFunction_dateTimeByteString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar now = Calendar.getInstance();
        String time = df.format(now.getTime());
        Object[] params = new Object[]{time, new Integer(16)};
        return (ByteString)cx.newObject(thisObj, "ByteString", params);
    }
}

