/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceContext;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.js.GPTracer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.xml.XMLObject;

public class ExecuteRequest
implements ContextAction {
    private Shell scope = null;
    private Script script = null;
    private Function funObj = null;
    private Scriptable thisObj = null;
    private Object[] args = null;
    private FileResourceContext sfctx;
    private ScriptCompletionListener scl = null;
    private GPTracer tracer = null;

    public ExecuteRequest(Shell scope, Script script, FileResourceContext scriptFileCtx, ScriptCompletionListener callback) {
        this.scope = scope;
        this.script = script;
        this.sfctx = scriptFileCtx;
        this.scl = callback;
    }

    public ExecuteRequest(Shell scope, Function funObj, Scriptable thisObj, Object[] args, ScriptCompletionListener callback) {
        this.scope = scope;
        this.funObj = funObj;
        this.thisObj = thisObj;
        this.args = args;
        this.scl = callback;
    }

    public void setTracer(GPTracer tracer) {
        this.tracer = tracer;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Function getFunObj() {
        return this.funObj;
    }

    public Shell getScope() {
        return this.scope;
    }

    public Script getScript() {
        return this.script;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public ScriptCompletionListener getScriptCompletionListener() {
        return this.scl;
    }

    public Object run(Context ctx) {
        Engine engine = Engine.getEngine((Scriptable)this.scope);
        if (this.tracer != null) {
            engine.setTracerForContext(ctx, this.tracer);
        }
        if (this.script != null) {
            Object result = engine.executeScript(ctx, (Scriptable)this.scope, this.script, this.sfctx);
            if (result instanceof Function && !(result instanceof XMLObject)) {
                Function fo = (Function)result;
                Object lastresult = this.scope.get("lastresult", (Scriptable)this.scope);
                if (lastresult != null) {
                    Object[] args = new Object[]{lastresult};
                    result = fo.call(ctx, (Scriptable)this.scope, (Scriptable)this.scope, args);
                } else {
                    Object[] args = new Object[]{};
                    result = fo.call(ctx, (Scriptable)this.scope, (Scriptable)this.scope, args);
                }
            }
            return result;
        }
        return this.funObj.call(ctx, (Scriptable)this.scope, this.thisObj, this.args);
    }
}

