/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.pkcs11;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.pkcs11.JsPKCS11Session;
import de.cardcontact.scdp.pkcs11.PKCS11GenericObject;
import de.cardcontact.scdp.utils.ArgChecker;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;

public class JsPKCS11Object
extends ScriptableObject {
    public static final String clazzName = "PKCS11Object";
    private PKCS11GenericObject p11object = null;

    public String getClassName() {
        return clazzName;
    }

    public PKCS11Object getPKCS11Object() {
        return this.p11object;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"PKCS11Object() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof JsPKCS11Session)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Argument must be of type PKCS11Session");
        }
        JsPKCS11Object o = new JsPKCS11Object();
        JsPKCS11Session s = (JsPKCS11Session)((Object)args[0]);
        if (args[1] instanceof PKCS11GenericObject) {
            o.p11object = (PKCS11GenericObject)((Object)args[1]);
        } else if (args[1] instanceof ScriptableObject) {
            PKCS11Attribute[] p11attr = JsPKCS11Object.generateAttributeList((Scriptable)ctorObj, (ScriptableObject)args[1]);
            long handle = PKCS11GenericObject.createObject(s.getSession(), p11attr);
            o.p11object = new PKCS11GenericObject(s.getSession(), handle);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 2, "Argument must be of type PKCS11GenericObject or ScriptableObject");
        }
        return o;
    }

    public static PKCS11Attribute[] generateAttributeList(Scriptable scope, ScriptableObject jsattr) {
        Object[] ids = jsattr.getIds();
        PKCS11Attribute[] p11attr = new PKCS11Attribute[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] instanceof Integer) {
                int kind = (Integer)ids[i];
                Object property = jsattr.get(kind, (Scriptable)jsattr);
                if (property instanceof ByteString) {
                    ByteString bs = (ByteString)((Object)property);
                    p11attr[i] = new PKCS11Attribute(kind, bs.getBytes());
                    continue;
                }
                if (property instanceof Boolean) {
                    Boolean b = (Boolean)property;
                    p11attr[i] = new PKCS11Attribute(kind, b.booleanValue());
                    continue;
                }
                if (property instanceof Number) {
                    Number n = (Number)property;
                    p11attr[i] = new PKCS11Attribute(kind, n.intValue());
                    continue;
                }
                if (property instanceof CharSequence) {
                    String str = ((CharSequence)property).toString();
                    p11attr[i] = new PKCS11Attribute(kind, str.getBytes());
                    continue;
                }
                GPError.throwAsGPErrorEx(scope, clazzName, 16, i, "Array contains invalid fields " + property.toString());
                continue;
            }
            GPError.throwAsGPErrorEx(scope, clazzName, 16, i, "Array contains non-numeric indices. Check spelling of CKA_xxx attribute");
        }
        return p11attr;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_DATA", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_CERTIFICATE", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_PUBLIC_KEY", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_PRIVATE_KEY", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_SECRET_KEY", (Object)new Integer(4), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_HW_FEATURE", (Object)new Integer(5), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_DOMAIN_PARAMETERS", (Object)new Integer(6), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKO_MECHANISM", (Object)new Integer(7), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_CLASS", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_TOKEN", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIVATE", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_LABEL", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_APPLICATION", (Object)new Integer(16), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_VALUE", (Object)new Integer(17), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_OBJECT_ID", (Object)new Integer(18), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_CERTIFICATE_TYPE", (Object)new Integer(128), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ISSUER", (Object)new Integer(129), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SERIAL_NUMBER", (Object)new Integer(130), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SERIAL_NUMBER", (Object)new Integer(130), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_OWNER", (Object)new Integer(132), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ATTR_TYPES", (Object)new Integer(133), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_TRUSTED", (Object)new Integer(134), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_CERTIFICATE_CATEGORY", (Object)new Integer(135), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_JAVA_MIDP_SECURITY_DOMAIN", (Object)new Integer(136), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_URL", (Object)new Integer(137), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_HASH_OF_SUBJECT_PUBLIC_KEY", (Object)new Integer(138), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_HASH_OF_ISSUER_PUBLIC_KEY", (Object)new Integer(139), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_CHECK_VALUE", (Object)new Integer(144), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_KEY_TYPE", (Object)new Integer(256), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SUBJECT", (Object)new Integer(257), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ID", (Object)new Integer(258), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SENSITIVE", (Object)new Integer(259), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ENCRYPT", (Object)new Integer(260), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_DECRYPT", (Object)new Integer(261), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_WRAP", (Object)new Integer(262), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_UNWRAP", (Object)new Integer(263), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SIGN", (Object)new Integer(264), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SIGN_RECOVER", (Object)new Integer(265), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_VERIFY", (Object)new Integer(266), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_VERIFY_RECOVER", (Object)new Integer(267), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_DERIVE", (Object)new Integer(268), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_START_DATE", (Object)new Integer(272), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_END_DATE", (Object)new Integer(273), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_MODULUS", (Object)new Integer(288), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_MODULUS_BITS", (Object)new Integer(289), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PUBLIC_EXPONENT", (Object)new Integer(290), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIVATE_EXPONENT", (Object)new Integer(291), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIME_1", (Object)new Integer(292), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIME_2", (Object)new Integer(293), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_EXPONENT_1", (Object)new Integer(294), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_EXPONENT_2", (Object)new Integer(295), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_COEFFICIENT", (Object)new Integer(296), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIME", (Object)new Integer(304), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SUBPRIME", (Object)new Integer(305), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_BASE", (Object)new Integer(306), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_PRIME_BITS", (Object)new Integer(307), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SUB_PRIME_BITS", (Object)new Integer(308), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_VALUE_BITS", (Object)new Integer(352), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_VALUE_LEN", (Object)new Integer(353), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_EXTRACTABLE", (Object)new Integer(354), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_LOCAL", (Object)new Integer(355), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_NEVER_EXTRACTABLE", (Object)new Integer(356), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ALWAYS_SENSITIVE", (Object)new Integer(357), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_KEY_GEN_MECHANISM", (Object)new Integer(358), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_MODIFIABLE", (Object)new Integer(368), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ECDSA_PARAMS", (Object)new Integer(384), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_EC_PARAMS", (Object)new Integer(384), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_EC_POINT", (Object)new Integer(385), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_SECONDARY_AUTH", (Object)new Integer(512), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_AUTH_PIN_FLAGS", (Object)new Integer(513), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_ALWAYS_AUTHENTICATE", (Object)new Integer(514), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKA_WRAP_WITH_TRUSTED", (Object)new Integer(528), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_RSA", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_ECDSA", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_EC", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_DES", (Object)new Integer(19), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_DES2", (Object)new Integer(20), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_DES3", (Object)new Integer(21), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKK_AES", (Object)new Integer(31), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKC_X_509", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKC_X_509_ATTR_CERT", (Object)new Integer(1), (int)0);
    }

    public static Scriptable jsFunction_getAttribute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsPKCS11Object o = (JsPKCS11Object)thisObj;
        int attr = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        byte[] attrValue = null;
        try {
            attrValue = o.p11object.getAttribute(attr);
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 18) {
                return null;
            }
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, e.getErrorCode(), e.getMessage());
        }
        return ByteString.newInstance(thisObj, attrValue);
    }

    public static double jsFunction_getNumberAttribute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsPKCS11Object o = (JsPKCS11Object)thisObj;
        int attr = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        double attrValue = 0.0;
        try {
            attrValue = o.p11object.getNumberAttribute(attr);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, e.getErrorCode(), e.getMessage());
        }
        return attrValue;
    }

    public static boolean jsFunction_getBooleanAttribute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsPKCS11Object o = (JsPKCS11Object)thisObj;
        int attr = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        boolean attrValue = false;
        try {
            attrValue = o.p11object.getBooleanAttribute(attr);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, e.getErrorCode(), e.getMessage());
        }
        return attrValue;
    }

    public static void jsFunction_destroy(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Object o = (JsPKCS11Object)thisObj;
        try {
            o.p11object.deleteObject();
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, e.getErrorCode(), e.getMessage());
        }
    }
}

