/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp.crypto;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAPrivateKeySpec;
import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.crypto.AbstractCrypto;
import de.cardcontact.scdp.gp.crypto.PasswordCallbackHandler;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import javax.crypto.Cipher;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.math.ec.ECCurve;

public class CryptoSmartCardHSM
extends AbstractCrypto {
    private SmartCardHSMProvider scHSM = null;

    public CryptoSmartCardHSM(String providerName) {
        int delim = providerName.indexOf(47);
        String reader = null;
        if (delim != -1) {
            reader = providerName.substring(delim + 1);
        }
        this.scHSM = (SmartCardHSMProvider)Security.getProvider(providerName);
        if (this.scHSM == null) {
            this.scHSM = reader != null ? new SmartCardHSMProvider(reader) : new SmartCardHSMProvider();
            Security.addProvider((Provider)this.scHSM);
        }
    }

    public void setPassword(String password) {
        PasswordCallbackHandler pch = new PasswordCallbackHandler(password);
        try {
            this.scHSM.login(null, (CallbackHandler)pch);
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
    }

    @Override
    public String getProviderName() {
        return this.scHSM.getName();
    }

    @Override
    public byte[] generateRandom(int randomLength) throws GPErrorException {
        byte[] random = new byte[randomLength];
        try {
            SecureRandom rng = SecureRandom.getInstance("NativePRNG", "SmartCardHSM");
            rng.nextBytes(random);
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, 0, e.getMessage());
        }
        return random;
    }

    @Override
    public void generateKeyPair(int mech, GPKey publicKey, GPKey privateKey) throws GPErrorException {
        try {
            SmartCardHSMRSAPrivateKeySpec spec;
            String algorithm;
            if (mech == 17 || mech == 18) {
                algorithm = "EC//ECDSA-SHA-1";
                org.bouncycastle.jce.spec.ECParameterSpec ecspec = publicKey.getECParameter();
                ECParameterSpec jcespec = EC5Util.convertSpec((EllipticCurve)EC5Util.convertCurve((ECCurve)ecspec.getCurve(), (byte[])ecspec.getSeed()), (org.bouncycastle.jce.spec.ECParameterSpec)ecspec);
                spec = new SmartCardHSMECPrivateKeySpec("UTNONE00000", "UTNONE00000", (AlgorithmParameterSpec)jcespec);
            } else if (mech == 14) {
                spec = new SmartCardHSMRSAPrivateKeySpec("UTNONE00000", "UTNONE00000", 65537, publicKey.getKeySize());
                algorithm = "RSA//PKCS1-v1-5-SHA-1";
            } else {
                Object keyGen = null;
                throw new GPErrorException(14, 0, "Mechanism must be either RSA or ECDSA");
            }
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm, this.getProviderName());
            String label = privateKey.getKeyId();
            if (label == null || label.length() == 0) {
                throw new GPErrorException(17, 0, "Private key object must define an identifier. Use Key.setID() to set one or define one in KeyInfo.ID element of key profile");
            }
            SmartCardHSMParameterSpec params = new SmartCardHSMParameterSpec(label, (SmartCardHSMKeySpec)spec, null);
            keyGen.initialize((AlgorithmParameterSpec)params);
            KeyPair pair = keyGen.generateKeyPair();
            privateKey.setKeySize(publicKey.getKeySize());
            publicKey.setJCEKey(pair.getPublic());
            privateKey.setJCEKey(pair.getPrivate());
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] decrypt(GPKey gpKey, int mech, byte[] cipherText, byte[] iv) throws GPErrorException {
        Key key = null;
        try {
            key = gpKey.getJCEKey(this.getProviderName());
            if (mech == 14) {
                if (!(key instanceof SmartCardHSMRSAKey)) {
                    throw new GPErrorException(12, 0, "Key must be type of SmartCardHSMRSAKey");
                }
                SmartCardHSMRSAKey rsaKey = (SmartCardHSMRSAKey)key;
                Cipher cipher = Cipher.getInstance("RSA", this.getProviderName());
                cipher.init(2, (Key)rsaKey);
                return cipher.doFinal(cipherText);
            }
            if (mech != 19) throw new GPErrorException(14, 0, "Mechanism must be either RSA or ECDH");
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
        throw new GPErrorException(14, 0, "Mechanism must be either RSA or ECDH");
    }
}

