/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.GPTLV_Generic;
import de.cardcontact.scdp.gp.TLVDataSizeException;
import de.cardcontact.scdp.gp.TagSizeException;

public class GPTLV_DGI
extends GPTLV_Generic {
    public GPTLV_DGI(int tag, byte[] data) throws TagSizeException, TLVDataSizeException {
        super(tag, data);
        if (tag < 0 || tag >= 65536) {
            throw new TagSizeException("Illegal tag size! DGI supports only one or two byte tags!");
        }
        if (this.getLengthFieldSizeHelper() == -1) {
            throw new TLVDataSizeException("Illegal data size! DGI supports only a one or three byte length!");
        }
    }

    @Override
    public int getLengthFieldSizeHelper() {
        int size = 1;
        if (this.data.length >= 255) {
            size = 3;
        }
        if (this.data.length > 65535) {
            return -1;
        }
        return size;
    }

    @Override
    public byte[] encodeLength() {
        int length = this.data.length;
        int size = this.getLengthFieldSizeHelper();
        byte[] encodedLength = new byte[size];
        if (size > 1) {
            encodedLength[0] = -1;
            encodedLength[1] = (byte)(length >> 8);
            encodedLength[2] = (byte)(length & 0xFF);
        } else {
            encodedLength[0] = (byte)length;
        }
        return encodedLength;
    }

    @Override
    public byte[] encodeTag() {
        byte[] t = new byte[]{(byte)(this.tag >> 8), (byte)(this.tag & 0xFF)};
        return t;
    }

    @Override
    public int getTagFieldSizeHelper() {
        return 2;
    }
}

