/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.BaseCommandProcessor;
import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

public class CommandProcessor
extends BaseCommandProcessor {
    @Override
    public void run() {
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)this.shell);
        try {
            SmartCard.start();
        }
        catch (OpenCardPropertyLoadingException e) {
            e.printStackTrace();
        }
        catch (CardServiceException e) {
            e.printStackTrace();
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SmartCardHSMProvider.removeProviders();
            try {
                SmartCard.shutdown();
                System.setProperty("OpenCard.loaderClassName", "");
            }
            catch (CardTerminalException e) {
                System.setProperty("OpenCard.loaderClassName", "");
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File userDir = new File(System.getProperty("user.dir"));
        File file = new File(userDir, "etc/log4j.properties");
        if (file.exists()) {
            PropertyConfigurator.configure((String)file.getAbsolutePath());
        } else {
            Logger.getRootLogger().setLevel(Level.OFF);
        }
        String exeDir = System.getProperty("scsh3.exepath");
        File sysDir = exeDir != null ? new File(exeDir) : userDir;
        FileResourceLocatorFS frl = new FileResourceLocatorFS(sysDir, userDir);
        Engine engine = new Engine();
        engine.setFileResourceLocator(frl);
        try {
            engine.executeSetupScript("config.js");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage(re, System.err);
            return;
        }
        engine.initializeModule();
        ScriptExecutor se = new ScriptExecutor();
        se.start();
        CommandProcessor cp = new CommandProcessor();
        cp.setInputStream(System.in);
        cp.setOutputStream(System.out);
        cp.setScriptExecutor(se);
        do {
            Shell shell = (Shell)engine.newDynamicScope("Shell");
            shell.setOutputStream(System.out);
            cp.setShellObject(shell);
            cp.run();
        } while (cp.getLifeCycle() == 2);
        se.shutdown();
    }
}

