/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cardsim.jcop;

import de.cardcontact.scdp.cardsim.jcop.JCOPSimulationProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JCOPSimulationProtocol {
    public static final byte MTY_WAIT_FOR_CARD = 0;
    public static final byte MTY_APDU_DATA = 1;
    public static final byte MTY_STATUS = 2;
    public static final byte MTY_ERROR_MESSAGE = 3;
    public static final byte MTY_TERMINAL_INFO = 4;
    public static final byte MTY_INIT_INFO = 5;
    public static final byte MTY_ECHO = 6;
    public static final byte MTY_DEBUG = 7;
    public static final byte NODE_TERMINAL = 33;
    public static final byte NODE_CARD = 0;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private byte messageType = (byte)-1;
    private byte node = (byte)-1;
    private byte[] message = null;

    public JCOPSimulationProtocol(InputStream in, OutputStream out) {
        this.inStream = in;
        this.outStream = out;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public byte getNode() {
        return this.node;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void send(byte mty, byte destNode, byte[] cmd) throws IOException {
        int length = cmd == null ? 0 : cmd.length;
        byte[] scr = new byte[4 + length];
        scr[0] = mty;
        scr[1] = destNode;
        scr[2] = (byte)(length / 256);
        scr[3] = (byte)length;
        if (cmd != null) {
            System.arraycopy(cmd, 0, scr, 4, length);
        }
        this.outStream.write(scr);
        this.outStream.flush();
    }

    public int readJcop() throws IOException, JCOPSimulationProtocolException {
        int len;
        int offset;
        int len2;
        byte[] tmp = new byte[4];
        for (offset = 0; offset < tmp.length; offset += len2) {
            len2 = this.inStream.read(tmp, offset, tmp.length - offset);
            if (len2 >= 0) continue;
            return -1;
        }
        this.messageType = tmp[0];
        this.node = tmp[1];
        int sizeRsp = (tmp[2] & 0xFF) << 8 | tmp[3] & 0xFF;
        this.message = new byte[sizeRsp];
        for (offset = 0; offset < this.message.length; offset += len) {
            len = this.inStream.read(this.message, offset, this.message.length - offset);
            if (len >= 0) continue;
            return -1;
        }
        return sizeRsp;
    }

    public String toString() {
        return "Last received message for node " + this.node + ", message type " + this.messageType + ", size " + this.message.length;
    }
}

