/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp.crypto;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.crypto.AbstractCrypto;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifierRegistry;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.mozilla.javascript.Scriptable;

public class CryptoBC
extends AbstractCrypto {
    private static final byte[] defaultICV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public String getProviderName() {
        return "BC";
    }

    @Override
    public byte[] encrypt(GPKey gpKey, int mech, byte[] plainText, byte[] iv) throws GPErrorException {
        if (iv == null) {
            iv = defaultICV;
        }
        byte[] cipherText = null;
        Cipher cipher = null;
        try {
            Key key = gpKey.getJCEKey(this.getProviderName());
            if (key instanceof SecretKey) {
                String algo = key.getAlgorithm();
                switch (mech) {
                    case 2: {
                        if (!algo.startsWith("DES")) {
                            throw new GPErrorException(14, mech, "Key does not match mechanism - not a DES key");
                        }
                        algo = algo.concat("/CBC/NoPadding");
                        break;
                    }
                    case 5: {
                        if (!algo.startsWith("DES")) {
                            throw new GPErrorException(14, mech, "Key does not match mechanism - not a DES key");
                        }
                        algo = algo.concat("/ECB/NoPadding");
                        iv = null;
                        break;
                    }
                    case 51: {
                        if (!algo.startsWith("AES")) {
                            throw new GPErrorException(14, mech, "Key does not match mechanism - not an AES key");
                        }
                        algo = algo.concat("/CBC/NoPadding");
                        break;
                    }
                    case 52: {
                        if (!algo.startsWith("AES")) {
                            throw new GPErrorException(14, mech, "Key does not match mechanism - not an AES key");
                        }
                        algo = algo.concat("/CTR/NoPadding");
                        break;
                    }
                    case 50: {
                        if (!algo.startsWith("AES")) {
                            throw new GPErrorException(14, mech, "Key does not match mechanism - not an AES key");
                        }
                        algo = algo.concat("/ECB/NoPadding");
                        iv = null;
                        break;
                    }
                    default: {
                        throw new GPErrorException(14, mech, "Specified mechanism not supported!");
                    }
                }
                cipher = Cipher.getInstance(algo, this.getProviderName());
                if (iv != null) {
                    IvParameterSpec dps = new IvParameterSpec(iv);
                    cipher.init(1, key, dps);
                } else {
                    cipher.init(1, key);
                }
                cipherText = cipher.doFinal(plainText);
            } else {
                int keylen;
                String algo = "RSA";
                switch (mech) {
                    case 14: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 38: {
                        algo = "RSA/NONE/OAEPWithSHA1AndMGF1Padding";
                        break;
                    }
                    case 39: {
                        algo = "RSA/NONE/OAEPWithSHA224AndMGF1Padding";
                        break;
                    }
                    case 40: {
                        algo = "RSA/NONE/OAEPWithSHA256AndMGF1Padding";
                        break;
                    }
                    case 41: {
                        algo = "RSA/NONE/OAEPWithSHA3841AndMGF1Padding";
                        break;
                    }
                    case 42: {
                        algo = "RSA/NONE/OAEPWithSHA512AndMGF1Padding";
                        break;
                    }
                    case 43: {
                        algo = "RSA/NONE/PKCS1Padding";
                        break;
                    }
                    default: {
                        throw new GPErrorException(14, mech, "Specified mechanism not supported!");
                    }
                }
                RSAKey rsaKey = (RSAKey)((Object)key);
                if (mech == 15 && (plainText[plainText.length - 1] & 0xF) != 12) {
                    throw new GPErrorException(9, 0, "The input block for RSA_ISO9796_2 must end with 'xC'");
                }
                cipher = Cipher.getInstance(algo, this.getProviderName());
                cipher.init(1, key);
                cipher.update(plainText);
                cipherText = cipher.doFinal();
                if (mech == 15) {
                    BigInteger z = new BigInteger(1, cipherText);
                    BigInteger n = rsaKey.getModulus();
                    if (z.compareTo(n.shiftRight(1)) > 0) {
                        z = n.subtract(z);
                        cipherText = GPKey.unsignedBigIntegerToByteArray(z, z.bitLength());
                    }
                } else if (mech == 14 && cipherText.length < (keylen = gpKey.getKeySize() >> 3)) {
                    byte[] copybuff = new byte[keylen];
                    System.arraycopy(cipherText, 0, copybuff, keylen - cipherText.length, cipherText.length);
                    cipherText = copybuff;
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
        return cipherText;
    }

    @Override
    public byte[] decrypt(GPKey gpKey, int mech, byte[] cipherText, byte[] iv) throws GPErrorException {
        byte[] plainText;
        block37: {
            if (iv == null) {
                iv = defaultICV;
            }
            plainText = null;
            Cipher cipher = null;
            try {
                Key key = gpKey.getJCEKey(this.getProviderName());
                if (key instanceof SecretKey) {
                    String algo = key.getAlgorithm();
                    switch (mech) {
                        case 2: {
                            if (!algo.startsWith("DES")) {
                                throw new GPErrorException(14, 14, "Key does not match mechanism - not a DES key");
                            }
                            algo = algo.concat("/CBC/NoPadding");
                            break;
                        }
                        case 5: {
                            if (!algo.startsWith("DES")) {
                                throw new GPErrorException(14, 14, "Key does not match mechanism - not a DES key");
                            }
                            algo = algo.concat("/ECB/NoPadding");
                            iv = null;
                            break;
                        }
                        case 51: {
                            if (!algo.startsWith("AES")) {
                                throw new GPErrorException(14, 14, "Key does not match mechanism - not an AES key");
                            }
                            algo = algo.concat("/CBC/NoPadding");
                            break;
                        }
                        case 52: {
                            if (!algo.startsWith("AES")) {
                                throw new GPErrorException(14, 14, "Key does not match mechanism - not an AES key");
                            }
                            algo = algo.concat("/CTR/NoPadding");
                            break;
                        }
                        case 50: {
                            if (!algo.startsWith("AES")) {
                                throw new GPErrorException(14, 14, "Key does not match mechanism - not an AES key");
                            }
                            algo = algo.concat("/ECB/NoPadding");
                            iv = null;
                            break;
                        }
                        default: {
                            throw new GPErrorException(14, 14, "Specified mechanism not supported!");
                        }
                    }
                    cipher = Cipher.getInstance(algo, this.getProviderName());
                    if (iv != null) {
                        IvParameterSpec dps = new IvParameterSpec(iv);
                        cipher.init(2, key, dps);
                    } else {
                        cipher.init(2, key);
                    }
                    plainText = cipher.doFinal(cipherText);
                    break block37;
                }
                switch (mech) {
                    case 14: 
                    case 15: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: {
                        int keylen;
                        String algo = "RSA";
                        switch (mech) {
                            case 43: {
                                algo = "RSA/NONE/PKCS1Padding";
                                break;
                            }
                            case 38: {
                                algo = "RSA/NONE/OAEPWithSHA1AndMGF1Padding";
                                break;
                            }
                            case 39: {
                                algo = "RSA/NONE/OAEPWithSHA224AndMGF1Padding";
                                break;
                            }
                            case 40: {
                                algo = "RSA/NONE/OAEPWithSHA256AndMGF1Padding";
                                break;
                            }
                            case 41: {
                                algo = "RSA/NONE/OAEPWithSHA3841AndMGF1Padding";
                                break;
                            }
                            case 42: {
                                algo = "RSA/NONE/OAEPWithSHA512AndMGF1Padding";
                            }
                        }
                        cipher = Cipher.getInstance(algo, this.getProviderName());
                        cipher.init(2, key);
                        cipher.update(cipherText);
                        plainText = cipher.doFinal();
                        if (mech == 15 && (plainText[plainText.length - 1] & 0xF) != 12) {
                            RSAKey rsaKey = (RSAKey)((Object)key);
                            BigInteger z = new BigInteger(1, plainText);
                            z = rsaKey.getModulus().subtract(z);
                            plainText = GPKey.unsignedBigIntegerToByteArray(z, z.bitLength());
                        }
                        if (mech == 14 && plainText.length < (keylen = gpKey.getKeySize() >> 3)) {
                            byte[] copybuff = new byte[keylen];
                            System.arraycopy(plainText, 0, copybuff, keylen - plainText.length, plainText.length);
                            plainText = copybuff;
                        }
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        if (!(key instanceof ECPrivateKey)) {
                            throw new GPErrorException(12, 0, "The key must be an EC private key");
                        }
                        ECPrivateKey eckey = (ECPrivateKey)key;
                        int len = cipherText.length;
                        if ((len & 1) == 1) {
                            throw new GPErrorException(9, 0, "The number of bytes in the cipher input must be even (x || y)");
                        }
                        byte[] t = new byte[len >>= 1];
                        System.arraycopy(cipherText, 0, t, 0, len);
                        BigInteger qxi = new BigInteger(1, t);
                        System.arraycopy(cipherText, len, t, 0, len);
                        BigInteger qyi = new BigInteger(1, t);
                        ECParameterSpec ecParameterSpec = eckey.getParameters();
                        ECCurve curve = ecParameterSpec.getCurve();
                        ECPoint.Fp q = new ECPoint.Fp(curve, curve.fromBigInteger(qxi), curve.fromBigInteger(qyi), false);
                        if (mech != 21) {
                            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec((ECPoint)q, ecParameterSpec);
                            PublicKey otherKey = KeyFactory.getInstance("EC", this.getProviderName()).generatePublic((KeySpec)ecPublicKeySpec);
                            KeyAgreement ka = KeyAgreement.getInstance(mech == 19 ? "ECDH" : "ECDHC", this.getProviderName());
                            ka.init((Key)eckey);
                            ka.doPhase(otherKey, true);
                            plainText = ka.generateSecret();
                            break;
                        }
                        ECPoint p = q.multiply(eckey.getD());
                        p = p.normalize();
                        byte[] px = GPKey.unsignedBigIntegerToByteArray(p.getAffineXCoord().toBigInteger(), gpKey.getKeySize());
                        byte[] py = GPKey.unsignedBigIntegerToByteArray(p.getAffineYCoord().toBigInteger(), gpKey.getKeySize());
                        plainText = new byte[px.length + px.length];
                        System.arraycopy(px, 0, plainText, 0, px.length);
                        System.arraycopy(py, 0, plainText, px.length, py.length);
                        break;
                    }
                    case 60: {
                        TLV tlv = TLV.factory((byte[])cipherText);
                        ConstructedTLV seq = (ConstructedTLV)tlv.getChildAt(0);
                        ECPoint b = this.getPointFromPubKeySeq(seq);
                        ECPoint c = this.getPointFromPubKeySeq((ConstructedTLV)tlv.getChildAt(1));
                        ECPrivateKey eckey = (ECPrivateKey)key;
                        BigInteger privateKey = eckey.getD();
                        ECPoint plain = c.subtract(b.multiply(privateKey));
                        plain = plain.normalize();
                        byte[] px = GPKey.unsignedBigIntegerToByteArray(plain.getAffineXCoord().toBigInteger(), gpKey.getKeySize());
                        byte[] py = GPKey.unsignedBigIntegerToByteArray(plain.getAffineYCoord().toBigInteger(), gpKey.getKeySize());
                        byte[] enc = new byte[px.length * 2 + 1];
                        enc[0] = 4;
                        System.arraycopy(px, 0, enc, 1, px.length);
                        System.arraycopy(py, 0, enc, 1 + px.length, py.length);
                        ConstructedTLV pubKeySeq = new ConstructedTLV(new Tag(32585));
                        TLV oid = seq.findTag(new Tag(6), null);
                        pubKeySeq.add((TLV)new PrimitiveTLV(6, oid.getBytes()));
                        pubKeySeq.add((TLV)new PrimitiveTLV(new Tag(134), enc));
                        ConstructedTLV sequence = new ConstructedTLV(48);
                        sequence.add((TLV)pubKeySeq);
                        plainText = sequence.getBytes();
                        break;
                    }
                    default: {
                        throw new GPErrorException(14, 14, "Specified mechanism not supported!");
                    }
                }
            }
            catch (GeneralSecurityException e) {
                throw new GPErrorException(5, mech, e.getMessage());
            }
            catch (TLVEncodingException e) {
                throw new GPErrorException(5, mech, e.getMessage());
            }
        }
        return plainText;
    }

    private ECPoint getPointFromPubKeySeq(ConstructedTLV seq) throws TLVEncodingException {
        TLV tlv = seq.findTag(new Tag(6), null);
        ObjectIdentifierRegistry reg = ObjectIdentifierRegistry.getInstance();
        String name = reg.getNameFor(tlv.getValue());
        ECNamedCurveParameterSpec curveSpec = ECNamedCurveTable.getParameterSpec((String)name);
        tlv = seq.findTag(new Tag(134), null);
        ECPoint point = curveSpec.getCurve().decodePoint(tlv.getValue());
        return point;
    }

    private byte[] calculateMac(Key key, int mech, byte[] data, byte[] iv) throws GPErrorException, GeneralSecurityException {
        Mac mac = null;
        switch (mech) {
            case 8: 
            case 53: {
                return CryptoBC.cbcMac(key, data, iv, this.getProviderName());
            }
            case 9: {
                if (iv != null) {
                    throw new GPErrorException(14, mech, "IV not supported for DES_MAC_EMV");
                }
                mac = Mac.getInstance("ISO9797ALG3Mac", this.getProviderName());
                break;
            }
            case 54: {
                if (iv != null) {
                    throw new GPErrorException(14, mech, "IV not supported for AES_CMAC");
                }
                mac = Mac.getInstance("AESCMAC", this.getProviderName());
            }
        }
        mac.init(key);
        byte[] m = mac.doFinal(data);
        return m;
    }

    private static byte[] retailMac(Key key, byte[] data, byte[] iv, String providerName) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("ISO9797ALG3Mac", providerName);
        mac.init(key);
        byte[] m = mac.doFinal(data);
        return m;
    }

    private static byte[] cbcMac(Key key, byte[] data, byte[] iv, String providerName) throws GeneralSecurityException {
        IvParameterSpec params;
        Cipher cipher = Cipher.getInstance(key.getAlgorithm() + "/CBC/NoPadding", providerName);
        int blocksize = cipher.getBlockSize();
        if (iv != null) {
            params = new IvParameterSpec(iv);
        } else {
            byte[] nullIV = new byte[blocksize];
            params = new IvParameterSpec(nullIV);
        }
        cipher.init(1, key, params);
        byte[] temp = cipher.doFinal(data);
        byte[] signature = new byte[blocksize];
        System.arraycopy(temp, temp.length - blocksize, signature, 0, signature.length);
        return signature;
    }

    private byte[] calculateHMac(byte[] key, int mech, byte[] data) throws GPErrorException, GeneralSecurityException {
        String algo = CryptoBC.getAlgorithmName(mech);
        SecretKeySpec jcekey = new SecretKeySpec(key, algo);
        Mac mac = Mac.getInstance(CryptoBC.getAlgorithmName(mech), this.getProviderName());
        mac.init(jcekey);
        byte[] m = mac.doFinal(data);
        return m;
    }

    private static String getAlgorithmName(int mech) {
        String algName = null;
        switch (mech) {
            case 18: {
                algName = "NONEwithECDSA";
                break;
            }
            case 28: {
                algName = "SHA1withECDSA";
                break;
            }
            case 29: {
                algName = "SHA224withECDSA";
                break;
            }
            case 30: {
                algName = "SHA256withECDSA";
                break;
            }
            case 31: {
                algName = "SHA384withECDSA";
                break;
            }
            case 32: {
                algName = "SHA512withECDSA";
                break;
            }
            case 14: 
            case 33: {
                algName = "SHA1withRSA";
                break;
            }
            case 34: {
                algName = "SHA224withRSA";
                break;
            }
            case 35: {
                algName = "SHA256withRSA";
                break;
            }
            case 36: {
                algName = "SHA384withRSA";
                break;
            }
            case 37: {
                algName = "SHA512withRSA";
                break;
            }
            case 45: {
                algName = "SHA1withRSAandMGF1";
                break;
            }
            case 46: {
                algName = "SHA224withRSAandMGF1";
                break;
            }
            case 47: {
                algName = "SHA256withRSAandMGF1";
                break;
            }
            case 48: {
                algName = "SHA384withRSAandMGF1";
                break;
            }
            case 49: {
                algName = "SHA512withRSAandMGF1";
                break;
            }
            case 55: {
                algName = "HmacSHA1";
                break;
            }
            case 56: {
                algName = "HmacSHA256";
                break;
            }
            case 61: {
                algName = "HmacSHA384";
                break;
            }
            case 57: {
                algName = "HmacMD5";
            }
        }
        return algName;
    }

    @Override
    public byte[] sign(GPKey gpKey, int mech, byte[] data, byte[] iv) throws GPErrorException {
        byte[] signature = null;
        Signature sigAlg = null;
        switch (mech) {
            case 8: 
            case 9: 
            case 53: 
            case 54: {
                try {
                    signature = this.calculateMac(gpKey.getJCEKey(this.getProviderName()), mech, data, iv);
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new GPErrorException(5, mech, e.getMessage());
                }
            }
            case 55: 
            case 56: 
            case 57: 
            case 61: {
                ByteString bs = gpKey.getComponent(25);
                if (bs == null) {
                    throw new GPErrorException(12, mech, "Key must be generic secret");
                }
                try {
                    signature = this.calculateHMac(bs.getBytes(), mech, data);
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new GPErrorException(5, mech, e.getMessage());
                }
            }
            default: {
                if (iv != null) {
                    throw new GPErrorException(14, mech, "IV not supported for selected mechanism");
                }
                String algName = CryptoBC.getAlgorithmName(mech);
                if (algName == null) {
                    throw new GPErrorException(14, mech, "Specified mechanism not supported");
                }
                try {
                    PrivateKey pkey = (PrivateKey)gpKey.getJCEKey(this.getProviderName());
                    sigAlg = Signature.getInstance(algName, this.getProviderName());
                    sigAlg.initSign(pkey);
                    sigAlg.update(data);
                    signature = sigAlg.sign();
                    break;
                }
                catch (Exception e) {
                    Throwable ce = e.getCause();
                    e.printStackTrace();
                    if (ce != null) {
                        throw new GPErrorException(5, mech, ce.getMessage());
                    }
                    throw new GPErrorException(5, mech, e.getMessage());
                }
            }
        }
        return signature;
    }

    @Override
    public boolean verify(GPKey gpKey, int mech, byte[] data, byte[] signature, byte[] iv) throws GPErrorException {
        byte[] calcSig = null;
        Signature sigAlg = null;
        switch (mech) {
            case 8: 
            case 9: 
            case 53: 
            case 54: {
                try {
                    calcSig = this.calculateMac(gpKey.getJCEKey(this.getProviderName()), mech, data, iv);
                }
                catch (GeneralSecurityException e) {
                    throw new GPErrorException(5, mech, e.getMessage());
                }
                for (int i = 0; i < signature.length; ++i) {
                    if (signature[i] == calcSig[i]) continue;
                    return false;
                }
                break;
            }
            default: {
                if (iv != null) {
                    throw new GPErrorException(14, mech, "IV not supported for selected mechanism");
                }
                String algName = CryptoBC.getAlgorithmName(mech);
                if (algName == null) {
                    throw new GPErrorException(14, mech, "Specified mechanism not supported");
                }
                try {
                    PublicKey pkey = (PublicKey)gpKey.getJCEKey(this.getProviderName());
                    sigAlg = Signature.getInstance(algName, this.getProviderName());
                    sigAlg.initVerify(pkey);
                    sigAlg.update(data);
                    if (!sigAlg.verify(signature)) {
                        return false;
                    }
                    break;
                }
                catch (Exception e) {
                    Throwable ce = e.getCause();
                    if (ce != null) {
                        throw new GPErrorException(5, mech, ce.getMessage());
                    }
                    throw new GPErrorException(5, mech, e.getMessage());
                }
            }
        }
        return true;
    }

    private static void adjustParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int akku = key[i] & 0xFF | 1;
            for (int c = 7; c > 0; --c) {
                akku = akku & 1 ^ akku >> 1;
            }
            key[i] = (byte)(key[i] & 0xFE | akku);
        }
    }

    private void deriveDESKey(GPKey masterKey, int mech, byte[] data, GPKey derivedKey) throws GeneralSecurityException, GPErrorException {
        Cipher cipher = null;
        if (data.length != 8 && data.length != 16 && data.length != 24) {
            throw new GPErrorException(8, data.length, "Size of data parameter must be 8, 16 or 24!");
        }
        String DESType = masterKey.getJCEKey(this.getProviderName()).getEncoded().length == 8 ? "DES" : "DESede";
        switch (mech) {
            case 5: {
                cipher = Cipher.getInstance(DESType + "/ECB/NoPadding", this.getProviderName());
                cipher.init(1, masterKey.getJCEKey(this.getProviderName()));
                break;
            }
            case 2: {
                cipher = Cipher.getInstance(DESType + "/CBC/NoPadding", this.getProviderName());
                IvParameterSpec dps = new IvParameterSpec(defaultICV);
                cipher.init(1, masterKey.getJCEKey(this.getProviderName()), dps);
                break;
            }
            default: {
                throw new GPErrorException(14, mech, "Specified mechanism not supported!");
            }
        }
        byte[] result = cipher.doFinal(data);
        CryptoBC.adjustParity(result);
        derivedKey.put(1, (Scriptable)derivedKey, (Object)ByteString.newInstance((Scriptable)derivedKey, result));
        derivedKey.setKeyType(1);
        derivedKey.setJCEKey(null);
    }

    private void deriveECCKey(GPKey masterKey, int mech, byte[] data, GPKey derivedKey) throws GeneralSecurityException, GPErrorException {
        switch (mech) {
            case 22: {
                ECPoint r;
                Key key = masterKey.getJCEKey(this.getProviderName());
                if (!(key instanceof ECPublicKey)) {
                    throw new GPErrorException(12, 0, "The key must be an EC public key");
                }
                ECPublicKey mkey = (ECPublicKey)key;
                boolean hasPublicKey = derivedKey.getComponent(17) != null;
                ECPublicKey dkey = null;
                if (hasPublicKey) {
                    key = derivedKey.getJCEKey(this.getProviderName());
                    if (!(key instanceof ECPublicKey)) {
                        throw new GPErrorException(12, 4, "The key must be an EC public key");
                    }
                    dkey = (ECPublicKey)key;
                }
                if (data != null) {
                    BigInteger s = new BigInteger(1, data);
                    r = mkey.getQ().multiply(s);
                    if (dkey != null) {
                        r = r.add(dkey.getQ());
                    }
                } else {
                    if (dkey == null) {
                        throw new GPErrorException(12, 4, "The key must be an EC public key");
                    }
                    r = mkey.getQ().add(dkey.getQ());
                }
                ECParameterSpec ecParameterSpec = derivedKey.getECParameter();
                ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(r, ecParameterSpec);
                PublicKey jceKey = KeyFactory.getInstance("EC", this.getProviderName()).generatePublic((KeySpec)ecPublicKeySpec);
                derivedKey.setJCEKey(jceKey);
                break;
            }
            default: {
                throw new GPErrorException(14, 14, "Specified mechanism not supported!");
            }
        }
    }

    @Override
    public void deriveKey(GPKey masterKey, int mech, byte[] data, GPKey derivedKey) throws GPErrorException {
        try {
            switch (mech) {
                case 2: 
                case 5: {
                    this.deriveDESKey(masterKey, mech, data, derivedKey);
                    break;
                }
                case 22: {
                    this.deriveECCKey(masterKey, mech, data, derivedKey);
                    break;
                }
                default: {
                    throw new GPErrorException(14, 14, "Specified mechanism not supported!");
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
    }

    @Override
    public byte[] generateRandom(int randomLength) throws GPErrorException {
        SecureRandom sr = new SecureRandom();
        byte[] random = new byte[randomLength];
        sr.nextBytes(random);
        return random;
    }

    @Override
    public void generateKeyPair(int mech, GPKey publicKey, GPKey privateKey) throws GPErrorException {
        try {
            KeyPairGenerator keyGen;
            if (mech == 17 || mech == 18) {
                keyGen = KeyPairGenerator.getInstance("EC", this.getProviderName());
                keyGen.initialize((AlgorithmParameterSpec)publicKey.getECParameter());
            } else if (mech == 14) {
                keyGen = KeyPairGenerator.getInstance("RSA", this.getProviderName());
                keyGen.initialize(publicKey.getKeySize());
            } else {
                Object keyGen2 = null;
                throw new GPErrorException(14, 0, "Mechanism must be either RSA or ECDSA");
            }
            KeyPair pair = keyGen.generateKeyPair();
            privateKey.setKeySize(publicKey.getKeySize());
            publicKey.setJCEKey(pair.getPublic());
            privateKey.setJCEKey(pair.getPrivate());
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
    }

    @Override
    public byte[] digest(int mech, byte[] data) throws GPErrorException {
        MessageDigest md = null;
        try {
            switch (mech) {
                case 16: {
                    md = MessageDigest.getInstance("SHA1", this.getProviderName());
                    break;
                }
                case 13: {
                    md = MessageDigest.getInstance("MD5", this.getProviderName());
                    break;
                }
                case 24: {
                    md = MessageDigest.getInstance("SHA224", this.getProviderName());
                    break;
                }
                case 25: {
                    md = MessageDigest.getInstance("SHA256", this.getProviderName());
                    break;
                }
                case 26: {
                    md = MessageDigest.getInstance("SHA384", this.getProviderName());
                    break;
                }
                case 27: {
                    md = MessageDigest.getInstance("SHA512", this.getProviderName());
                    break;
                }
                default: {
                    throw new GPErrorException(14, 0, "Specified mechanism not supported!");
                }
            }
            md.update(data);
            byte[] digest = md.digest();
            return digest;
        }
        catch (GeneralSecurityException e) {
            throw new GPErrorException(5, mech, e.getMessage());
        }
    }
}

