/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cryptoscript;

import de.cardcontact.scdp.cryptoscript.CryptoInterface;
import de.cardcontact.scdp.cryptoscript.ScriptInterpreter;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCryptoScript
extends ScriptableObject
implements CryptoInterface {
    private static final long serialVersionUID = -5888007913068118635L;
    public static final String clazzName = "CryptoScript";
    private ScriptInterpreter si;
    private byte[] stack;
    private GPKey key;
    private ByteArrayOutputStream codestream = null;

    public JsCryptoScript() {
    }

    private JsCryptoScript(GPKey key, int stacksize) {
        this.key = key;
        this.stack = new byte[stacksize];
        this.si = new ScriptInterpreter(this, this.stack, 0);
    }

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CryptoScriptInterpreter() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, 0, "Argument must be of type Key");
        }
        int stacksize = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, 1);
        return new JsCryptoScript((GPKey)((Object)args[0]), stacksize);
    }

    public ScriptInterpreter jsGet_scriptInterpreter() {
        return this.si;
    }

    public static Scriptable jsFunction_getStack(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        short top = csi.si.getStackPointer();
        int cnt = 0;
        while (top > 0) {
            top = csi.si.getOperandOffset(top);
            ++cnt;
        }
        Object[] elems = new Object[cnt];
        top = csi.si.getStackPointer();
        cnt = 0;
        while (top > 0) {
            short len = csi.si.getOperandLength(top);
            top = csi.si.getOperandOffset(top);
            elems[cnt] = ByteString.newInstance(thisObj, Arrays.copyOfRange(csi.stack, (int)top, top + len));
            ++cnt;
        }
        return cx.newArray(thisObj, elems);
    }

    public static void jsFunction_record(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.codestream = new ByteArrayOutputStream();
    }

    public static ByteString jsFunction_collect(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        if (csi.codestream == null) {
            GPError.throwAsGPErrorEx(thisObj, 17, 0, "Must call record() first");
        }
        byte[] bs = csi.codestream.toByteArray();
        csi.codestream = null;
        return ByteString.newInstance(thisObj, bs);
    }

    private void addCode(byte opcode, byte[] argument, boolean fixedlength) throws IOException {
        if (this.codestream != null) {
            this.codestream.write(opcode);
            if (argument != null) {
                if (argument.length > 255) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Argument length must not exceed 255");
                }
                if (!fixedlength) {
                    this.codestream.write((byte)argument.length);
                }
                this.codestream.write(argument);
            }
        }
    }

    private void addCode(byte opcode) throws IOException {
        this.addCode(opcode, null, false);
    }

    public static void jsFunction_eval(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        ByteString code = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        try {
            csi.si.eval((byte)0, code.getBytes());
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
    }

    public static boolean jsFunction_isEmpty(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        return csi.si.isempty();
    }

    public static ByteString jsFunction_top(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        byte[] bs = null;
        try {
            short ofs = csi.si.getOperandOffset();
            short len = csi.si.getOperandLength();
            bs = Arrays.copyOfRange(csi.stack, (int)ofs, ofs + len);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
        return ByteString.newInstance(thisObj, bs);
    }

    public static void jsFunction_push(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        try {
            csi.addCode((byte)-16, bs.getBytes(), false);
            csi.si.push(bs.getBytes());
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
    }

    public static ByteString jsFunction_pop(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        byte[] bs = null;
        try {
            short ofs = csi.si.getOperandOffset();
            short len = csi.si.getOperandLength();
            csi.addCode((byte)-15);
            csi.si.pop();
            bs = Arrays.copyOfRange(csi.stack, (int)ofs, ofs + len);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
        return ByteString.newInstance(thisObj, bs);
    }

    private void opNoArg(byte opcode) {
        try {
            this.addCode(opcode);
            switch (opcode) {
                case -14: {
                    this.si.swap();
                    break;
                }
                case -13: {
                    this.si.dup();
                    break;
                }
                case -12: {
                    this.si.concat();
                    break;
                }
                case -10: {
                    this.si.xor();
                    break;
                }
                case 1: 
                case 3: {
                    this.si.digest(opcode);
                }
            }
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, e.getMessage());
        }
    }

    public static void jsFunction_swap(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)-14);
    }

    public static void jsFunction_dup(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)-13);
    }

    public static void jsFunction_concat(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)-12);
    }

    public static void jsFunction_range(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int from = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int len = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        if (from > Short.MAX_VALUE || from < Short.MIN_VALUE) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Argument 'from' must be between -32768 and 32767");
        }
        if (len < 0 || len > Short.MAX_VALUE) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Argument 'len' must be between 0 and 32767");
        }
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        try {
            byte[] value = new byte[]{(byte)(from >> 8), (byte)(from & 0xFF), (byte)(len >> 8), (byte)(len & 0xFF)};
            csi.addCode((byte)-11, value, true);
            csi.si.range((short)from, (short)len);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getMessage());
        }
    }

    public static void jsFunction_xor(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)-10);
    }

    public static void jsFunction_sha1(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)1);
    }

    public static void jsFunction_sha256(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCryptoScript csi = (JsCryptoScript)thisObj;
        csi.opNoArg((byte)3);
    }

    @Override
    public short sign(byte keyid, byte algid, short recvlen, short lc) {
        return 0;
    }

    @Override
    public short decipher(byte keyid, byte algid, short lc, byte[] buf, short cdataOffset, short le) {
        return 0;
    }

    @Override
    public short performECDH(byte keyid, byte[] inbuf, short inoffset, short inlen, byte[] outbuf, short outoffset) {
        return 0;
    }

    @Override
    public short digest(byte type, byte[] inbuf, short inoffset, short inlen, byte[] outbuf, short outoffset) {
        int len;
        MessageDigest md = null;
        try {
            switch (type) {
                case 1: {
                    md = MessageDigest.getInstance("SHA1", "BC");
                    break;
                }
                case 3: {
                    md = MessageDigest.getInstance("SHA256", "BC");
                }
            }
            md.update(inbuf, inoffset, inlen);
            len = md.digest(outbuf, outoffset, outbuf.length - outoffset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (short)len;
    }

    @Override
    public short encipher(byte keyid, byte algid, byte[] buf, short offset, short len) {
        return 0;
    }

    @Override
    public short calcMAC(byte keyid, byte algid, byte[] buff, short offset, short len) {
        return 0;
    }
}

