/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceLocator;
import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import de.cardcontact.scdp.engine.GPTracerSLFAdapter;
import de.cardcontact.scdp.engine.Shell;
import java.io.File;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptRunner {
    private Engine engine;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public void log(String msg, Throwable t) {
        this.out.println(msg);
        t.printStackTrace(this.out);
    }

    public void initialiseOCF() {
        try {
            SmartCard.start();
        }
        catch (OpenCardPropertyLoadingException e) {
            this.log("Exception loading OpenCard properties", e);
        }
        catch (CardServiceException e) {
            this.log("Exception starting card service", e);
        }
        catch (CardTerminalException e) {
            this.log("Exception starting terminal service", e);
        }
        catch (ClassNotFoundException e) {
            this.log("OCF not configured", e);
        }
    }

    public void initializeLog4J(FileResourceLocator frl) {
        String fname = frl.mapFilename("etc/log4j.properties", 6);
        if (fname != null) {
            PropertyConfigurator.configure((String)fname);
        } else {
            Logger.getRootLogger().setLevel(Level.OFF);
        }
    }

    public void initialiseScriptingFramework() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File sysDir = new File(System.getProperty("user.dir"));
        String wsDir = System.getProperty("scdp.workspace");
        File userDir = wsDir != null ? new File(wsDir) : sysDir;
        FileResourceLocatorFS frl = new FileResourceLocatorFS(sysDir, userDir);
        this.initializeLog4J(frl);
        this.engine = new Engine();
        this.engine.setFileResourceLocator(frl);
        this.engine.setTracePrintStream(this.out);
        this.engine.setTracer(new GPTracerSLFAdapter(16384));
        try {
            this.engine.executeSetupScript("config.js");
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage(re, this.err);
            return;
        }
        catch (Exception e) {
            this.log("Error executing configuration script", e);
            return;
        }
    }

    public void shutdownOCF() {
        try {
            SmartCard.shutdown();
        }
        catch (CardTerminalException e) {
            this.log("Error stopping OCF", e);
        }
        finally {
            System.setProperty("OpenCard.loaderClassName", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runScript(String script) {
        boolean ok = true;
        Shell shell = (Shell)this.engine.newDynamicScope("Shell");
        shell.setOutputStream(this.out);
        this.engine.initializeModule((ScriptableObject)shell);
        Context cx = Context.enter();
        try {
            this.engine.executeScript(cx, (Scriptable)shell, script);
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage(re, this.err);
            ok = false;
        }
        catch (Exception e) {
            this.log("Exception executing " + script, e);
            ok = false;
        }
        finally {
            Context.exit();
        }
        return ok;
    }

    public static void main(String[] args) {
        int rc = 0;
        ScriptRunner scr = new ScriptRunner();
        scr.initialiseScriptingFramework();
        scr.initialiseOCF();
        for (String a : args) {
            if (scr.runScript(a)) continue;
            rc = 1;
            break;
        }
        scr.shutdownOCF();
        System.exit(rc);
    }
}

