/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.ExecuteRequest;
import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.engine.VersionInfo;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class CommandProcessor
extends Thread
implements ScriptCompletionListener {
    PrintStream ostream = null;
    PrintStream estream = null;
    InputStream istream = null;
    private static final long serialVersionUID = -366457048667206297L;
    private String prompt = ">";
    public static final int RUNNING = 0;
    public static final int QUIT = 1;
    public static final int RESTART = 2;
    private int lifeCycle = 0;
    private ScriptExecutor se;
    private Shell shell;

    public CommandProcessor() {
        this.setName("CommandProcessor");
    }

    public void setInputStream(InputStream in) {
        this.istream = in;
    }

    public void setOutputStream(PrintStream out) {
        this.ostream = out;
        this.estream = out;
    }

    public void setErrorOutputStream(PrintStream eout) {
        this.estream = eout;
    }

    public void setScriptExecutor(ScriptExecutor se) {
        this.se = se;
    }

    public void setShellObject(Shell s) {
        this.shell = s;
    }

    public int getLifeCycle() {
        return this.lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process() throws IOException, InterruptedException {
        Context cx = Context.enter();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.istream));
        this.ostream.print(VersionInfo.getBanner());
        this.ostream.print(this.prompt);
        this.ostream.flush();
        this.lifeCycle = 0;
        try {
            do {
                String command = "";
                try {
                    do {
                        String line = null;
                        try {
                            line = in.readLine();
                        }
                        catch (IOException e) {
                            this.lifeCycle = 1;
                        }
                        if (line == null) {
                            this.lifeCycle = 1;
                            continue;
                        }
                        command = command + line + "\n";
                    } while (this.lifeCycle != 1 && !cx.stringIsCompilableUnit(command));
                    this.ostream.flush();
                    if (command.equalsIgnoreCase("quit\n") || command.equalsIgnoreCase("q\n")) {
                        this.lifeCycle = 1;
                        continue;
                    }
                    if (command.equalsIgnoreCase("restart\n")) {
                        this.lifeCycle = 2;
                        continue;
                    }
                    if (command.equals(".\n")) {
                        this.se.abort();
                        this.ostream.print("[Abort]" + this.prompt);
                        this.ostream.flush();
                        continue;
                    }
                    if (this.lifeCycle != 0) continue;
                    Script s = cx.compileString(command, "shell", 0, null);
                    this.se.addRequest(new ExecuteRequest(this.shell, s, null, this));
                }
                catch (RhinoException e) {
                    Engine.printRhinoExceptionMessage(e, this.estream);
                    this.ostream.print(this.prompt);
                    this.ostream.flush();
                }
            } while (this.lifeCycle == 0);
        }
        finally {
            Context.exit();
            this.ostream.println("Shell closed.");
            this.ostream.flush();
        }
        return this.lifeCycle;
    }

    @Override
    public void scriptCompleted(Object result) {
        if (result instanceof RhinoException) {
            Engine.printRhinoExceptionMessage((RhinoException)((Object)result), this.estream);
        } else if (result != Context.getUndefinedValue()) {
            this.shell.put("lastresult", (Scriptable)this.shell, result);
            this.ostream.println(Context.toString((Object)result));
        }
        this.ostream.print(this.prompt);
        this.ostream.flush();
    }

    @Override
    public void run() {
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)this.shell);
        try {
            SmartCard.start();
        }
        catch (OpenCardPropertyLoadingException e) {
            e.printStackTrace();
        }
        catch (CardServiceException e) {
            e.printStackTrace();
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.lifeCycle = 0;
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SmartCardHSMProvider.removeProviders();
            try {
                SmartCard.shutdown();
                System.setProperty("OpenCard.loaderClassName", "");
            }
            catch (CardTerminalException e) {
                System.setProperty("OpenCard.loaderClassName", "");
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File userDir = new File(System.getProperty("user.dir"));
        File file = new File(userDir, "etc/log4j.properties");
        if (file.exists()) {
            PropertyConfigurator.configure((String)file.getAbsolutePath());
        } else {
            Logger.getRootLogger().setLevel(Level.OFF);
        }
        String exeDir = System.getProperty("scsh3.exepath");
        File sysDir = exeDir != null ? new File(exeDir) : userDir;
        FileResourceLocatorFS frl = new FileResourceLocatorFS(sysDir, userDir);
        Engine engine = new Engine();
        engine.setFileResourceLocator(frl);
        try {
            engine.executeSetupScript("config.js");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage(re, System.err);
            return;
        }
        engine.initializeModule();
        ScriptExecutor se = new ScriptExecutor();
        se.start();
        CommandProcessor cp = new CommandProcessor();
        cp.setInputStream(System.in);
        cp.setOutputStream(System.out);
        cp.setScriptExecutor(se);
        do {
            Shell shell = (Shell)engine.newDynamicScope("Shell");
            shell.setOutputStream(System.out);
            cp.setShellObject(shell);
            cp.run();
        } while (cp.getLifeCycle() == 2);
        se.shutdown();
    }
}

