/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.utils;

import de.cardcontact.opencard.service.InstructionCodeTable;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.tlv.HexString;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;

public class GPAPDUTracer
implements APDUTracer {
    private String source;
    private GPTracer tracer;
    private String format = "";

    public GPAPDUTracer(String source, GPTracer tracer) {
        this.source = source;
        this.tracer = tracer;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public static String commandAPDUToString(CommandAPDU capdu) {
        StringBuffer sb = new StringBuffer(80);
        try {
            boolean extended = false;
            int len = capdu.getLength();
            byte[] buf = capdu.getBuffer();
            sb.append("C: ");
            sb.append(HexString.hexifyByteArray((byte[])buf, (char)' ', (int)4));
            sb.append(" - ");
            sb.append(InstructionCodeTable.instructionNameFromHeader((byte[])capdu.getBuffer()));
            int bodyoffset = 4;
            if ((len -= 4) > 0) {
                int l;
                int n = -1;
                if (buf[bodyoffset] == 0 && len > 1) {
                    if (len >= 3) {
                        n = ((buf[bodyoffset + 1] & 0xFF) << 8) + (buf[bodyoffset + 2] & 0xFF);
                        bodyoffset += 3;
                        len -= 3;
                        extended = true;
                    } else {
                        sb.append("Invalid extended length encoding for Lc\n");
                        sb.append(HexString.dump((byte[])buf, (int)bodyoffset, (int)len, (int)16, (int)6));
                    }
                } else {
                    n = buf[bodyoffset] & 0xFF;
                    ++bodyoffset;
                    --len;
                }
                if (len > 0) {
                    sb.append(" Lc=" + n + " " + (extended ? "Extended" : "") + "\n");
                    if (n > len) {
                        n = len;
                    }
                    int ins = capdu.getByte(1);
                    if (capdu.getByte(0) == 0 && (ins == 32 || ins == 36 || ins == 44) || capdu.getByte(0) == 128 && ins == 82 && capdu.getByte(2) == 0) {
                        sb.append("      *** Sensitive Information Removed ***");
                    } else {
                        sb.append(HexString.dump((byte[])buf, (int)bodyoffset, (int)n, (int)16, (int)6));
                    }
                    bodyoffset += n;
                    len -= n;
                    n = -1;
                    if (len > 0) {
                        if (extended) {
                            if (len >= 2) {
                                n = ((buf[bodyoffset] & 0xFF) << 8) + (buf[bodyoffset + 1] & 0xFF);
                                bodyoffset += 2;
                                len -= 2;
                            } else {
                                sb.append("Invalid extended length encoding for Le\n");
                                sb.append(HexString.dump((byte[])buf, (int)bodyoffset, (int)len, (int)16, (int)6));
                            }
                        } else {
                            n = buf[bodyoffset] & 0xFF;
                            ++bodyoffset;
                            --len;
                        }
                    }
                }
                if (n >= 0) {
                    sb.append("      Le=" + n + " " + (extended ? "Extended" : "") + "\n");
                }
                if (len > 0) {
                    sb.append("Unexpected bytes:\n");
                    sb.append(HexString.dump((byte[])buf, (int)bodyoffset, (int)len, (int)16, (int)6));
                }
                if (sb.charAt(l = sb.length() - 1) == '\n') {
                    sb.deleteCharAt(l);
                }
            }
        }
        catch (Exception e) {
            return "Error decoding APDU: " + e.getMessage();
        }
        return sb.toString();
    }

    public static String responseAPDUToString(ResponseAPDU rapdu) {
        try {
            int l;
            StringBuffer sb = new StringBuffer(80);
            int len = rapdu.getLength();
            byte[] buf = rapdu.getBuffer();
            sb.append("   R: ");
            sb.append(StatusWordTable.MessageForSW((int)rapdu.sw()));
            sb.append(" Lr=" + (len - 2));
            sb.append("\n");
            if (len > 2) {
                sb.append(HexString.dump((byte[])buf, (int)0, (int)(len - 2), (int)16, (int)6));
            }
            if (sb.charAt(l = sb.length() - 1) == '\n') {
                sb.deleteCharAt(l);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Error decoding APDU: " + e.getMessage();
        }
    }

    public void traceCommandAPDUPlain(SlotChannel sc, CommandAPDU capdu) {
        String s = "SC: ";
        s = s.concat(HexString.hexifyByteArray((byte[])capdu.getBytes(), (char)' '));
        this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
    }

    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO)) {
            if (this.format.length() == 0) {
                int slotId = 0;
                if (sc != null) {
                    slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
                }
                String s = HexString.hexifyByte((int)slotId);
                s = s.concat(" ");
                s = s.concat(GPAPDUTracer.commandAPDUToString(capdu));
                this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
            } else {
                this.traceCommandAPDUPlain(sc, capdu);
            }
        }
    }

    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO) && this.format.length() == 0) {
            String s = GPAPDUTracer.responseAPDUToString(rapdu);
            this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
        }
    }

    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO)) {
            int slotId = 0;
            if (sc != null) {
                slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
            }
            String s = HexString.hexifyByte((int)slotId);
            s = s.concat(" ATR: " + HexString.hexifyByteArray((byte[])cardID.getATR()));
            this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
        }
    }
}

