/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.tlv.PrimitiveTLV;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class JsX509
extends ScriptableObject
implements Wrapper {
    static final String clazzName = "X509";
    X509Certificate cert = null;

    public String getClassName() {
        return clazzName;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Object unwrap() {
        return this.cert;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"X509() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        JsX509 jsx509 = new JsX509();
        if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                jsx509.cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bs.getBytes()));
            }
            catch (CertificateException ce) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "Certificate invalid " + ce.getMessage());
            }
        } else if (args[0] instanceof CharSequence) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)ctorObj);
            String filename = gpr.mapFilename(Context.toString((Object)args[0]), 6);
            if (filename == null) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File " + Context.toString((Object)args[0]) + " not found");
            }
            File x509file = new File(filename);
            jsx509.cert = (X509Certificate)cf.generateCertificate(new FileInputStream(x509file));
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Argument must be of type ByteString or String");
        }
        return jsx509;
    }

    public String getIssuerDNString() {
        return this.cert.getIssuerDN().toString();
    }

    public static String jsFunction_getIssuerDNString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).getIssuerDNString();
    }

    public String getSubjectDNString() {
        return this.cert.getSubjectDN().toString();
    }

    public static String jsFunction_getSubjectDNString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).getSubjectDNString();
    }

    public byte[] getSerialNumber() {
        return this.cert.getSerialNumber().toByteArray();
    }

    public static ByteString jsFunction_getSerialNumber(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] serial = ((JsX509)thisObj).getSerialNumber();
        if (serial[0] == 0) {
            byte[] tmp = new byte[serial.length - 1];
            System.arraycopy(serial, 1, tmp, 0, serial.length - 1);
            serial = tmp;
        }
        return ByteString.newInstance(thisObj, serial);
    }

    public static String jsFunction_getSerialNumberString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).cert.getSerialNumber().toString();
    }

    public byte[] getSubjectKeyIdentifier() {
        byte[] ext = this.cert.getExtensionValue("2.5.29.14");
        if (ext == null) {
            return null;
        }
        SubjectKeyIdentifier skis = SubjectKeyIdentifier.getInstance((Object)ext);
        return skis.getKeyIdentifier();
    }

    public static ByteString jsFunction_getSubjectKeyIdentifier(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] kid = ((JsX509)thisObj).getSubjectKeyIdentifier();
        if (kid == null) {
            return null;
        }
        return ByteString.newInstance(thisObj, kid);
    }

    public byte[] getAuthorityKeyIdentifier() {
        AuthorityKeyIdentifierStructure akis;
        byte[] ext = this.cert.getExtensionValue("2.5.29.35");
        if (ext == null) {
            return null;
        }
        try {
            akis = new AuthorityKeyIdentifierStructure(ext);
        }
        catch (IOException ioe) {
            return null;
        }
        return akis.getKeyIdentifier();
    }

    public static ByteString jsFunction_getAuthorityKeyIdentifier(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] kid = ((JsX509)thisObj).getAuthorityKeyIdentifier();
        if (kid == null) {
            return null;
        }
        return ByteString.newInstance(thisObj, kid);
    }

    public static Scriptable jsFunction_getNotBefore(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        Date d = ((JsX509)thisObj).cert.getNotBefore();
        Object[] param = new Object[]{new Long(d.getTime())};
        return cx.newObject(thisObj, "Date", param);
    }

    public static Scriptable jsFunction_getNotAfter(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        Date d = ((JsX509)thisObj).cert.getNotAfter();
        Object[] param = new Object[]{new Long(d.getTime())};
        return cx.newObject(thisObj, "Date", param);
    }

    public String getOCSPResponderURL() {
        ASN1Sequence asn1;
        byte[] ocspext = this.cert.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (ocspext == null) {
            return null;
        }
        try {
            asn1 = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue((byte[])ocspext);
        }
        catch (IOException e) {
            return null;
        }
        asn1 = (ASN1Sequence)asn1.getObjectAt(0);
        ASN1TaggedObject tasn1 = (ASN1TaggedObject)asn1.getObjectAt(1);
        DEROctetString ostr = (DEROctetString)tasn1.getObject();
        String urlstr = new String(ostr.getOctets());
        return urlstr;
    }

    public static String jsFunction_getOCSPResponderURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).getOCSPResponderURL();
    }

    public static ByteString jsFunction_getBytes(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] encoded = null;
        try {
            encoded = ((JsX509)thisObj).cert.getEncoded();
        }
        catch (CertificateEncodingException cee) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Unable to encode certificate: " + cee.getMessage());
        }
        return ByteString.newInstance(thisObj, encoded);
    }

    public static void jsFunction_verifyWith(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type X509");
        }
        JsX509 thisCertObj = (JsX509)thisObj;
        JsX509 superiorCertObj = (JsX509)((Object)args[0]);
        try {
            thisCertObj.cert.verify(superiorCertObj.cert.getPublicKey(), "BC");
        }
        catch (CertificateException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Invalid Certificate: " + e);
        }
        catch (InvalidKeyException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Invalid Key: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "No such algorithm: " + e);
        }
        catch (NoSuchProviderException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "No such provider: " + e);
        }
        catch (SignatureException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Signature Exception: " + e);
        }
    }

    public static void jsFunction_verify(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type X509");
        }
        JsX509 thisCertObj = (JsX509)thisObj;
        GPKey publicKey = (GPKey)((Object)args[0]);
        try {
            thisCertObj.cert.verify((PublicKey)publicKey.getJCEKey("BC"));
        }
        catch (CertificateException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Invalid Certificate: " + e);
        }
        catch (InvalidKeyException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Invalid Key: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "No such algorithm: " + e);
        }
        catch (NoSuchProviderException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "No such provider: " + e);
        }
        catch (SignatureException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Signature Exception: " + e);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 12, 0, "Invalid public key: " + e);
        }
    }

    public static GPKey jsFunction_getPublicKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        X509Certificate x509 = ((JsX509)thisObj).cert;
        GPKey gpKey = null;
        if (args.length == 1) {
            if (args[0] instanceof GPKey) {
                gpKey = (GPKey)((Object)args[0]);
            } else {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type Key");
            }
        } else {
            Object[] param = new Object[]{};
            gpKey = (GPKey)cx.newObject(thisObj, "Key", param);
        }
        try {
            gpKey.setJCEKey(x509.getPublicKey());
            gpKey.setKeyType(3);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 12, 0, "Cannot extract key from certificate: " + e);
        }
        return gpKey;
    }

    public static boolean jsFunction_checkValidity(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        X509Certificate x509 = ((JsX509)thisObj).cert;
        byte[] encTime = null;
        if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            encTime = bs.getBytes();
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type Key");
        }
        Date d = null;
        try {
            PrimitiveTLV pt = new PrimitiveTLV(24, encTime);
            d = pt.getDate();
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Unable to decode time string: " + e.getMessage());
        }
        boolean timeValid = true;
        try {
            x509.checkValidity(d);
        }
        catch (Exception e) {
            timeValid = false;
        }
        return timeValid;
    }

    public static X509Certificate jsFunction_getNative(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).cert;
    }

    public String toString() {
        return this.cert.toString();
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsX509)thisObj).toString();
    }

    public static JsX509 newInstance(Scriptable scope, byte[] bytes) {
        Object[] params = new Object[]{ByteString.newInstance(scope, bytes)};
        Context cx = Context.getCurrentContext();
        return (JsX509)cx.newObject(scope, clazzName, params);
    }
}

