/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.Application;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPXML;
import de.cardcontact.scdp.utils.ArgChecker;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ApplicationFactory
extends ScriptableObject {
    private static final long serialVersionUID = 6727961347572604890L;
    static final String clazzName = "ApplicationFactory";
    GPCrypto crypto;
    HashMap<String, Scriptable> keyProfiles = new HashMap();
    HashMap<String, Scriptable> applicationProfiles = new HashMap();

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"ApplicationFactory() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof GPCrypto)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, 0, "Argument must be of type Crypto");
        }
        ApplicationFactory af = new ApplicationFactory();
        af.crypto = (GPCrypto)((Object)args[0]);
        return af;
    }

    public static void jsFunction_addKeyProfile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable profile;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] instanceof Scriptable) {
            profile = (Scriptable)args[0];
        } else {
            String profileName = ArgChecker.getString(thisObj, clazzName, args, 0, null);
            profile = GPXML.parse(thisObj, profileName);
        }
        Object o = GPXML.getObject(profile, "UniqueID");
        if (o == null || !(o instanceof CharSequence)) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Unable to find unique id in key profile");
        }
        ApplicationFactory af = (ApplicationFactory)thisObj;
        String uniqueId = ((CharSequence)o).toString();
        af.keyProfiles.put(uniqueId, profile);
    }

    public Scriptable getKeyForId(String profileId) {
        Scriptable profile = this.keyProfiles.get(profileId);
        if (profile == null) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Unable to find key profile for unique id " + profileId);
        }
        Object[] params = new Object[]{profile};
        return Context.getCurrentContext().newObject((Scriptable)this, "Key", params);
    }

    public static void jsFunction_addApplicationProfile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable profile;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (args[0] instanceof Scriptable) {
            profile = (Scriptable)args[0];
        } else {
            String profileName = ArgChecker.getString(thisObj, clazzName, args, 0, null);
            profile = GPXML.parseApplicationProfile(thisObj, profileName);
        }
        Object o = GPXML.getObject(profile, "UniqueID");
        if (o == null || !(o instanceof CharSequence)) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Unable to find unique id in application profile");
        }
        ApplicationFactory af = (ApplicationFactory)thisObj;
        String uniqueId = ((CharSequence)o).toString();
        af.applicationProfiles.put(uniqueId, profile);
    }

    public static Scriptable jsFunction_getApplicationInstance(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 4);
        ApplicationFactory af = (ApplicationFactory)thisObj;
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type Object");
        }
        Scriptable dataMapper = (Scriptable)args[0];
        if (!(args[1] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 2, "Argument must be of type ByteString");
        }
        ByteString aid = (ByteString)((Object)args[1]);
        Card card = null;
        ByteString uniqueId = null;
        if (args[2] instanceof Card) {
            card = (Card)((Object)args[2]);
        } else if (args[2] instanceof ByteString) {
            uniqueId = (ByteString)((Object)args[2]);
        } else {
            GPError.throwAsGPErrorEx(thisObj, 16, 3, "Argument must be either of type Card or ByteString");
        }
        if (args.length == 4) {
            if (!(args[3] instanceof ByteString)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 4, "Argument must be of type ByteString");
            }
            uniqueId = (ByteString)((Object)args[3]);
        }
        Scriptable profile = null;
        String strId = uniqueId == null ? "" : uniqueId.jsFunction_toString(16);
        profile = af.applicationProfiles.get(strId);
        if (profile == null) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, "Application profile " + strId + " not found");
        }
        Object[] param = new Object[]{thisObj, profile, aid, card, af.crypto, dataMapper};
        int type = GPXML.getObjectAsToken(profile, "ApplicationInfo.Type", "GP,OTHER");
        int subtype = GPXML.getObjectAsToken(profile, "ApplicationInfo.Subtype", "CM,SD,APP");
        Application ap = null;
        ap = type == 0 ? (subtype == 2 ? (Application)cx.newObject(thisObj, "GPApplication", param) : (Application)cx.newObject(thisObj, "GPSecurityDomain", param)) : (Application)cx.newObject(thisObj, "Application", param);
        return ap;
    }
}

