/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import opencard.core.OpenCardException;
import opencard.opt.iso.fs.CardFilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPairGenerator {

    public static class EC
    extends Key {
        private static final Logger log = LoggerFactory.getLogger(EC.class);
        private SmartCardHSMECPrivateKeySpec spec;

        public EC(SmartCardHSMProvider provider, String algorithm) {
            super(provider, algorithm);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            ECGenParameterSpec ecparam;
            switch (keysize) {
                case 192: {
                    ecparam = new ECGenParameterSpec("secp192r1");
                    break;
                }
                case 256: {
                    ecparam = new ECGenParameterSpec("secp256r1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported key size " + keysize);
                }
            }
            try {
                this.initialize(ecparam, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IllegalArgumentException("Invalid algorithm", e);
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec aps, SecureRandom random) throws InvalidAlgorithmParameterException {
            log.trace("initialize(spec, random) called...");
            if (aps instanceof SmartCardHSMParameterSpec) {
                SmartCardHSMParameterSpec scaps = (SmartCardHSMParameterSpec)aps;
                this.label = scaps.getLabel();
                this.spec = (SmartCardHSMECPrivateKeySpec)scaps.getKeySpec();
            } else if (aps instanceof ECGenParameterSpec || aps instanceof ECParameterSpec) {
                this.label = null;
                this.spec = new SmartCardHSMECPrivateKeySpec(aps);
            } else {
                throw new InvalidAlgorithmParameterException("Spec is not an instance of SmartCardHSMPrivateKeySpec, ECGenParameterSpec or ECParameterSpec");
            }
            this.spec.setAlgorithm(this.getAlgorithmFromString(this.algorithm));
        }

        @Override
        public KeyPair generateKeyPair() {
            PublicKey publicKey = null;
            try {
                byte keyid = this.determineID();
                log.debug("Generating key pair with key ID: " + keyid);
                byte[] encCert = this.schsm.generateKeyPair(keyid, (SmartCardHSMPrivateKeySpec)this.spec);
                if (this.spec.storePublicKey()) {
                    CardFilePath certPath = new CardFilePath(new byte[]{-50, keyid});
                    this.schsm.write(certPath, 0, encCert);
                }
                CardVerifiableCertificate cvc = new CardVerifiableCertificate(encCert);
                publicKey = cvc.getPublicKey();
                byte[] id = cvc.getSubjectPublicKeyIdentifier();
                KeyDescription prkd = new KeyDescription(id, this.label, (int)((short)this.spec.getKeySize()), KeyDescription.KeyTypes.EC);
                prkd.setKeyRef(keyid);
                this.schsm.storePRKD(keyid, prkd);
                this.privateKeyRef = new SmartCardHSMECKey(keyid, prkd.getTranslatedLabel(), (short)this.spec.getKeySize());
                if (this.spec.hasAlgorithmList()) {
                    this.privateKeyRef.setAlgorithms(this.spec.getAlgorithmList());
                }
                if (this.spec.hasKeyDomain()) {
                    this.privateKeyRef.setKeyDomain(this.spec.getKeyDomain());
                }
                if (this.spec.hasKeyUseCounter()) {
                    this.privateKeyRef.setKeyUseCounter(this.spec.getKeyUseCounter());
                }
                this.privateKeyRef.setKeyId(id);
                this.schsm.addKeyToMap((SmartCardHSMKey)this.privateKeyRef);
                this.schsm.addCertToMap((Certificate)cvc, true, keyid, this.label);
            }
            catch (OpenCardException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (CertificateException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            return new KeyPair(publicKey, (PrivateKey)this.privateKeyRef);
        }

        private byte[] getAlgorithmFromString(String algo) {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            map.put("ECDSA-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 1});
            map.put("ECDSA-SHA-224", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 2});
            map.put("ECDSA-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 3});
            map.put("ECDSA-SHA-384", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 4});
            map.put("ECDSA-SHA-512", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 5});
            return (byte[])map.get(algo);
        }
    }

    public static class RSA
    extends Key {
        private static final Logger log = LoggerFactory.getLogger(RSA.class);
        private SmartCardHSMRSAPrivateKeySpec spec;

        public RSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, algorithm);
        }

        @Override
        public KeyPair generateKeyPair() {
            PublicKey publicKey = null;
            try {
                byte keyid = this.determineID();
                log.debug("Generating key pair with key ID: " + keyid);
                byte[] encCert = this.schsm.generateKeyPair(keyid, (SmartCardHSMPrivateKeySpec)this.spec);
                CardFilePath certPath = new CardFilePath(new byte[]{-50, keyid});
                this.schsm.write(certPath, 0, encCert);
                CardVerifiableCertificate cvc = new CardVerifiableCertificate(encCert);
                publicKey = cvc.getPublicKey();
                byte[] id = cvc.getSubjectPublicKeyIdentifier();
                KeyDescription prkd = new KeyDescription(id, this.label, (int)((short)this.spec.getModulusSize()), KeyDescription.KeyTypes.RSA);
                prkd.setKeyRef(keyid);
                this.schsm.storePRKD(keyid, prkd);
                this.privateKeyRef = new SmartCardHSMRSAKey(keyid, prkd.getTranslatedLabel(), (short)this.spec.getModulusSize());
                if (this.spec.hasAlgorithmList()) {
                    this.privateKeyRef.setAlgorithms(this.spec.getAlgorithmList());
                }
                if (this.spec.hasKeyDomain()) {
                    this.privateKeyRef.setKeyDomain(this.spec.getKeyDomain());
                }
                if (this.spec.hasKeyUseCounter()) {
                    this.privateKeyRef.setKeyUseCounter(this.spec.getKeyUseCounter());
                }
                this.privateKeyRef.setKeyId(id);
                this.schsm.addKeyToMap((SmartCardHSMKey)this.privateKeyRef);
                this.schsm.addCertToMap((Certificate)cvc, true, keyid, this.label);
            }
            catch (OpenCardException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (CertificateException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            return new KeyPair(publicKey, (PrivateKey)this.privateKeyRef);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            if (random != null) {
                throw new ProviderException("Setting a random number generator is not supported");
            }
            this.spec = new SmartCardHSMRSAPrivateKeySpec(keysize);
        }

        private void initialize(int keysize) {
            this.initialize(keysize, null);
        }

        @Override
        public void initialize(AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
            log.trace("Entering initialize");
            if (!(spec instanceof SmartCardHSMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Spec is not an instance of SmartCardHSMPrivateKeySpec");
            }
            this.label = ((SmartCardHSMParameterSpec)spec).getLabel();
            this.spec = (SmartCardHSMRSAPrivateKeySpec)((SmartCardHSMParameterSpec)spec).getKeySpec();
            this.spec.setAlgorithm(this.getAlgorithmFromString(this.algorithm));
        }

        private byte[] getAlgorithmFromString(String algo) {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            map.put("PKCS1-v1-5-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 1});
            map.put("PKCS1-v1-5-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 2});
            map.put("PKCS1-v1-5-SHA-512", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 5});
            map.put("PKCS1-PSS-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 3});
            map.put("PKCS1-PSS-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 4});
            map.put("PKCS1-PSS-SHA-512", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 6});
            return (byte[])map.get(algo);
        }
    }

    public static abstract class Key
    extends KeyPairGeneratorSpi {
        protected static byte PRK_DEV_AUT = 0;
        protected SmartCardHSMCardService schsm;
        protected String label;
        protected SmartCardHSMPrivateKey privateKeyRef;
        protected String algorithm;

        public Key(SmartCardHSMProvider provider, String algorithm) {
            this.schsm = provider.getSmartCardHSMCardService();
            this.algorithm = algorithm;
            if (!provider.isVerified()) {
                throw new ProviderException("Login required.");
            }
        }

        protected byte determineID() throws OpenCardException {
            SmartCardHSMEntry entry = this.schsm.getSmartCardHSMEntry(this.label);
            if (entry == null) {
                return this.schsm.determineFreeKeyId();
            }
            throw new ProviderException("A key for label '" + this.label + "' does already exist");
        }
    }
}

