/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;

public class KeyGenerator
extends KeyGeneratorSpi {
    private SmartCardHSMProvider provider;
    private SmartCardHSMCardService schsm;
    private SmartCardHSMParameterSpec spec;

    public KeyGenerator(SmartCardHSMProvider provider, String algorithm) {
        this.provider = provider;
        this.schsm = provider.getSmartCardHSMCardService();
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new ProviderException("engineInit(SecureRandom random) not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (random != null) {
            throw new ProviderException("Setting a random number generator is not supported");
        }
        if (!(params instanceof SmartCardHSMParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Algorithm parameter must be instance of SmartCardHSMParameterSpec");
        }
        if (!(((SmartCardHSMParameterSpec)params).getKeySpec() instanceof SmartCardHSMSecretKeySpec)) {
            throw new InvalidAlgorithmParameterException("SmartCardHSMParameterSpec must contain SmartCardHSMSecretKeySpec");
        }
        this.spec = (SmartCardHSMParameterSpec)params;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new ProviderException("engineInit(SecureRandom random) not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        byte ref;
        SmartCardHSMSecretKeySpec skspec = (SmartCardHSMSecretKeySpec)this.spec.getKeySpec();
        byte[] cryptogram = null;
        try {
            ref = this.schsm.determineFreeKeyId();
            cryptogram = this.schsm.generateKey(ref, skspec);
        }
        catch (OpenCardException e) {
            throw new ProviderException("Generating key failed", e);
        }
        byte[] algorithms = skspec.getAlgorithmList();
        boolean hasSP800_56C = false;
        for (int i = 0; i < algorithms.length; ++i) {
            if (algorithms[i] != -103) continue;
            hasSP800_56C = true;
            break;
        }
        byte[] id = null;
        if (hasSP800_56C) {
            byte[] res;
            byte[] dparam = "KeyCheckValue".getBytes();
            try {
                res = this.schsm.deriveSymmetricKey(ref, (byte)-103, dparam);
            }
            catch (CardServiceException | CardTerminalException e) {
                throw new ProviderException("Deriving KCV failed", e);
            }
            id = new byte[8];
            System.arraycopy(res, 0, id, 0, id.length);
        }
        KeyDescription kd = new KeyDescription(id, this.spec.getLabel(), 0, KeyDescription.KeyTypes.AES);
        kd.setKeyRef(ref);
        try {
            this.schsm.storePRKD(ref, kd);
        }
        catch (OpenCardException e) {
            throw new ProviderException("Writing key description failed", e);
        }
        SmartCardHSMSecretKey keyRef = new SmartCardHSMSecretKey(ref, kd.getTranslatedLabel(), (short)skspec.getKeySize(), "AES");
        keyRef.setAlgorithms(algorithms);
        if (skspec.hasKeyDomain()) {
            keyRef.setKeyDomain(skspec.getKeyDomain());
        }
        if (skspec.hasKeyUseCounter()) {
            keyRef.setKeyUseCounter(skspec.getKeyUseCounter());
        }
        if (cryptogram != null && cryptogram.length > 0) {
            keyRef.setWrapCryptogram(cryptogram);
        }
        if (id != null) {
            keyRef.setKeyId(id);
        }
        this.schsm.addKeyToMap((SmartCardHSMKey)keyRef);
        return keyRef;
    }
}

