/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.server.jetty;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServer {
    static Logger log;
    protected Server server;
    protected String userDir;
    protected Properties config = new Properties();

    protected BaseServer() {
        this.userDir = System.getenv("USERDIR");
        if (this.userDir == null) {
            this.userDir = System.getProperty("user.dir");
        }
        System.out.println("Using " + this.userDir + " as user directory");
    }

    protected void configurePorts() throws Exception {
        String[] portlist;
        Object key = "server.ports";
        String list = this.config.getProperty((String)key);
        if (list == null) {
            throw new Exception("Could not find property " + (String)key + " with list of ports");
        }
        for (String portname : portlist = list.split("\\,")) {
            ServerConnector scc;
            key = "server." + portname + ".port";
            String v = this.config.getProperty((String)key);
            if (v == null) {
                throw new Exception("Could not find property " + (String)key);
            }
            int port = Integer.parseInt(v);
            key = "server." + portname + ".host";
            String host = v = this.config.getProperty((String)key);
            key = "server." + portname + ".keystore";
            v = this.config.getProperty((String)key);
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
            if (v == null) {
                scc = new ServerConnector(this.server, new ConnectionFactory[]{http11});
            } else {
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setKeyStorePath(this.userDir + "/" + v);
                key = "server." + portname + ".keystorepassword";
                v = this.config.getProperty((String)key);
                sslContextFactory.setKeyStorePassword(v);
                key = "server." + portname + ".truststore";
                v = this.config.getProperty((String)key);
                if (v != null) {
                    sslContextFactory.setTrustStorePath(this.userDir + "/" + v);
                    key = "server." + portname + ".truststorepassword";
                    v = this.config.getProperty((String)key);
                    sslContextFactory.setTrustStorePassword(v);
                    sslContextFactory.setNeedClientAuth(true);
                }
                SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
                scc = new ServerConnector(this.server, new ConnectionFactory[]{tls, http11});
            }
            scc.setPort(port);
            scc.setName(portname);
            scc.setHost(host);
            this.server.addConnector((Connector)scc);
        }
    }

    static void initLogBack(String fname) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(fname);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    protected void initLogging() {
        String fname = this.userDir + "/etc/logback.xml";
        File file = new File(fname);
        if (file.exists()) {
            System.out.println("Sourcing logback configuration from " + fname);
            BaseServer.initLogBack(fname);
        } else {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
            rootLogger.setLevel(Level.OFF);
        }
        log = LoggerFactory.getLogger(BaseServer.class);
    }

    protected void setConfigDefaults() {
        this.config.put("server.ports", "mainport");
        this.config.put("server.mainport.port", "8080");
        this.config.put("server.mainport.host", "127.0.0.1");
    }

    protected void loadConfig() throws IOException {
        File file = new File(this.userDir + "/etc/server.conf");
        if (!file.exists()) {
            log.info("Using default configuration");
            return;
        }
        FileInputStream fi = new FileInputStream(file);
        this.config.load(fi);
        fi.close();
    }

    protected void configureContext(ServletContextHandler context) {
    }

    protected void initServer(String[] args) throws Exception {
        String copyParams;
        this.server = new Server();
        this.configurePorts();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        String webContent = null;
        String userDir = System.getenv("USERDIR");
        if (userDir != null) {
            String fname = userDir + "/static";
            File file = new File(fname);
            if (file.exists()) {
                webContent = file.getAbsolutePath();
            }
            context.setInitParameter("userDir", userDir);
        }
        URL url = BaseServer.class.getClassLoader().getResource("WebContent");
        if (webContent == null && url != null) {
            webContent = url.toExternalForm();
        }
        if (url == null) {
            String fname;
            File file;
            String cwd = System.getProperty("user.dir");
            if (webContent == null && cwd != null && (file = new File(fname = cwd + "/static")).exists()) {
                webContent = file.getAbsolutePath();
            }
            context.setInitParameter("sysDir", cwd);
        }
        if (webContent != null) {
            log.info("Setting resource base to " + webContent);
            context.setResourceBase(webContent);
        }
        for (String s : copyParams = new String[]{"database.url", "database.user", "database.password"}) {
            context.setInitParameter(s, this.config.getProperty(s));
        }
        this.configureContext(context);
        this.server.setHandler((Handler)context);
        SessionHandler sh = context.getSessionHandler();
        sh.setMaxInactiveInterval(1800);
    }

    protected void start(String[] args) {
        try {
            this.initLogging();
            this.setConfigDefaults();
            this.loadConfig();
            this.initServer(args);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Problem starting server", (Throwable)e);
            }
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        BaseServer launcher = new BaseServer();
        launcher.start(args);
    }
}

