/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkihsmsrv;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import opencard.core.OpenCardException;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.util.APDUTracer;
import opencard.core.util.SLF4JAPDUTracer;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSMCardExecutor
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HSMCardExecutor.class);
    private SLF4JAPDUTracer apduTracer = new SLF4JAPDUTracer();
    private RemoteTerminal rt;
    private HSMService service;

    public HSMCardExecutor(RemoteTerminal rt, HSMService service) {
        this.rt = rt;
        this.service = service;
    }

    @Override
    public void run() {
        this.logger.debug("Card operation started.");
        SmartCard card = null;
        try {
            SmartCardHSMCardService schsm;
            CardTerminalEvent ctevent = new CardTerminalEvent((CardTerminal)this.rt, 1, 0);
            card = SmartCard.getSmartCard((CardTerminalEvent)ctevent, null, null);
            card.setAPDUTracer((APDUTracer)this.apduTracer);
            try {
                schsm = (SmartCardHSMCardService)card.getCardService(SmartCardHSMCardService.class, true);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("SmartCardHSMCardService not found", e);
            }
            SmartCardHSMProvider provider = new SmartCardHSMProvider("Session", false);
            provider.setSmartCardHSMCardService(schsm);
            this.service.addProvider(provider);
        }
        catch (Exception e) {
            this.logger.error("Card operation failed", (Throwable)e);
            try {
                this.rt.sendNotification(-1, e.getMessage(), 0);
            }
            catch (OpenCardException e2) {
                this.logger.error("Sending notification failed", (Throwable)e2);
            }
        }
    }
}

