/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkihsmsrv;

import de.cardcontact.opencard.service.KeyId;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import de.cardcontact.opencard.web.CardSessionFactory;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.security.cert.CertPathBuilderException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import opencard.core.OpenCardException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import org.openscdp.pkihsmsrv.HSMCardExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSMService
implements CardSessionFactory,
CTListener {
    private final Logger logger = LoggerFactory.getLogger(HSMService.class);
    private ConcurrentHashMap<String, SmartCardHSMProvider> providers = new ConcurrentHashMap();
    private ConcurrentHashMap<KeyId, CopyOnWriteArrayList<String>> keydomainmapping = new ConcurrentHashMap();
    private ConcurrentHashMap<RemoteTerminal, SmartCardHSMProvider> terminalmapping = new ConcurrentHashMap();
    private ExecutorService executor = Executors.newCachedThreadPool();

    public HSMService() {
        EventGenerator.getGenerator().addCTListener((CTListener)this);
    }

    public void newCardSession(HttpServletRequest request, RemoteTerminal remoteTerminal) throws ServletException {
        this.logger.debug("newCardSession() for " + remoteTerminal.toString());
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new ServletException("No active session");
        }
        HSMCardExecutor ex = new HSMCardExecutor(remoteTerminal, this);
        this.executor.submit(ex);
    }

    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.logger.debug(ctEvent.toString());
    }

    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        RemoteTerminal rt;
        SmartCardHSMProvider provider;
        this.logger.debug(ctEvent.toString());
        if (ctEvent.getCardTerminal() instanceof RemoteTerminal && (provider = this.terminalmapping.get(rt = (RemoteTerminal)ctEvent.getCardTerminal())) != null) {
            this.terminalmapping.remove(rt);
            this.removeProvider(provider);
        }
    }

    private void addKeyDomainMapping(byte[] keyDomainUID, String id) {
        KeyId kid = new KeyId(keyDomainUID);
        CopyOnWriteArrayList<String> list = this.keydomainmapping.get(kid);
        if (list == null) {
            list = new CopyOnWriteArrayList();
            this.keydomainmapping.put(kid, list);
        }
        if (!list.contains(id)) {
            list.add(id);
        }
    }

    public void addProvider(SmartCardHSMProvider provider) throws OpenCardException, CertPathBuilderException {
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        String id = service.getId();
        this.addKeyDomainMapping(service.getDefaultKeyDomainUID(), id);
        List kds = service.getKeyDomains();
        for (KeyDomain kd : kds) {
            byte[] kcvOrUID = kd.getKeyDomainUID();
            if (kcvOrUID == null) {
                kcvOrUID = kd.getKcv();
            }
            if (kcvOrUID == null) {
                this.logger.debug("Skip uninitialized key domain");
                continue;
            }
            this.addKeyDomainMapping(kcvOrUID, id);
        }
        this.providers.put(id, provider);
        CardChannel cc = service.getCardChannel();
        if (!cc.isOpen()) {
            cc.open();
        }
        RemoteTerminal rt = (RemoteTerminal)cc.getCardTerminal();
        this.terminalmapping.put(rt, provider);
        rt.sendNotification(0, "Provider added", 0);
        cc.close();
        this.logger.debug("Added provider " + id);
    }

    public void removeProvider(SmartCardHSMProvider provider) {
        try {
            String id = provider.getSmartCardHSMCardService().getId();
            this.providers.remove(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SmartCardHSMProvider getProvider(String path) {
        this.logger.debug("getProvider( " + path + " )");
        return this.providers.get(path);
    }

    public ArrayList<SmartCardHSMProvider> getProvider(byte[] keyDomain) {
        if (keyDomain == null || keyDomain.length == 0) {
            this.logger.error("getProvider() failed because of null or empty argument");
            throw new IllegalArgumentException();
        }
        List list = this.keydomainmapping.get(new KeyId(keyDomain));
        if (list == null) {
            return null;
        }
        ArrayList<SmartCardHSMProvider> providers = new ArrayList<SmartCardHSMProvider>(list.size());
        for (String path : list) {
            SmartCardHSMProvider prov = this.getProvider(path);
            if (prov == null) continue;
            providers.add(prov);
        }
        return providers;
    }
}

