/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkihsmsrv;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import de.cardcontact.opencard.web.CardSessionFactory;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.security.Provider;
import java.security.cert.CertPathBuilderException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import opencard.core.OpenCardException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import org.openscdp.pkihsmsrv.HSMCardExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSMService
implements CardSessionFactory,
CTListener {
    private final Logger logger = LoggerFactory.getLogger(HSMService.class);
    private ConcurrentHashMap<String, SmartCardHSMProvider> providers = new ConcurrentHashMap();
    private ExecutorService executor = Executors.newCachedThreadPool();

    public void newCardSession(HttpServletRequest request, RemoteTerminal remoteTerminal) throws ServletException {
        this.logger.debug("newCardSession() for " + remoteTerminal.toString());
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new ServletException("No active session");
        }
        HSMCardExecutor ex = new HSMCardExecutor(remoteTerminal, this);
        this.executor.submit(ex);
    }

    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.logger.debug(ctEvent.toString());
    }

    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.logger.debug(ctEvent.toString());
    }

    public void addProvider(SmartCardHSMProvider provider) throws OpenCardException, CertPathBuilderException {
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        String id = service.getId();
        String path = id.substring(id.indexOf("/", 1));
        this.providers.put(path, provider);
        CardChannel cc = service.getCardChannel();
        if (!cc.isOpen()) {
            cc.open();
        }
        RemoteTerminal rt = (RemoteTerminal)cc.getCardTerminal();
        rt.sendNotification(0, "Provider added", 0);
        cc.close();
        this.logger.debug("Added provider " + path);
    }

    public SmartCardHSMProvider getProvider(String path) {
        this.logger.debug("getProvider( " + path + " )");
        return this.providers.get(path);
    }

    public SmartCardHSMProvider getProvider(byte[] keyDomain) {
        if (keyDomain == null || keyDomain.length == 0) {
            this.logger.error("getProvider() failed because of null or empty argument");
            throw new IllegalArgumentException();
        }
        this.logger.debug("getProvider( " + HexString.dump((byte[])keyDomain) + " )");
        this.logger.debug("Number of providers: " + this.providers.size());
        LinkedList<SmartCardHSMProvider> removalList = new LinkedList<SmartCardHSMProvider>();
        for (SmartCardHSMProvider smartCardHSMProvider : this.providers.values()) {
            SmartCardHSMCardService service = smartCardHSMProvider.getSmartCardHSMCardService();
            CardChannel cc = service.getCardChannel();
            if (!cc.isOpen()) {
                cc.open();
            }
            RemoteTerminal rt = (RemoteTerminal)cc.getCardTerminal();
            cc.close();
            try {
                if (!rt.isCardPresent(0)) {
                    this.logger.debug("Provider " + smartCardHSMProvider.getName() + " ");
                    removalList.add(smartCardHSMProvider);
                    continue;
                }
                List kds = service.getKeyDomains();
                for (KeyDomain kd : kds) {
                    byte[] kcvOrUID = kd.getKeyDomainUID();
                    if (kcvOrUID == null) {
                        kcvOrUID = kd.getKcv();
                    }
                    if (kcvOrUID == null) {
                        this.logger.debug("Skip uninitialized key domain");
                        continue;
                    }
                    this.logger.debug("compare with " + HexString.dump((byte[])kcvOrUID));
                    if (!Arrays.equals(kcvOrUID, keyDomain)) continue;
                    return smartCardHSMProvider;
                }
            }
            catch (OpenCardException e) {
                this.logger.warn("Error processing provider", (Throwable)e);
                removalList.add(smartCardHSMProvider);
                try {
                    rt.sendNotification(-1, e.getMessage(), 0);
                    service.getCard().close();
                }
                catch (CardTerminalException e1) {
                    this.logger.error("Closing card failed", (Throwable)e1);
                }
            }
        }
        for (Provider provider : removalList) {
            this.providers.remove(provider);
        }
        this.logger.debug("No provider found for keyDomain " + HexString.dump((byte[])keyDomain));
        return null;
    }
}

