/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Constructor;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.holder.Holder;
import org.openscdp.pkidm.holder.HolderContent;
import org.openscdp.pkidm.signer.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolderBase
implements Holder {
    final Logger logger = LoggerFactory.getLogger(HolderBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected HolderDTO dto;
    protected CertificateDTO currentCertificateDTO;
    protected Holder parent;

    public HolderBase(HolderDTO dto) {
        this.dto = dto;
    }

    public Long getId() {
        return this.dto.getId();
    }

    public String getName() {
        return this.dto.getName();
    }

    protected <T extends Holder> T getParent(Class<T> type) {
        if (this.parent == null && this.dto.getParentId() != null) {
            this.parent = PKIDMContext.getHolderFactoryRegistry().getById(this.dto.getParentId(), type);
        }
        return (T)((Holder)type.cast(this.parent));
    }

    public long countChilds() {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            long l = dao.countSubHolder(this.getId());
            return l;
        }
    }

    protected CertificateDTO getCurrentCertificateDTO() {
        if (this.currentCertificateDTO == null && this.dto.getCertId() != null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
                this.currentCertificateDTO = dao.getCertificate(this.dto.getCertId());
            }
        }
        return this.currentCertificateDTO;
    }

    protected byte[] getCurrentKeyId() {
        this.getCurrentCertificateDTO();
        if (this.currentCertificateDTO == null) {
            throw new RuntimeException("Holder does not have an active certificate");
        }
        return this.currentCertificateDTO.getKeyId();
    }

    protected CertificateDTO getNextCertificateDTO() {
        CertificateDTO nextCertificateDTO;
        this.getCurrentCertificateDTO();
        if (this.currentCertificateDTO == null) {
            throw new RuntimeException("Holder does not have an active certificate");
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO dao = (CertificateDAO)handle.attach(CertificateDAO.class);
            nextCertificateDTO = dao.getNextCertificate(this.dto.getId(), this.dto.getCertId());
        }
        return nextCertificateDTO;
    }

    protected void setCurrentCertificate(Long certId) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            dao.updateCurrentCertificate(certId, this.dto.getId());
        }
        this.dto.setCertId(certId);
        this.currentCertificateDTO = null;
    }

    protected <T extends Signer> T getSigner(byte[] keyId, Class<T> type) {
        Signer result;
        SignerDTO signerDTO;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
            signerDTO = dao.getSignerByHolderAndKeyId(this.getId(), keyId);
        }
        if (signerDTO == null) {
            return null;
        }
        try {
            Constructor<T> cons = type.getConstructor(SignerDTO.class);
            result = (Signer)cons.newInstance(signerDTO);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not construct signer for type " + type.descriptorString(), e);
        }
        return (T)result;
    }

    public int countSigner() {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
            Long cnt = dao.countSigner(this.getId());
            int n = cnt.intValue();
            return n;
        }
    }

    protected <T extends HolderContent> T parseContent(Class<T> clazz) {
        try {
            return (T)((HolderContent)om.readValue(this.dto.getContent(), clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(HolderContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            dao.updateContent(jsonstr, this.getId());
        }
    }
}

