/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm;

import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidm.ApplicationContext;
import org.openscdp.pkidm.holder.HolderFactoryRegistry;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.openscdp.pkihsmsrv.HSMService;

public class PKIDMContext {
    private static PKIDMContext instance = null;
    private Jdbi jdbi;
    private ApplicationContext applicationContext;
    private ServiceRequestFactoryRegistry serviceRequestFactoryRegistry = new ServiceRequestFactoryRegistry();
    private SubjectFactoryRegistry subjectFactoryRegistry = new SubjectFactoryRegistry();
    private HolderFactoryRegistry holderFactoryRegistry = new HolderFactoryRegistry();
    private HSMService hsmService;

    private PKIDMContext() {
    }

    public static PKIDMContext getInstance() {
        if (instance == null) {
            instance = new PKIDMContext();
        }
        return instance;
    }

    public static void setJDBI(Jdbi jdbi) {
        PKIDMContext.getInstance().jdbi = jdbi;
    }

    public static Jdbi getJDBI() {
        return PKIDMContext.getInstance().jdbi;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        PKIDMContext.getInstance().applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return PKIDMContext.getInstance().applicationContext;
    }

    private ServiceRequestFactoryRegistry getInitializedServiceRequestFactoryRegistry() {
        this.serviceRequestFactoryRegistry.setJDBI(this.jdbi);
        return this.serviceRequestFactoryRegistry;
    }

    public static ServiceRequestFactoryRegistry getServiceRequestFactoryRegistry() {
        return PKIDMContext.getInstance().getInitializedServiceRequestFactoryRegistry();
    }

    private SubjectFactoryRegistry getInitializedSubjectFactoryRegistry() {
        this.subjectFactoryRegistry.setJDBI(this.jdbi);
        return this.subjectFactoryRegistry;
    }

    public static SubjectFactoryRegistry getSubjectFactoryRegistry() {
        return PKIDMContext.getInstance().getInitializedSubjectFactoryRegistry();
    }

    private HolderFactoryRegistry getInitializedHolderFactoryRegistry() {
        this.holderFactoryRegistry.setJDBI(this.jdbi);
        return this.holderFactoryRegistry;
    }

    public static HolderFactoryRegistry getHolderFactoryRegistry() {
        return PKIDMContext.getInstance().getInitializedHolderFactoryRegistry();
    }

    public static void setHSMService(HSMService hsmService) {
        PKIDMContext.getInstance().hsmService = hsmService;
    }

    public static HSMService getHSMService() {
        return PKIDMContext.getInstance().hsmService;
    }
}

