/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.servicerequest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceRequestBase
implements ServiceRequest {
    final Logger logger = LoggerFactory.getLogger(ServiceRequestBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected ServiceRequestDTO dto;

    protected ServiceRequestBase(ServiceRequestDTO dto) {
        this.dto = dto;
    }

    public Long getId() {
        return this.dto.getId();
    }

    protected <T extends ServiceRequestContent> T parseContent(Class<T> clazz) {
        try {
            return (T)((ServiceRequestContent)om.readValue(this.dto.getContent(), clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setStatusInfo(String info) {
        this.dto.setState(info);
    }

    public int getLifeCycle() {
        return this.dto.getLifecycle();
    }

    public void setLifeCycle(int state) {
        this.dto.setLifecycle(Integer.valueOf(state));
    }

    public void commit(Long subjectId, ServiceRequestStateContent content) {
        String jsonstr;
        if (content != null) {
            ObjectMapper om = new ObjectMapper();
            om.enable(SerializationFeature.INDENT_OUTPUT);
            try {
                jsonstr = om.writeValueAsString((Object)content);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Error setting content", (Throwable)e);
                throw new RuntimeException("Error setting content", e);
            }
        } else {
            jsonstr = "{}";
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.addLifeCycleTransition(this.dto, subjectId, jsonstr);
        }
    }
}

