/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.openscdp.pkidm.cvc.CryptoProviderException;

public interface CryptoProvider {
    public Provider getProvider();

    public KeyPair generateKeyPair(AlgorithmParameterSpec var1, String var2) throws CryptoProviderException;

    public PrivateKey getPrivateKey(byte[] var1, byte[] var2, byte[] var3) throws CryptoProviderException;

    default public PrivateKey getPrivateKey(byte[] pkcs8EncodedKey) throws CryptoProviderException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pkcs8EncodedKey);
        String algo = spec.getAlgorithm();
        try {
            KeyFactory kf = KeyFactory.getInstance("EC", this.getProvider());
            PrivateKey prk = kf.generatePrivate(spec);
            return prk;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoProviderException("get private key failed with", e);
        }
    }
}

